/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.FacetFinderImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.framework.JavaeeFrameworkGroup;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.xml.Description;
import com.intellij.javaee.model.xml.DescriptionOwner;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileAdapter;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeUtil
extends FacetUtil {
    @NonNls
    public static final String JAVAEE_FRAMEWORK_GROUP = JavaeeFrameworkGroup.INSTANCE.getId();
    @NonNls
    public static final String GET_PREFIX = "get";
    @NonNls
    public static final String SET_PREFIX = "set";

    @Nullable
    public static String getRootTagNS(@Nullable PsiFile xmlFile, @NotNull String rootTagName) {
        if (rootTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTagName", "com/intellij/javaee/JavaeeUtil", "getRootTagNS"));
        }
        if (!(xmlFile instanceof XmlFile) || !xmlFile.isValid()) {
            return null;
        }
        XmlDocument document = ((XmlFile)xmlFile).getDocument();
        if (document == null) {
            return null;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null || !rootTagName.equals(rootTag.getLocalName())) {
            return null;
        }
        return rootTag.getNamespace();
    }

    @Nullable
    public static VirtualFile findResource(Module module, String resourceName) {
        VirtualFile root;
        VirtualFile result = null;
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        int n = virtualFileArray.length;
        for (int i = 0; i < n && (result = (root = virtualFileArray[i]).findFileByRelativePath(resourceName)) == null; ++i) {
        }
        return result;
    }

    @Nullable
    public static String getDescription(DescriptionOwner owner) {
        List list = owner.getDescriptions();
        return list.isEmpty() ? null : ((Description)list.get(0)).getValue();
    }

    public static void setDescription(DescriptionOwner owner, String description) {
        List list = owner.getDescriptions();
        if (StringUtil.isEmpty((String)description)) {
            for (Description description1 : list) {
                description1.undefine();
            }
        } else if (list.isEmpty()) {
            owner.addDescription().setValue(description);
        } else {
            ((Description)list.get(0)).setValue(description);
        }
    }

    public static String suggestGetterName(String name) {
        return GET_PREFIX + StringUtil.capitalize((String)name);
    }

    public static String suggestSetterName(String name) {
        return SET_PREFIX + StringUtil.capitalize((String)name);
    }

    public static String getJavaeeObjectDescription(Object value, Function<DomElement, DomElement> domElementMutator) {
        String text;
        String unknown = "unknown";
        if (value instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)value;
            String qname = psiAnnotation.isValid() ? psiAnnotation.getQualifiedName() : null;
            text = "@" + (qname == null ? "unknown" : qname);
        } else if (value instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)value;
            String tagName = xmlTag.isValid() ? xmlTag.getName() : null;
            text = "<" + tagName + ">";
        } else if (value instanceof AnnotationGenericValue) {
            PsiAnnotation psiAnnotation = ((AnnotationGenericValue)((Object)value)).getIdentifyingAnnotation();
            String qname = psiAnnotation != null && psiAnnotation.isValid() ? psiAnnotation.getQualifiedName() : null;
            text = "@" + (qname == null ? "unknown" : qname);
        } else if (value instanceof DomElement) {
            DomElement domValue = (DomElement)domElementMutator.fun((Object)((DomElement)value));
            text = "<" + (domValue != null ? domValue.getXmlElementName() : "unknown") + ">";
        } else {
            text = "unknown";
        }
        return text;
    }

    public static String getDefaultDescriptorPath(ConfigFileMetaData deploymentDescriptorMetaData) {
        return deploymentDescriptorMetaData.getDirectoryPath() + "/" + deploymentDescriptorMetaData.getFileName();
    }

    @Nullable
    public static VirtualFile findExistingDescriptorRoot(Module module, ConfigFileMetaData metaData) {
        String path = metaData.getDirectoryPath();
        int idx = path.indexOf(47);
        final String parent = idx == -1 ? path : path.substring(0, idx);
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        Condition<VirtualFile> condition = new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return virtualFile.findChild(parent) != null;
            }
        };
        VirtualFile firstTry = (VirtualFile)ContainerUtil.find((Object[])rootManager.getContentRoots(), (Condition)condition);
        return firstTry != null ? firstTry : (VirtualFile)ContainerUtil.find((Object[])rootManager.getSourceRoots(), (Condition)condition);
    }

    @Nullable
    public static String getClassPresentableText(GenericValue<PsiClass> value, boolean showPackage, boolean showName) {
        PsiClass psiClass = (PsiClass)value.getValue();
        if (psiClass != null) {
            if (showPackage && showName) {
                return psiClass.getQualifiedName();
            }
            if (showName) {
                return psiClass.getName();
            }
            PsiDirectory psiDirectory = psiClass.getContainingFile().getContainingDirectory();
            PsiPackage psiPackage = psiDirectory == null ? null : JavaDirectoryService.getInstance().getPackage(psiDirectory);
            return psiPackage == null ? null : psiPackage.getQualifiedName();
        }
        String text = value.getStringValue();
        if (text != null) {
            if (showPackage && showName) {
                return text;
            }
            if (showName) {
                return PsiNameHelper.getShortClassName((String)text);
            }
            if (showPackage) {
                int index = text.lastIndexOf(46);
                return index < 1 ? "" : text.substring(0, index);
            }
        }
        return null;
    }

    public static ModificationTracker getAllJavaeeFacetModificationTracker(Project project) {
        final FacetFinderImpl finder = (FacetFinderImpl)FacetFinder.getInstance((Project)project);
        return new ModificationTracker(){

            public long getModificationCount() {
                long count = 0L;
                count += finder.getAllFacetsOfTypeModificationTracker(JavaeeApplicationFacet.ID).getModificationCount();
                count += finder.getAllFacetsOfTypeModificationTracker(WebFacet.ID).getModificationCount();
                return count += finder.getAllFacetsOfTypeModificationTracker(EjbFacet.ID).getModificationCount();
            }
        };
    }

    public static void fireFacetChanged(JavaeeFacet facet) {
        Module module = facet.getModule();
        if (!module.isDisposed() && !module.getProject().isDisposed()) {
            ((FacetManagerListener)module.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged((Facet)facet);
        }
    }

    public static String getFacetWithModuleNameDetailed(@NotNull JavaeeFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/JavaeeUtil", "getFacetWithModuleNameDetailed"));
        }
        return J2EEBundle.message((String)"facet.0.in.module.1.text.detailed", (Object[])new Object[]{facet.getName(), facet.getModule().getName()});
    }

    public static String getFacetWithModuleName(@Nullable JavaeeFacet facet) {
        if (facet == null) {
            return "";
        }
        return J2EEBundle.message((String)"facet.0.in.module.1.text", (Object[])new Object[]{facet.getName(), facet.getModule().getName()});
    }

    public static String suggestArtifactName(@NotNull String moduleName, @Nullable String facetName, @NotNull FacetTypeId<? extends JavaeeFacet> typeId) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javaee/JavaeeUtil", "suggestArtifactName"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/javaee/JavaeeUtil", "suggestArtifactName"));
        }
        String type = facetName != null ? facetName : (typeId == WebFacet.ID ? "war" : (typeId == EjbFacet.ID ? "ejb" : (typeId == JavaeeApplicationFacet.ID ? "ear" : "")));
        return moduleName + ":" + type + " exploded";
    }

    public static void installDomAndJamListeners(final @NotNull Facet facet, @Nullable ConfigFileContainer descriptorsContainer) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/JavaeeUtil", "installDomAndJamListeners"));
        }
        Project project = facet.getModule().getProject();
        DomManager.getDomManager((Project)project).addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                FacetModificationTrackingService.getInstance((Facet)facet).incFacetModificationTracker(facet);
            }
        }, (Disposable)facet);
        facet.getModule().getProject().getMessageBus().connect((Disposable)facet).subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                FacetModificationTrackingService.getInstance((Facet)facet).incFacetModificationTracker(facet);
            }
        });
        if (descriptorsContainer != null) {
            descriptorsContainer.addListener((ConfigFileListener)new ConfigFileAdapter(){

                protected void configChanged(ConfigFile configFile) {
                    FacetModificationTrackingService.getInstance((Facet)facet).incFacetModificationTracker(facet);
                }
            }, (Disposable)facet);
        }
    }

    public static void selectPath(final AbstractTreeBuilder builder, final Object[] path) {
        if (builder.isDisposed()) {
            return;
        }
        Runnable runnable = new Runnable(){
            int index;
            Object current;
            Object expected;

            @Override
            public void run() {
                Object[] objectArray;
                if (this.current == null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = builder.getTreeStructure().getRootElement();
                } else {
                    objectArray = builder.getTreeStructure().getChildElements(this.current);
                }
                Object[] children = objectArray;
                this.expected = path[this.index++];
                for (Object child : children) {
                    Object element;
                    Object object = element = child instanceof SimpleNode ? ((SimpleNode)child).getElement() : child;
                    if (!Comparing.equal((Object)element, (Object)this.expected)) continue;
                    if (this.index == path.length) {
                        builder.select(child);
                    } else {
                        this.current = child;
                        builder.expand(element, (Runnable)this);
                    }
                    return;
                }
            }
        };
        builder.queueUpdate().doWhenDone(runnable);
    }
}

