/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.DataManager;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersUtil;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.supportProvider.AddAppServerSupportUtil;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.run.configuration.J2EEConfigurationType;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerPanel {
    private JPanel myPanel;
    private JComboBox myComboBox;
    private JButton myNewButton;
    private JBLabel myLabel;

    public ApplicationServerPanel() {
        this.$$$setupUI$$$();
    }

    public ApplicationServerPanel initialize() {
        final List<ApplicationServer> servers = ApplicationServerPanel.getSuitableServers();
        DefaultComboBoxModel<ApplicationServer> model = new DefaultComboBoxModel<ApplicationServer>(servers.toArray(new ApplicationServer[servers.size()]));
        this.myComboBox.setModel(model);
        this.myNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppServerIntegration[] integrations = AppServerIntegrationsManager.getInstance().getAllIntegrations();
                DefaultActionGroup group = new DefaultActionGroup();
                for (final AppServerIntegration integration : integrations) {
                    group.add(new AnAction(integration.getPresentableName(), integration.getPresentableName(), integration.getIcon()){

                        public void actionPerformed(AnActionEvent e) {
                            final ApplicationServersManager.ApplicationServersManagerModifiableModel model = ApplicationServersManager.getInstance().createModifiableModel();
                            ApplicationServerImpl server = ApplicationServersUtil.createNewApplicationServer(integration, model, servers, ApplicationServerPanel.this.myPanel);
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    model.commit();
                                }
                            });
                            if (server != null) {
                                ApplicationServerPanel.this.myComboBox.addItem(server);
                                ApplicationServerPanel.this.myComboBox.setSelectedItem(server);
                            }
                        }
                    });
                }
                JBPopupFactory.getInstance().createActionGroupPopup("New Server", (ActionGroup)group, DataManager.getInstance().getDataContext((Component)ApplicationServerPanel.this.myPanel), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showUnderneathOf((Component)ApplicationServerPanel.this.myNewButton);
            }
        });
        return this;
    }

    public void addServerSelectionListener(ActionListener listener) {
        this.myComboBox.addActionListener(listener);
    }

    private static List<ApplicationServer> getSuitableServers() {
        ArrayList<ApplicationServer> servers = new ArrayList<ApplicationServer>();
        for (ApplicationServer server : ApplicationServersManager.getInstance().getApplicationServers()) {
            AppServerIntegration integration = server.getSourceIntegration();
            if (integration == null || !ApplicationServerPanel.isSuitableIntegration(integration)) continue;
            servers.add(server);
        }
        Collections.sort(servers, AddAppServerSupportUtil.createAppServerComparator());
        return servers;
    }

    private static boolean isSuitableIntegration(AppServerIntegration integration) {
        return ApplicationServerPanel.findLocalConfigurationFactory(integration) != null;
    }

    @Nullable
    public static ConfigurationFactory findLocalConfigurationFactory(AppServerIntegration integration) {
        for (ConfigurationType type : (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
            if (!(type instanceof J2EEConfigurationType) || !integration.equals(((J2EEConfigurationType)type).getIntegration())) continue;
            return ((J2EEConfigurationType)type).getLocalFactory();
        }
        return null;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    public ApplicationServer getSelectedServer() {
        return (ApplicationServer)this.myComboBox.getSelectedItem();
    }

    public JBLabel getLabel() {
        return this.myLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), 4, 4, false, false));
        this.myLabel = jBLabel = new JBLabel();
        jBLabel.setText("Application Server:");
        jBLabel.setDisplayedMnemonic('R');
        jBLabel.setDisplayedMnemonicIndex(14);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, new Dimension(200, -1), null));
        this.myNewButton = jButton = new JButton();
        jButton.setText("New...");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

