/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.InterceptorMethodType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbInterceptorInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.interceptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbInterceptorInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection", "getShortName"));
        }
        return "EjbInterceptorInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EjbClassRoleEnum type = role.getType();
            if (type != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS && type != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbHighlightUtil.checkClassIsInterface(holder, aClass, false);
                EjbHighlightUtil.checkPublicNoArgsConstructorDefined(holder, aClass);
                EjbInterceptorInspection.checkInterceptorMethods(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }
        };
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        boolean ejbClass = false;
        boolean interceptorClass = false;
        boolean standardOnly = false;
        for (EjbClassRole role : classRoles) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                standardOnly = false;
                interceptorClass = true;
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            if (!standardOnly) {
                standardOnly = EjbUtil.implementsStandardEjbInterface(role.getEnterpriseBean());
            }
            ejbClass = true;
        }
        if (ejbClass == interceptorClass) {
            if (ejbClass) {
                holder.registerProblem((PsiElement)aClass.getNameIdentifier(), EjbHighlightingMessages.message("class.both.ejb.and.interceptor", aClass.getName()), new LocalQuickFix[0]);
            }
            return;
        }
        EjbInterceptorInspection.checkInterceptorMethods(holder, aClass, EjbInterceptorInspection.buildInterceptorMethodsMap(classRoles, aClass), !ejbClass, standardOnly);
    }

    public static HashMap<InterceptorMethodType, List<InterceptorMethod>> buildInterceptorMethodsMap(EjbClassRole[] classRoles, PsiClass aClass) {
        final HashMap<InterceptorMethodType, List<InterceptorMethod>> map = new HashMap<InterceptorMethodType, List<InterceptorMethod>>();
        Processor<InterceptorMethod> processor = new Processor<InterceptorMethod>(){

            public boolean process(InterceptorMethod t) {
                ArrayList<InterceptorMethod> list = (ArrayList<InterceptorMethod>)map.get(t.getType());
                if (list == null) {
                    list = new ArrayList<InterceptorMethod>();
                    map.put(t.getType(), list);
                }
                if (!list.contains(t)) {
                    list.add(t);
                }
                return true;
            }
        };
        for (EjbClassRole role : classRoles) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                role.getInterceptor().processInterceptorMethods(aClass, (Processor)processor);
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            role.getEnterpriseBean().processInterceptorMethods(aClass, (Processor)processor);
        }
        return map;
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, PsiClass aClass, HashMap<InterceptorMethodType, List<InterceptorMethod>> map, boolean separateClass, boolean standardNamesOnly) {
        for (Map.Entry<InterceptorMethodType, List<InterceptorMethod>> entry : map.entrySet()) {
            List<InterceptorMethod> list = entry.getValue();
            if (list.size() > 1) {
                HashSet<PsiMethod> set = new HashSet<PsiMethod>();
                for (InterceptorMethod method : list) {
                    set.add(method.getMethod());
                }
                if (set.size() > 1) {
                    for (InterceptorMethod method : list) {
                        holder.registerProblem((PsiElement)method.getMethod().getNameIdentifier(), EjbHighlightingMessages.message("more.than.one.method.defined.for.interceptor.method.type", entry.getKey().getTypeName(), method.getMethod().getContainingClass().getName()), new LocalQuickFix[]{EjbInterceptorInspection.createRemoveElementQuickFix(method)});
                    }
                }
            }
            for (InterceptorMethod method : list) {
                if (!separateClass) {
                    String requiredName;
                    String methodName = method.getMethod().getName();
                    if (standardNamesOnly && (requiredName = method.getType().getMethodStandardName()) != null && !requiredName.equals(methodName)) {
                        holder.registerProblem((PsiElement)method.getMethod().getNameIdentifier(), EjbHighlightingMessages.message("interceptor.method.name.should.be.standard", method.getType().getTypeName(), requiredName), new LocalQuickFix[0]);
                    }
                }
                EjbInterceptorInspection.checkInterceptorMethodSignature(holder, method.getMethod(), separateClass, method.getType());
            }
        }
    }

    private static LocalQuickFix createRemoveElementQuickFix(final InterceptorMethod method) {
        final String name = EjbHighlightingMessages.message("text.remove.0", JavaeeUtil.getJavaeeObjectDescription(method.getDefiningElement(), (Function<DomElement, DomElement>)FunctionUtil.id()));
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection$3", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = EjbHighlightingMessages.message("intention.family.remove.interceptor.method.metadata", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection$3", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection$3", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection$3", "applyFix"));
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)method.getContainingFile())) {
                    return;
                }
                method.delete();
            }
        };
    }

    private static void checkInterceptorMethodSignature(ProblemsHolder holder, PsiMethod psiMethod, boolean separateClass, InterceptorMethodType type) {
        EjbHighlightUtil.checkMethodModifier(holder, psiMethod, "final", false);
        EjbHighlightUtil.checkMethodModifier(holder, psiMethod, "static", false);
        if (separateClass || type == InterceptorMethodType.AROUND_INVOKE) {
            PsiClass invocationContext = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)psiMethod, "javax.interceptor.InvocationContext");
            if (invocationContext != null) {
                EjbHighlightUtil.checkMethodParameters(holder, psiMethod, new PsiType[]{JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getElementFactory().createType(invocationContext)});
            }
        } else {
            EjbHighlightUtil.checkMethodParameters(holder, psiMethod, PsiType.EMPTY_ARRAY);
        }
        if (type == InterceptorMethodType.AROUND_INVOKE) {
            EjbHighlightUtil.checkMethodReturns(holder, psiMethod, "java.lang.Object");
        } else {
            EjbHighlightUtil.checkMethodReturns(holder, psiMethod, (PsiType)PsiType.VOID);
            EjbInterceptorInspection.checkMethodThrows(holder, psiMethod, Collections.emptySet());
        }
    }

    private static void checkMethodThrows(ProblemsHolder holder, PsiMethod method, Set<String> allowedExceptions) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        for (PsiJavaCodeReferenceElement element : method.getThrowsList().getReferenceElements()) {
            PsiClassType type = psiElementFactory.createType(element);
            if (ExceptionUtil.isUncheckedException((PsiClassType)type) || allowedExceptions.contains(type.getCanonicalText())) continue;
            holder.registerProblem((PsiElement)element, EjbHighlightingMessages.message("method.should.not.throw", method.getName(), type.getCanonicalText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodThrowsFix(method, type, false, false)});
        }
    }
}

