/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInsight.generation.actions.GenerateInterceptorMethods;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbInterceptorInspection;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.InterceptorMethodType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbInterceptorWarningsInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.interceptor.warnings", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbInterceptorWarningsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection", "getShortName"));
        }
        return "EjbInterceptorWarningsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EnumSet<EjbClassRoleEnum> roleTypes = EjbInterceptorWarningsInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(psiClass));
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbInterceptorWarningsInspection.checkInterceptorMethods(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }
        };
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        boolean ejbClass = false;
        boolean standardOnly = false;
        for (EjbClassRole role : classRoles) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                standardOnly = false;
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            if (!standardOnly) {
                standardOnly = EjbUtil.implementsStandardEjbInterface(role.getEnterpriseBean());
            }
            ejbClass = true;
        }
        EjbInterceptorWarningsInspection.checkInterceptorMethods(holder, aClass, EjbInterceptorInspection.buildInterceptorMethodsMap(classRoles, null), !ejbClass, standardOnly);
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, final PsiClass aClass, HashMap<InterceptorMethodType, List<InterceptorMethod>> map, boolean separateClass, boolean standardNamesOnly) {
        for (Map.Entry<InterceptorMethodType, List<InterceptorMethod>> entry : map.entrySet()) {
            List<InterceptorMethod> list = entry.getValue();
            for (InterceptorMethod method : list) {
                PsiMethod psiMethod;
                if (separateClass || aClass != (psiMethod = method.getMethod()).getContainingClass()) continue;
                String methodName = psiMethod.getName();
                if (standardNamesOnly || !methodName.startsWith("ejb")) continue;
                holder.registerProblem((PsiElement)psiMethod.getNameIdentifier(), EjbHighlightingMessages.message("method.name.conflict", methodName), new LocalQuickFix[0]);
            }
        }
        if (map.isEmpty() && separateClass) {
            holder.registerProblem((PsiElement)aClass.getNameIdentifier(), EjbHighlightingMessages.message("interceptor.class.has.no.annotated.methods", aClass.getName()), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getName() {
                    String string = this.getFamilyName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection$2", "getName"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = EjbHighlightingMessages.message("intention.family.generate.interceptor.methods", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection$2", "getFamilyName"));
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection$2", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/javaee/ejb/inspections/EjbInterceptorWarningsInspection$2", "applyFix"));
                    }
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, aClass.getContainingFile().getVirtualFile(), aClass.getNameIdentifier().getTextOffset()), true);
                    if (editor != null) {
                        new GenerateInterceptorMethods().actionPerformedImpl(project, editor);
                    }
                }
            }});
        }
    }
}

