/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.ejb.EjbReferenceImpl;
import com.intellij.javaee.model.annotations.ejb.ResourceImpl;
import com.intellij.javaee.model.annotations.ejb.ServiceRefImpl;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnvironmentGroupImpl
extends CommonModelElement.PsiBase
implements EnvironmentGroup,
JamElement {
    public static final SemKey<EnvironmentGroupImpl> JAVAEE_ENVIRONMENT_KEY = JamService.JAM_ELEMENT_KEY.subKey("JAVAEE_ENVIRONMENT_KEY", new SemKey[0]);
    public static final JamAttributeMeta<List<EjbReferenceImpl>> EJBS_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)EjbReferenceImpl.EJB_ANNO_META, EjbReferenceImpl.class);
    public static final JamAttributeMeta<List<ResourceImpl>> RESOURCES_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)ResourceImpl.RESOURCE_ANNO_META, ResourceImpl.class);
    public static final JamAttributeMeta<List<ServiceRefImpl>> SERVICES_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)ServiceRefImpl.SERVICE_ANNO_META, ServiceRefImpl.class);
    private static final JamAnnotationMeta EJBS_ANNO_META = new JamAnnotationMeta("javax.ejb.EJBs").addAttribute(EJBS_VALUE_META);
    private static final JamAnnotationMeta RESOURCES_ANNO_META = new JamAnnotationMeta("javax.annotation.Resources").addAttribute(RESOURCES_VALUE_META);
    private static final JamAnnotationMeta SERVICES_ANNO_META = new JamAnnotationMeta("javax.xml.ws.WebServiceRefs").addAttribute(SERVICES_VALUE_META);
    public static final JamMemberArchetype<PsiClass, EnvironmentGroupImpl> ENV_GROUP_ARCHETYPE = new JamMemberArchetype(null).addAnnotation(EjbReferenceImpl.EJB_ANNO_META).addAnnotation(EJBS_ANNO_META).addAnnotation(RESOURCES_ANNO_META).addAnnotation(ResourceImpl.RESOURCE_ANNO_META).addAnnotation(SERVICES_ANNO_META).addAnnotation(ServiceRefImpl.SERVICE_ANNO_META);
    private final PsiClass myPsiClass;

    protected EnvironmentGroupImpl(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public boolean isValid() {
        return super.isValid() && Comparing.equal((Object)this.getClassMeta().getJamElement((PsiModifierListOwner)this.getPsiClass()), (Object)((Object)this));
    }

    protected abstract JamClassMeta<?> getClassMeta();

    @Nullable
    protected PsiAnnotation findAnnotation(String annoName) {
        return this.myPsiClass.getModifierList().findAnnotation(annoName);
    }

    public List<EjbReferenceImpl> getEjbReferences() {
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)this.getPsiClass())) {
            result.addAll((Collection)EJBS_ANNO_META.getAttribute((PsiModifierListOwner)aClass, EJBS_VALUE_META));
            result.addAll(service.getAnnotatedMembersList(aClass, true, true, true, false, new JamMemberMeta[]{EjbReferenceImpl.EJB_META}));
        }
        return result;
    }

    public List<ResourceImpl> getResources() {
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)this.getPsiClass())) {
            result.addAll((Collection)RESOURCES_ANNO_META.getAttribute((PsiModifierListOwner)aClass, RESOURCES_VALUE_META));
            result.addAll(service.getAnnotatedMembersList(aClass, true, true, true, false, new JamMemberMeta[]{ResourceImpl.RESOURCE_META}));
        }
        return result;
    }

    public List<ServiceRefImpl> getServiceRefs() {
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)this.getPsiClass())) {
            result.addAll((Collection)SERVICES_ANNO_META.getAttribute((PsiModifierListOwner)aClass, SERVICES_VALUE_META));
            result.addAll(service.getAnnotatedMembersList(this.myPsiClass, true, true, true, false, new JamMemberMeta[]{ServiceRefImpl.SERVICE_META}));
        }
        return result;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/EnvironmentGroupImpl", "getPsiElement"));
        }
        return psiClass;
    }
}

