/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml;

import com.intellij.javaee.model.xml.GenericNamedValueConvertersRegistry;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericNamedValueConvertersRegistryImpl
extends GenericNamedValueConvertersRegistry {
    private final Map<Class, Collection<Info>> myInfoMap = new THashMap();

    public GenericNamedValueConvertersRegistryImpl() {
        for (Consumer extension : (Consumer[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            extension.consume((Object)this);
        }
    }

    public <T extends DomElement> void registerValueConverter(Class<T> paramClass, Condition<T> condition, @NonNls String paramName, Converter converter) {
        Info info = this.getOrCreateInfo(paramClass, condition);
        info.myMap.put(paramName, converter);
    }

    protected <T extends DomElement> Info getOrCreateInfo(Class<T> paramClass, Condition<T> condition) {
        SmartList infos = this.myInfoMap.get(paramClass);
        if (infos == null) {
            infos = new SmartList();
            this.myInfoMap.put(paramClass, (Collection<Info>)infos);
        }
        for (Info info : infos) {
            if (info.myCondition != condition) continue;
            return info;
        }
        Info info = new Info();
        info.myMap = new THashMap();
        info.myNameConverter = new NameConverter(info);
        info.myCondition = condition;
        infos.add(info);
        return info;
    }

    @NotNull
    public Converter getValueConverter(DomElement domElement) {
        Info info = this.getInfo(domElement);
        String name = info == null ? null : ElementPresentationManager.getElementName((Object)domElement);
        Converter converter = name == null ? null : info.myMap.get(name);
        Converter converter2 = converter == null ? Converter.EMPTY_CONVERTER : converter;
        if (converter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/GenericNamedValueConvertersRegistryImpl", "getValueConverter"));
        }
        return converter2;
    }

    @NotNull
    public Converter getNameConverter(DomElement domElement) {
        Info info = this.getInfo(domElement);
        Converter converter = info == null ? Converter.EMPTY_CONVERTER : info.myNameConverter;
        if (converter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/GenericNamedValueConvertersRegistryImpl", "getNameConverter"));
        }
        return converter;
    }

    @NotNull
    public <T extends DomElement> Map<String, Converter> getConverters(Class<T> domClass) {
        Collection<Info> infos = this.myInfoMap.get(domClass);
        if (infos == null) {
            Map<String, Converter> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/GenericNamedValueConvertersRegistryImpl", "getConverters"));
            }
            return map;
        }
        THashMap map = new THashMap();
        for (Info info : infos) {
            map.putAll(info.myMap);
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/GenericNamedValueConvertersRegistryImpl", "getConverters"));
        }
        return tHashMap;
    }

    @Nullable
    public <T extends DomElement> Converter getConverter(Class<T> domClass, String name) {
        Collection<Info> infos = this.myInfoMap.get(domClass);
        if (infos == null) {
            return null;
        }
        for (Info info : infos) {
            if (!info.myMap.containsKey(name)) continue;
            return info.myMap.get(name);
        }
        return null;
    }

    @Nullable
    protected Info getInfo(DomElement domElement) {
        for (Class<?> aClass : domElement.getClass().getInterfaces()) {
            Collection<Info> infos;
            if (!ReflectionUtil.isAssignable(DomElement.class, aClass) || (infos = this.myInfoMap.get(aClass)) == null) continue;
            for (Info info : infos) {
                if (!info.myCondition.value((Object)domElement)) continue;
                return info;
            }
        }
        return null;
    }

    private static class NameConverter
    extends ResolvingConverter<String> {
        private final Info myInfo;

        public NameConverter(Info info) {
            this.myInfo = info;
        }

        @NotNull
        public Collection<? extends String> getVariants(ConvertContext context) {
            Set<String> set = this.myInfo.myMap.keySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/xml/GenericNamedValueConvertersRegistryImpl$NameConverter", "getVariants"));
            }
            return set;
        }

        public String fromString(@Nullable @NonNls String s, ConvertContext context) {
            return s;
        }

        public String toString(@Nullable String s, ConvertContext context) {
            return s;
        }
    }

    protected static class Info {
        Condition<DomElement> myCondition;
        Map<String, Converter> myMap;
        Converter myNameConverter;

        protected Info() {
        }
    }
}

