/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JavaeeUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        boolean addFix;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/javaee/module/JavaeeUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javaee/module/JavaeeUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)ref);
        if (module == null) {
            return;
        }
        final String text = ref.getCanonicalText();
        if (JavaeeUnresolvedReferenceQuickFixProvider.isJavaeeQName(text)) {
            addFix = true;
        } else if (text.indexOf(46) < 0) {
            PsiFile containingFile = ref.getContainingFile();
            PsiImportList importList = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getImportList() : null;
            addFix = importList != null && null != ContainerUtil.find((Object[])importList.getImportStatements(), (Condition)new Condition<PsiImportStatement>(){

                public boolean value(PsiImportStatement statement) {
                    String qname = statement.getQualifiedName();
                    if (qname == null || !JavaeeUnresolvedReferenceQuickFixProvider.isJavaeeQName(qname)) {
                        return false;
                    }
                    return qname.endsWith("" + text) || statement.resolve() == null;
                }
            });
        } else {
            addFix = false;
        }
        if (addFix) {
            registrar.register((IntentionAction)JavaeeLibrariesUtil.createAddJavaeeLibraryQuickFix(module, "Java EE libraries"));
        }
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/JavaeeUnresolvedReferenceQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }

    private static boolean isJavaeeQName(final String text) {
        if (text.startsWith("javax.")) {
            Object[] packageList = new String[]{"activation", "annotation", "ejb", "el", "enterprise", "interceptor", "jms", "jws", "mail", "persistence", "resource", "security", "servlet", "transaction", "xml"};
            return null != ContainerUtil.find((Object[])packageList, (Condition)new Condition<String>(){

                public boolean value(String pkg) {
                    String packageName = "javax." + pkg;
                    return text.startsWith(packageName) && (text.length() == packageName.length() || text.charAt(packageName.length()) == '.');
                }
            });
        }
        return false;
    }
}

