/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.module.view.PrefixSuffixSupport;
import com.intellij.javaee.module.view.common.ShowJ2EENamesAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PrefixNameSuffixPanel
extends PrefixSuffixSupport {
    @NonNls
    private static final String REGEX = "[^\\w_]";
    private JPanel myPanel;
    private JPanel myHyperlinkPanel;
    private JPanel myPrefixNameSuffixPanel;
    private JLabel mySuffixLabel;
    private EditorTextField myName;
    private JLabel myPrefixLabel;
    private JLabel myLabel;

    protected PrefixNameSuffixPanel(@NonNls String labelEscapedText, final Project project) {
        super(project);
        this.$$$setupUI$$$();
        this.myHyperlinkPanel.setLayout(new BorderLayout());
        HyperlinkLabel link = new HyperlinkLabel(J2EEBundle.message((String)"link.display.text.configure.j2ee.names", (Object[])new Object[0]));
        this.myHyperlinkPanel.add((Component)link, "North");
        link.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                new ShowJ2EENamesAction(project){

                    @Override
                    protected void codeStyleSettingsChanged() {
                        PrefixNameSuffixPanel.this.resetPrefixSuffixAndUpdate();
                        PrefixNameSuffixPanel.this.codeStyleChanged();
                    }
                }.actionPerformed(null);
            }
        });
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                PrefixNameSuffixPanel.this.beforeNameChange();
            }

            public void documentChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrefixNameSuffixPanel.this.commitPrefixSuffix();
                        PrefixNameSuffixPanel.this.nameChanged();
                        PrefixNameSuffixPanel.this.myPrefixNameSuffixPanel.revalidate();
                    }
                });
            }
        });
        this.myLabel.setLabelFor((Component)this.myName);
        this.myLabel.setText(GuiUtils.getTextWithoutMnemonicEscaping((String)labelEscapedText));
        this.myLabel.setDisplayedMnemonic(GuiUtils.getDisplayedMnemonic((String)labelEscapedText));
        this.myLabel.setDisplayedMnemonicIndex(GuiUtils.getDisplayedMnemonicIndex((String)labelEscapedText));
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void resetPrefixSuffixAndUpdate() {
        this.resetPrefixSuffix();
        this.commitPrefixSuffix();
        this.updatePrefixSuffixPanels();
    }

    public final void commitPrefixSuffix() {
        String correctedName = this.correctRawName(this.myName.getText());
        this.setRawName(correctedName);
        if (!correctedName.equals(this.myName.getText())) {
            this.myName.setText(correctedName);
        }
    }

    @NotNull
    protected String correctRawName(String rawName) {
        String string = PrefixNameSuffixPanel.suggestIdentifierCompatibleName(rawName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/PrefixNameSuffixPanel", "correctRawName"));
        }
        return string;
    }

    public static String suggestIdentifierCompatibleName(String s) {
        return s.replaceAll(REGEX, "");
    }

    private void updatePrefixSuffixPanels() {
        this.myPrefixLabel.setText(PrefixNameSuffixPanel.toHtmlBold(this.getPrefix()));
        this.mySuffixLabel.setBackground(this.myName.getBackground());
        this.mySuffixLabel.setOpaque(true);
        this.mySuffixLabel.setEnabled(false);
        this.mySuffixLabel.setVisible(this.hasSuffix());
        this.mySuffixLabel.setText(PrefixNameSuffixPanel.toHtmlBold(this.getSuffix()));
        this.myPrefixLabel.setBackground(this.myName.getBackground());
        this.myPrefixLabel.setOpaque(true);
        this.myPrefixLabel.setEnabled(false);
        this.myPrefixLabel.setVisible(this.hasPrefix());
        this.myName.setText(this.getRawName());
        this.myName.setBorder(null);
    }

    public final void setFullNameAndUpdate(String fullName) {
        this.setFullName(fullName);
        this.updatePrefixSuffixPanels();
    }

    public void beforeNameChange() {
    }

    public abstract void nameChanged();

    public abstract void codeStyleChanged();

    @NonNls
    private static String toHtmlBold(String text) {
        return "<html><b>" + text + "</b></html>";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    public void setEnabled(boolean b) {
        this.myName.setEnabled(b);
        this.mySuffixLabel.setEnabled(b);
        this.myPrefixLabel.setEnabled(b);
    }

    public void selectAll() {
        this.myName.selectAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        EditorTextField editorTextField;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        JLabel jLabel3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, 0, false, false));
        this.myLabel = jLabel3 = new JLabel();
        jLabel3.setText("#########");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrefixNameSuffixPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 2, 0, 3, 4, 0, null, null, null));
        this.myPrefixLabel = jLabel2 = new JLabel();
        jLabel2.setText("#####");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySuffixLabel = jLabel = new JLabel();
        jLabel.setIconTextGap(0);
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(2);
        jLabel.setText("#####");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myName = editorTextField = new EditorTextField();
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, new Dimension(100, -1), null));
        this.myHyperlinkPanel = jPanel = new JPanel();
        jPanel3.add((Component)jPanel, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.configure.j2ee.names.prefix.and.suffix.are.taken.from"));
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

