/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.listener;

import com.intellij.icons.AllIcons;
import com.intellij.ide.TypePresentationService;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.model.jam.JamListener;
import com.intellij.javaee.model.xml.Listener;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.module.view.JavaeeAbstractCreateAction;
import com.intellij.javaee.module.view.web.ListenerUrl;
import com.intellij.javaee.module.view.web.WebCreateDialog;
import com.intellij.javaee.module.view.web.WebView;
import com.intellij.javaee.module.view.web.listener.ListenerDataHolder;
import com.intellij.javaee.module.view.web.servlet.CreateServletAction;
import com.intellij.javaee.web.ServletDataHolder;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateListenerAction
extends JavaeeAbstractCreateAction<CommonListener, WebFacet> {
    public CreateListenerAction() {
        this(J2EEBundle.message((String)"action.name.create.new.listener", (Object[])new Object[0]), "", AllIcons.Nodes.Weblistener);
    }

    private CreateListenerAction(String text, String description, Icon icon) {
        super(text, description, icon, WebFacet.ID);
    }

    @Override
    protected CommonListener createElement(@NotNull WebFacet facet, @NotNull String packageName, @Nullable PsiDirectory firstDirectory) {
        ListenerDataHolder holder;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/module/view/web/listener/CreateListenerAction", "createElement"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javaee/module/view/web/listener/CreateListenerAction", "createElement"));
        }
        Project project = facet.getModule().getProject();
        final WebApp root = CreateListenerAction.getWebApp(facet);
        WebCreateDialog dialog = new WebCreateDialog(root, holder = new ListenerDataHolder(facet), J2EEBundle.message((String)"dialog.title.new.listener", (Object[])new Object[0]), project, "javax.servlet.Listener", "Listener", "j2ee.jsp.webModuleEditor.listener");
        if (!dialog.showAndGet()) {
            return null;
        }
        if (!dialog.isCreateAnnotatedClass()) {
            return (CommonListener)new WriteCommandAction<Listener>(project, J2EEBundle.message((String)"command.name.create.0.1", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(Listener.class), holder.getClassName()}), new PsiFile[]{DomUtil.getFile((DomElement)root)}){

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }

                protected void run(@NotNull Result<Listener> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/web/listener/CreateListenerAction$1", "run"));
                    }
                    Listener listener = root.addListener();
                    if (listener != null) {
                        listener.getListenerClass().setStringValue(holder.getClassName());
                        ServletDataHolder.createClass(holder, "Listener Class.java");
                        result.setResult((Object)listener);
                    }
                }
            }.execute().getResultObject();
        }
        return (CommonListener)CreateServletAction.createAnnotatedClass(facet, holder, "Listener", "Listener Annotated Class.java", JamListener.LISTENER_CLASS_META);
    }

    @Override
    protected void showAndSelect(@NotNull WebFacet facet, @NotNull CommonListener listener) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/module/view/web/listener/CreateListenerAction", "showAndSelect"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javaee/module/view/web/listener/CreateListenerAction", "showAndSelect"));
        }
        WebView.select(facet.getModule().getProject(), ListenerUrl.getPath(listener), true);
    }
}

