/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.oss.server.JavaeeDeploymentModelContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Factory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class JavaeeDeploymentContextEditor<T>
extends SettingsEditor<T> {
    private JTextField myContextRootTextField;
    private JCheckBox myCustomContextRootCheckBox;
    private JPanel myMainPanel;

    public JavaeeDeploymentContextEditor(Factory<T> deploymentModelFactory, String labelCaption) {
        super(deploymentModelFactory);
        this.$$$setupUI$$$();
        this.myCustomContextRootCheckBox.setText(labelCaption);
        this.myCustomContextRootCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaeeDeploymentContextEditor.this.updateContextEnabled();
            }
        });
        this.myCustomContextRootCheckBox.setSelected(false);
        this.updateContextEnabled();
    }

    private void updateContextEnabled() {
        this.myContextRootTextField.setEnabled(this.myCustomContextRootCheckBox.isSelected());
    }

    public void resetEditorFrom(T settings) {
        JavaeeDeploymentModelContext deploymentModel = (JavaeeDeploymentModelContext)settings;
        this.myCustomContextRootCheckBox.setSelected(!deploymentModel.isDefaultContextRoot());
        this.updateContextEnabled();
        this.myContextRootTextField.setText(deploymentModel.getContextRoot());
    }

    public void applyEditorTo(T settings) throws ConfigurationException {
        JavaeeDeploymentModelContext deploymentModel = (JavaeeDeploymentModelContext)settings;
        deploymentModel.setDefaultContextRoot(!this.myCustomContextRootCheckBox.isSelected());
        deploymentModel.setContextRoot(this.myContextRootTextField.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeeDeploymentContextEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCustomContextRootCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("<use context>");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myContextRootTextField = jTextField = new JTextField();
        jTextField.setEditable(true);
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 4));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

