/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.util.ConfigBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFileWrapper<T>
extends ConfigBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + ConfigFileWrapper.class.getName()));

    @Nullable
    public T get(File file) {
        if (!file.exists()) {
            LOG.info("Config file not found: " + file.getAbsolutePath());
            return null;
        }
        try {
            Document doc = JDOMUtil.loadDocument((File)file);
            return this.doGet(doc);
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected T doGet(Document doc) throws JDOMException, IOException {
        return this.doGet(doc.getRootElement());
    }

    @Nullable
    protected T doGet(Element rootElement) throws JDOMException, IOException {
        throw new UnsupportedOperationException();
    }
}

