/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.util.ServerTaskRunner;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteConnectionTesterBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoteConnectionTesterBase.class.getName()));
    private final Project myProject;

    public static boolean testConnection(CommonModel model, Ref<Exception> exceptionRef) {
        try {
            ServerTaskRunner runner = ServerTaskRunner.create(model);
            return runner.runTask(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception e) {
            exceptionRef.set((Object)e);
            return false;
        }
    }

    public RemoteConnectionTesterBase(@Nullable Project project) {
        this.myProject = project;
    }

    public void testConnection() {
        final CommonModel model = this.getCommonModel();
        if (model == null) {
            return;
        }
        final Ref success = new Ref();
        final Ref exceptionRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                success.set((Object)RemoteConnectionTesterBase.testConnection(model, (Ref<Exception>)exceptionRef));
            }
        }, JavaeeBundle.getText("message.text.connection.progress", new Object[0]), true, this.myProject)) {
            return;
        }
        if (success.isNull()) {
            return;
        }
        if (((Boolean)success.get()).booleanValue()) {
            Messages.showInfoMessage((Component)this.getParentComponent(), (String)JavaeeBundle.getText("message.text.connection.successful", new Object[0]), (String)RemoteConnectionTesterBase.getDialogTitle());
        } else if (exceptionRef.isNull()) {
            this.showError(JavaeeBundle.getText("error.cannot.connect.text", new Object[0]));
        } else {
            Exception exception = (Exception)exceptionRef.get();
            LOG.debug((Throwable)exception);
            this.showError(this.getConnectErrorMessage(exception));
        }
    }

    private static String getDialogTitle() {
        return JavaeeBundle.getText("message.text.connection.title", new Object[0]);
    }

    protected String getConnectErrorMessage(Exception exception) {
        return exception.getLocalizedMessage();
    }

    protected final void showError(String message) {
        Messages.showErrorDialog((Component)this.getParentComponent(), (String)message, (String)RemoteConnectionTesterBase.getDialogTitle());
    }

    protected abstract CommonModel getCommonModel();

    protected abstract JComponent getParentComponent();
}

