/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration.view;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.RunnerSpecificConfigurationBit;
import com.intellij.openapi.options.SettingsEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RunnerSpecificRemotePanel
extends SettingsEditor<ConfigurationPerRunnerSettings> {
    private final JavaPatchableProgramRunner<?> myJavaProgramRunner;
    private ConfigurationArgumentsHelpArea myHelpArea;

    public RunnerSpecificRemotePanel(JavaPatchableProgramRunner<?> runner) {
        this.myJavaProgramRunner = runner;
    }

    private static String getActionText(JavaPatchableProgramRunner<?> runner) {
        return runner.getRunnerId().toLowerCase();
    }

    public void resetEditorFrom(ConfigurationPerRunnerSettings item) {
        RunnerSpecificConfigurationBit runnerSpecificConfigurationBit = (RunnerSpecificConfigurationBit)item;
        this.updateHelpArea(runnerSpecificConfigurationBit.getParentConfiguration(), runnerSpecificConfigurationBit.getRunnerSettings());
    }

    public void applyEditorTo(ConfigurationPerRunnerSettings commonModel) {
    }

    @NotNull
    public JComponent createEditor() {
        this.myHelpArea = new ConfigurationArgumentsHelpArea();
        this.myHelpArea.setLabelText(J2EEBundle.message((String)"label.run.configuration.editor.add.vm.parameters", (Object[])new Object[]{RunnerSpecificRemotePanel.getActionText(this.myJavaProgramRunner)}));
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea = this.myHelpArea;
        if (configurationArgumentsHelpArea == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/view/RunnerSpecificRemotePanel", "createEditor"));
        }
        return configurationArgumentsHelpArea;
    }

    private String evaluatePatchedParameters(CommonStrategy runProfile, RunnerSettings runnerSettings) throws ExecutionException {
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(runProfile.getJre());
        this.myJavaProgramRunner.patch(javaParameters, runnerSettings, (RunProfile)runProfile, false);
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        if (vmParametersList.getArray().length == 0) {
            return J2EEBundle.message((String)"message.text.run.configuration.editor.no.specific.parameters.needed", (Object[])new Object[0]);
        }
        return vmParametersList.getParametersString();
    }

    private void updateHelpArea(CommonStrategy runProfile, RunnerSettings runnerSettings) {
        try {
            this.myHelpArea.updateText(this.evaluatePatchedParameters(runProfile, runnerSettings));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

