/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.supportProvider.appServers;

import com.intellij.framework.FrameworkType;
import com.intellij.javaee.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.util.ParameterizedRunnable;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppServerFrameworkLibrariesFetcher {
    public static void fetchLibraries(final @NotNull AppServerLibrariesProvider provider, final @NotNull ParameterizedRunnable<Map<FrameworkType, List<File>>> callback) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibrariesFetcher", "fetchLibraries"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/supportProvider/appServers/AppServerFrameworkLibrariesFetcher", "fetchLibraries"));
        }
        final ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertIsDispatchThread();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final Map frameworkLibraries = provider.getFrameworkLibraries();
                application.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        callback.run((Object)frameworkLibraries);
                    }
                }, ModalityState.any());
            }
        });
    }
}

