/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.ui.packaging.JavaeeArtifactDependenciesChecker;
import com.intellij.javaee.ui.packaging.LibrariesAndModulesCollector;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EarArtifactDependenciesChecker
extends JavaeeArtifactDependenciesChecker {
    @Nullable
    private JavaeeApplication myJavaeeAppDescriptor;

    public EarArtifactDependenciesChecker(ArtifactType artifactType, ArtifactProblemsHolder manager, @Nullable JavaeeApplication javaeeAppDescriptor) {
        super(manager, artifactType);
        this.myJavaeeAppDescriptor = javaeeAppDescriptor;
    }

    public void processEar(CompositePackagingElement<?> rootElement) {
        String earLibDir = null;
        if (this.myJavaeeAppDescriptor != null && this.myJavaeeAppDescriptor.getLibraryDirectory() != null) {
            earLibDir = this.myJavaeeAppDescriptor.getLibraryDirectory().getStringValue();
        }
        if (StringUtil.isEmpty(earLibDir)) {
            earLibDir = "lib";
        }
        LibrariesAndModulesCollector common = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, true);
        ArtifactUtil.processDirectoryChildren(rootElement, (PackagingElementPath)PackagingElementPath.EMPTY, (String)earLibDir, (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementProcessor)common);
        final HashMap<VirtualFile, String> jarsToRelativePaths = new HashMap<VirtualFile, String>();
        final ArrayList webApplications = new ArrayList();
        final ArrayList jars = new ArrayList();
        ArtifactUtil.processElementsWithSubstitutions((List)rootElement.getChildren(), (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementPath)PackagingElementPath.EMPTY.appendComposite(rootElement), (PackagingElementProcessor)new PackagingElementProcessor<PackagingElement<?>>(){

            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/ui/packaging/EarArtifactDependenciesChecker$1", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/ui/packaging/EarArtifactDependenciesChecker$1", "process"));
                }
                if (element instanceof CompositePackagingElement) {
                    CompositePackagingElement child = (CompositePackagingElement)element;
                    String name = child.getName();
                    if (StringUtil.endsWithIgnoreCase((String)name, (String)".war")) {
                        webApplications.add(Pair.create((Object)child, (Object)path));
                    } else if (StringUtil.endsWithIgnoreCase((String)name, (String)".jar")) {
                        jars.add(Pair.create((Object)child, (Object)path));
                    }
                }
                EarArtifactDependenciesChecker.addJars(element, jarsToRelativePaths, "");
                return true;
            }
        });
        for (Pair pair : webApplications) {
            this.processWebApplication((CompositePackagingElement)pair.getFirst(), (PackagingElementPath)pair.getSecond(), common, rootElement, jarsToRelativePaths);
        }
        for (Pair pair : jars) {
            this.processJar((CompositePackagingElement)pair.getFirst(), (PackagingElementPath)pair.getSecond(), common, rootElement, jarsToRelativePaths);
        }
    }

    private static void addJars(PackagingElement<?> element, Map<VirtualFile, String> jarsToRelativePaths, String elementPath) {
        FileCopyPackagingElement fileCopyElement;
        VirtualFile jarRoot;
        if (element instanceof FileCopyPackagingElement && (jarRoot = (fileCopyElement = (FileCopyPackagingElement)element).getLibraryRoot()) != null) {
            jarsToRelativePaths.put(jarRoot, DeploymentUtil.concatPaths((String[])new String[]{elementPath, fileCopyElement.getOutputFileName()}));
        }
    }

    private void processJar(CompositePackagingElement<?> jarRoot, PackagingElementPath pathToJar, LibrariesAndModulesCollector common, CompositePackagingElement<?> earRoot, Map<VirtualFile, String> jarsToRelativePaths) {
        LibrariesAndModulesCollector classpathCollector = this.collectLibrariesFromClasspath(jarRoot, earRoot);
        LibrariesAndModulesCollector collector = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, true);
        ArtifactUtil.processElementsWithSubstitutions((List)jarRoot.getChildren(), (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementPath)pathToJar.appendComposite(jarRoot), (PackagingElementProcessor)collector);
        this.checkDependencies(new LibrariesAndModulesCollector[]{collector}, jarRoot, jarsToRelativePaths, pathToJar, classpathCollector, common);
    }

    private void processWebApplication(CompositePackagingElement<?> warRoot, PackagingElementPath pathToWar, LibrariesAndModulesCollector common, CompositePackagingElement<?> earRoot, Map<VirtualFile, String> jarsToRelativePaths) {
        LibrariesAndModulesCollector classpathCollector = this.collectLibrariesFromClasspath(warRoot, earRoot);
        this.processWebApplication(warRoot, pathToWar, jarsToRelativePaths, classpathCollector, common);
    }

    private LibrariesAndModulesCollector collectLibrariesFromClasspath(CompositePackagingElement<?> archiveRoot, CompositePackagingElement<?> earRoot) {
        List classpath;
        LibrariesAndModulesCollector classpathCollector = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, true);
        if (archiveRoot instanceof CompositeElementWithManifest && (classpath = this.myContext.getManifestFileProvider().getClasspathFromManifest(archiveRoot, this.myArtifactType)) != null) {
            for (String path : classpath) {
                ArtifactUtil.processElementsByRelativePath(earRoot, (String)path, (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementPath)PackagingElementPath.EMPTY, (PackagingElementProcessor)classpathCollector);
            }
        }
        return classpathCollector;
    }
}

