/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.JavaeeFacetNodePresentation;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaeeFacetSourceItem
extends PackagingSourceItem {
    private final JavaeeFacet myFacet;

    public JavaeeFacetSourceItem(@NotNull JavaeeFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItem", "<init>"));
        }
        this.myFacet = facet;
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaeeFacetSourceItem && this.myFacet.equals((Object)((JavaeeFacetSourceItem)((Object)obj)).myFacet);
    }

    public int hashCode() {
        return this.myFacet.hashCode();
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItem", "createPresentation"));
        }
        FacetPointer pointer = FacetPointersManager.getInstance((Project)context.getProject()).create((Facet)this.myFacet);
        return new DelegatedSourceItemPresentation(new JavaeeFacetNodePresentation(context, (FacetPointer<JavaeeFacet>)pointer, "resources")){

            public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
                if (presentationData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItem$1", "render"));
                }
                presentationData.setIcon(JavaeeFacetSourceItem.this.myFacet.getType().getIcon());
                presentationData.addText(JavaeeFacetSourceItem.this.myFacet.getName() + " facet resources", mainAttributes);
            }

            public int getWeight() {
                return 5;
            }
        };
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItem", "createElements"));
        }
        List<JavaeeFacetResourcesPackagingElement> list = Collections.singletonList(new JavaeeFacetResourcesPackagingElement(this.myFacet));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/JavaeeFacetSourceItem", "createElements"));
        }
        return list;
    }
}

