/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.javaee.model.enums.WebAppVersion;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebModelImpl;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFacetImpl
extends WebFacet
implements JavaeeFacetEx,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.facet.WebFacetImpl");
    private CachedValue<Map<String, String>> myTaglibUriToResource;
    private final JavaeeFacetCommonPart myCommonPart;
    private final List<WebRoot> myWebRoots;
    private boolean myWebSourceRootsNotSpecified;
    @NonNls
    public static final String WEB_FRAGMENT_XML = "web-fragment.xml";

    public WebFacetImpl(@NotNull WebFacetType facetType, @NotNull Module module, String name, @NotNull WebFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/javaee/web/facet/WebFacetImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/web/facet/WebFacetImpl", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/web/facet/WebFacetImpl", "<init>"));
        }
        super((FacetType)facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myWebRoots = new ArrayList<WebRoot>();
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)facetType.getDescriptorsMetaDataProvider(), configuration.getDescriptorsConfiguration());
        for (WebRootData data : configuration.getWebRoots()) {
            this.addWebRoot(data);
        }
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    @Override
    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myWebSourceRootsNotSpecified = element.getChild("sourceRoots") == null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls();
        if (Comparing.haveEqualElements(this.getWebConfiguration().getSourceRoots(), Arrays.asList(sourceRoots))) {
            element.removeChild("sourceRoots");
        }
    }

    public void setWebRoots(@NotNull List<WebRootData> webRoots) {
        if (webRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webRoots", "com/intellij/javaee/web/facet/WebFacetImpl", "setWebRoots"));
        }
        this.myWebRoots.clear();
        this.getWebConfiguration().setWebRoots(webRoots);
        this.myWebRoots.clear();
        for (WebRootData data : this.getWebConfiguration().getWebRoots()) {
            this.addWebRoot(data);
        }
    }

    public void removeAllWebRoots() {
        this.myWebRoots.clear();
        this.getWebConfiguration().setWebRoots(Collections.emptyList());
    }

    public WebRoot addWebRoot(@NotNull String directoryUrl, @NotNull String relativePath) {
        if (directoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryUrl", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebRoot"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebRoot"));
        }
        WebRoot webRoot = this.addWebRootNoFire(directoryUrl, relativePath);
        this.fireWebRootsListeners();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerEx.getInstanceEx((Project)WebFacetImpl.this.getModule().getProject()).makeRootsChange(EmptyRunnable.getInstance(), false, true);
            }
        });
        return webRoot;
    }

    public WebRoot addWebRoot(@NotNull VirtualFile directory, @NotNull String relativePath) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebRoot"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebRoot"));
        }
        return this.addWebRoot(directory.getUrl(), relativePath);
    }

    public void removeWebRoot(WebRoot webRoot) {
        if (this.myWebRoots.remove(webRoot)) {
            this.getWebConfiguration().removeWebRoot(new WebRootData(webRoot.getDirectoryUrl(), webRoot.getRelativePath()));
            this.fireWebRootsListeners();
        }
    }

    public WebRoot addWebRootNoFire(@NotNull String directoryUrl, @NotNull String relativePath) {
        if (directoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryUrl", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebRootNoFire"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebRootNoFire"));
        }
        WebRootData data = new WebRootData(directoryUrl, relativePath);
        this.getWebConfiguration().addWebRoot(data);
        return this.addWebRoot(data);
    }

    public List<WebRoot> getWebRoots() {
        return this.getWebRoots(false);
    }

    private WebRoot addWebRoot(WebRootData data) {
        WebRoot webRoot = new WebRoot(data.getUrl(), data.getRelativePath(), (Disposable)this);
        this.myWebRoots.add(webRoot);
        return webRoot;
    }

    public WebFacetConfigurationImpl getWebConfiguration() {
        return (WebFacetConfigurationImpl)this.getConfiguration();
    }

    private void fireWebRootsListeners() {
        ((LogicalRootsManager.LogicalRootListener)this.getModule().getProject().getMessageBus().syncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public Collection<VirtualFile> getSourceRoots() {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        for (String url : this.getWebConfiguration().getSourceRoots()) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            list.add(file);
        }
        return list;
    }

    public List<WebRoot> getWebRoots(boolean includeDependentModules) {
        return this.myWebRoots;
    }

    private void addFragments(List<XmlFile> files) {
        PsiFile[] psiFiles;
        Project project = this.getModule().getProject();
        for (PsiFile file : psiFiles = FilenameIndex.getFilesByName((Project)project, (String)WEB_FRAGMENT_XML, (GlobalSearchScope)this.getModule().getModuleWithDependenciesAndLibrariesScope(false))) {
            PsiDirectory directory = file.getParent();
            if (directory == null || !(file instanceof XmlFile) || !directory.getName().equals("META-INF")) continue;
            files.add((XmlFile)file);
        }
    }

    public List<PsiDirectory> getResources() {
        Project project = this.getModule().getProject();
        PsiPackage metainf = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metainf == null) {
            return Collections.emptyList();
        }
        Object[] directories = metainf.getDirectories(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule()));
        return ContainerUtil.mapNotNull((Object[])directories, (Function)new NullableFunction<PsiDirectory, PsiDirectory>(){

            public PsiDirectory fun(PsiDirectory psiDirectory) {
                return psiDirectory.findSubdirectory("resources");
            }
        });
    }

    @Nullable
    public WebApp getRoot() {
        List<WebApp> models = this.getWebApps();
        return models.isEmpty() ? null : (WebApp)DomManager.getDomManager((Project)this.getModule().getProject()).createModelMerger().mergeModels(WebApp.class, models);
    }

    @NotNull
    public WebAppVersion getWebAppVersion() {
        WebApp webApp = this.getRoot();
        if (webApp == null) {
            WebAppVersion webAppVersion = WebAppVersion.WebAppVersion_3_0;
            if (webAppVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/facet/WebFacetImpl", "getWebAppVersion"));
            }
            return webAppVersion;
        }
        WebAppVersion value = (WebAppVersion)webApp.getVersion().getValue();
        WebAppVersion webAppVersion = value == null ? WebAppVersion.WebAppVersion_2_4 : value;
        if (webAppVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/facet/WebFacetImpl", "getWebAppVersion"));
        }
        return webAppVersion;
    }

    public List<WebApp> getWebApps() {
        ArrayList<XmlFile> files = new ArrayList<XmlFile>();
        ConfigFile deploymentDescriptor = this.getWebXmlDescriptor();
        if (deploymentDescriptor != null) {
            XmlFile xmlFile = deploymentDescriptor.getXmlFile();
            ContainerUtil.addIfNotNull(files, (Object)xmlFile);
        }
        this.addFragments(files);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull(files, (Function)new NullableFunction<XmlFile, WebApp>(){

            public WebApp fun(XmlFile file) {
                return (WebApp)JamCommonUtil.getRootElement((PsiFile)file, WebApp.class, (Module)WebFacetImpl.this.getModule());
            }
        });
    }

    @NotNull
    public WebModel getWebModel() {
        WebModelImpl webModelImpl = new WebModelImpl(this);
        if (webModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/facet/WebFacetImpl", "getWebModel"));
        }
        return webModelImpl;
    }

    @Override
    public void onFacetChanged() {
        this.refreshModel();
    }

    public Map<String, String> getTaglibUriToResourceMap() {
        if (this.myTaglibUriToResource == null) {
            PsiManager manager = PsiManager.getInstance((Project)this.getModule().getProject());
            this.myTaglibUriToResource = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, String>>(){

                public CachedValueProvider.Result<Map<String, String>> compute() {
                    HashMap<String, String> ret = new HashMap<String, String>();
                    XmlTag webXmlRootTag = WebFacetImpl.this.getWebXmlRootTag();
                    if (webXmlRootTag == null) {
                        return new CachedValueProvider.Result(new HashMap(), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                    }
                    XmlTag configTag = webXmlRootTag.findFirstSubTag("jsp-config");
                    XmlTag[] taglibTags = configTag != null ? configTag.findSubTags("taglib") : webXmlRootTag.findSubTags("taglib");
                    for (XmlTag subTag : taglibTags) {
                        XmlTag uriTag = subTag.findFirstSubTag("taglib-uri");
                        if (uriTag == null) continue;
                        XmlTag locationTag = subTag.findFirstSubTag("taglib-location");
                        if (locationTag != null) {
                            ret.put(uriTag.getValue().getTrimmedText(), locationTag.getValue().getTrimmedText());
                            continue;
                        }
                        ret.put(uriTag.getValue().getTrimmedText(), uriTag.getValue().getTrimmedText());
                    }
                    return new CachedValueProvider.Result(ret, new Object[]{webXmlRootTag});
                }
            }, false);
        }
        return (Map)this.myTaglibUriToResource.getValue();
    }

    @Nullable
    private XmlTag getWebXmlRootTag() {
        ConfigFile deploymentDescriptor = this.getWebXmlDescriptor();
        if (deploymentDescriptor == null) {
            return null;
        }
        XmlFile xmlFile = deploymentDescriptor.getXmlFile();
        if (xmlFile == null) {
            return null;
        }
        XmlDocument doc = xmlFile.getDocument();
        return doc != null ? doc.getRootTag() : null;
    }

    public void initFacet() {
        if (this.myWebSourceRootsNotSpecified) {
            String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls(false);
            this.getWebConfiguration().setSourceRoots(Arrays.asList(sourceRoots));
        }
        this.myCommonPart.initFacet();
    }

    public void addWebSourceRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/facet/WebFacetImpl", "addWebSourceRoot"));
        }
        String[] sourceRoots = ModuleRootManager.getInstance((Module)this.getModule()).getSourceRootUrls();
        LOG.assertTrue(Arrays.asList(sourceRoots).contains(url), (Object)("'" + url + "' is not a source root"));
        List<String> urls = this.getWebConfiguration().getSourceRoots();
        LOG.assertTrue(!urls.contains(url), (Object)("'" + url + "' is already registered"));
        urls.add(url);
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public void removeWebSourceRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/facet/WebFacetImpl", "removeWebSourceRoot"));
        }
        List<String> sourceRoots = this.getWebConfiguration().getSourceRoots();
        boolean removed = sourceRoots.remove(url);
        LOG.assertTrue(removed, (Object)("Web source root '" + url + "' not found."));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public List<String> getWebSourceRootUrls() {
        return Collections.unmodifiableList(this.getWebConfiguration().getSourceRoots());
    }

    public void setWebSourceRoots(@NotNull String[] urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/javaee/web/facet/WebFacetImpl", "setWebSourceRoots"));
        }
        this.getWebConfiguration().setSourceRoots(Arrays.asList(urls));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public ConfigFile getWebXmlDescriptor() {
        return this.getDescriptorsContainer().getConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA);
    }

    private void refreshModel() {
        this.myTaglibUriToResource = null;
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        Collection<VirtualFile> roots = this.myCommonPart.getDescriptors();
        roots.addAll(this.getSourceRoots());
        for (WebRoot webRoot : this.getWebRoots()) {
            VirtualFile file = webRoot.getFile();
            if (file == null) continue;
            roots.add(file);
        }
        Collection<VirtualFile> collection = roots;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/facet/WebFacetImpl", "getFacetRoots"));
        }
        return collection;
    }
}

