/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.module.WebModuleType;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebProjectStructureDetector
extends ProjectStructureDetector {
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        boolean containsStaticWeb = false;
        boolean containsDynamicWeb = false;
        for (File child : children) {
            FileType fileType = fileTypeManager.getFileTypeByFileName(child.getName());
            containsStaticWeb |= fileType == StdFileTypes.HTML || fileType == StdFileTypes.XHTML || fileType.getDefaultExtension().equals("js");
            containsDynamicWeb |= fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX;
        }
        if (containsDynamicWeb) {
            result.add((DetectedProjectRoot)new DetectedContentRoot(dir, "Java Web", StdModuleTypes.JAVA, new ModuleType[]{WebModuleType.getInstance()}));
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        if (containsStaticWeb) {
            result.add((DetectedProjectRoot)new DetectedContentRoot(dir, "Web", (ModuleType)WebModuleType.getInstance(), new ModuleType[0]));
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    public void setupProjectStructure(@NotNull Collection<DetectedProjectRoot> roots, @NotNull ProjectDescriptor projectDescriptor, @NotNull ProjectFromSourcesBuilder builder) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "setupProjectStructure"));
        }
        if (projectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDescriptor", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "setupProjectStructure"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javaee/web/framework/WebProjectStructureDetector", "setupProjectStructure"));
        }
        builder.setupModulesByContentRoots(projectDescriptor, roots);
    }
}

