/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.ui;

import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.ui.WebPathChooserDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.EditorTextFieldControl;
import com.intellij.util.xml.ui.WebPathPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebPathControl
extends EditorTextFieldControl<WebPathPanel> {
    public WebPathControl(DomWrapper<String> domWrapper) {
        super(domWrapper);
    }

    public WebPathControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper, commitOnEveryChange);
    }

    protected EditorTextField getEditorTextField(@NotNull WebPathPanel component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/javaee/web/ui/WebPathControl", "getEditorTextField"));
        }
        return ((ReferenceEditorWithBrowseButton)component.getComponent(0)).getEditorTextField();
    }

    protected WebPathPanel createMainComponent(WebPathPanel boundedComponent, final Project project) {
        if (boundedComponent == null) {
            boundedComponent = new WebPathPanel();
        }
        boundedComponent.removeAll();
        Function<String, Document> factory = new Function<String, Document>(){

            @Nullable
            public Document fun(String s) {
                PsiCodeFragmentImpl fragment = new PsiCodeFragmentImpl(project, PlainTextTokenTypes.PLAIN_TEXT_FILE, true, "web_path.txt", (CharSequence)s, null);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
                if (document != null) {
                    ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project)).associatePsi(document, (PsiFile)fragment);
                }
                return document;
            }
        };
        EditorTextField editorTextField = new EditorTextField((Document)factory.fun((Object)""), project, (FileType)FileTypes.PLAIN_TEXT);
        ReferenceEditorWithBrowseButton editor = new ReferenceEditorWithBrowseButton(null, editorTextField, (Function)factory);
        editor.addActionListener(this.createListener(project));
        boundedComponent.add((Component)editor);
        return boundedComponent;
    }

    private ActionListener createListener(final Project project) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<WebRoot> webRoots = this.findWebRoots();
                WebPathChooserDescriptor descriptor = new WebPathChooserDescriptor(true, false, false, false, false, false, webRoots);
                descriptor.setRoots(ContainerUtil.map(webRoots, (Function)new NullableFunction<WebRoot, VirtualFile>(){

                    public VirtualFile fun(WebRoot root) {
                        return root.getFile();
                    }
                }));
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)this.getFileByRelativePath());
                if (files.length > 0) {
                    WebPathControl.this.setValue(this.getRelativePath(this.findWebRoots(), files[0]));
                }
            }

            private List<WebRoot> findWebRoots() {
                if (WebPathControl.this.getDomElement() == null || WebPathControl.this.getDomElement().getModule() == null) {
                    return Collections.emptyList();
                }
                WebFacet webFacet = WebPathControl.this.getWebFacet();
                if (webFacet == null) {
                    return Collections.emptyList();
                }
                return webFacet.getWebRoots(true);
            }

            private String getRelativePath(List<WebRoot> webRoots, VirtualFile file) {
                for (WebRoot webRoot : webRoots) {
                    VirtualFile rootFile = webRoot.getFile();
                    if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)file, (boolean)false)) continue;
                    StringBuilder uri = new StringBuilder(webRoot.getURI());
                    if (uri.length() == 0 || uri.charAt(uri.length() - 1) != '/') {
                        uri.append('/');
                    }
                    uri.append(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)webRoot.getFile(), (char)'/'));
                    return uri.toString();
                }
                return "";
            }

            @Nullable
            private VirtualFile getFileByRelativePath() {
                if (WebPathControl.this.getDomElement() == null || WebPathControl.this.getDomElement().getModule() == null) {
                    return null;
                }
                String webPath = WebPathControl.this.getValue();
                if (webPath.trim().length() == 0) {
                    return null;
                }
                WebFacet webFacet = WebPathControl.this.getWebFacet();
                if (webFacet == null) {
                    return null;
                }
                List list = webFacet.getWebRoots(true);
                for (WebRoot webRoot : list) {
                    VirtualFile virtualFile;
                    VirtualFile webRootDir = webRoot.getFile();
                    if (webRootDir == null || (virtualFile = webRootDir.findFileByRelativePath(this.formatPath(webPath))) == null) continue;
                    return virtualFile;
                }
                return null;
            }

            private String formatPath(String relativePath) {
                if (StringUtil.startsWithChar((CharSequence)(relativePath = relativePath.replace(File.separatorChar, '/').trim()), (char)'/')) {
                    relativePath = relativePath.substring(1, relativePath.length());
                }
                return relativePath;
            }
        };
    }

    @Nullable
    private WebFacet getWebFacet() {
        DomElement domElement = this.getDomElement();
        if (domElement == null) {
            return null;
        }
        DomElement parent = domElement.getParent();
        if (!(parent instanceof JavaeeModelElement)) {
            return WebUtil.getWebFacet((PsiElement)DomUtil.getFile((DomElement)domElement));
        }
        return WebUtil.getWebFacet((JavaeeModelElement)((JavaeeModelElement)parent));
    }
}

