/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.web.validation.JasperArtifactValidatorInstance;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.DummyPersistentState;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.VirtualFileWithDependenciesState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactAwareCompiler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JasperArtifactValidator
extends GenericCompiler<String, VirtualFileWithDependenciesState, DummyPersistentState>
implements ArtifactAwareCompiler {
    private static final Key<Boolean> FORCE_JSP_VALIDATION = Key.create((String)"force_jsp_validation");
    private List<String> myValidatedPaths = new ArrayList<String>();
    private List<String> myFileNamesWithComputedDependencies = new ArrayList<String>();

    public JasperArtifactValidator() {
        super("jasper_validator", 0, GenericCompiler.CompileOrderPlace.VALIDATING);
    }

    public static JasperArtifactValidator getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/web/validation/JasperArtifactValidator", "getInstance"));
        }
        return (JasperArtifactValidator)((Object)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)EP_NAME, (AreaInstance)project), JasperArtifactValidator.class));
    }

    public boolean shouldRun(@NotNull Collection<? extends Artifact> changedArtifacts) {
        if (changedArtifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedArtifacts", "com/intellij/javaee/web/validation/JasperArtifactValidator", "shouldRun"));
        }
        for (Artifact artifact : changedArtifacts) {
            if (!artifact.getArtifactType().equals((Object)ExplodedWarArtifactType.getInstance())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public KeyDescriptor<String> getItemKeyDescriptor() {
        KeyDescriptor keyDescriptor = STRING_KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidator", "getItemKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<VirtualFileWithDependenciesState> getSourceStateExternalizer() {
        DataExternalizer dataExternalizer = VirtualFileWithDependenciesState.EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidator", "getSourceStateExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public DataExternalizer<DummyPersistentState> getOutputStateExternalizer() {
        DataExternalizer dataExternalizer = DummyPersistentState.EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidator", "getOutputStateExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public GenericCompilerInstance<?, ? extends CompileItem<String, VirtualFileWithDependenciesState, DummyPersistentState>, String, VirtualFileWithDependenciesState, DummyPersistentState> createInstance(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/web/validation/JasperArtifactValidator", "createInstance"));
        }
        this.myValidatedPaths.clear();
        JasperArtifactValidatorInstance jasperArtifactValidatorInstance = new JasperArtifactValidatorInstance(this, context);
        if (jasperArtifactValidatorInstance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidator", "createInstance"));
        }
        return jasperArtifactValidatorInstance;
    }

    @NotNull
    public String getDescription() {
        String string = J2EEBundle.message((String)"jasper.validator.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidator", "getDescription"));
        }
        return string;
    }

    public static void setForceValidation(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "com/intellij/javaee/web/validation/JasperArtifactValidator", "setForceValidation"));
        }
        compileScope.putUserData(FORCE_JSP_VALIDATION, (Object)true);
    }

    static boolean isForceValidation(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileScope", "com/intellij/javaee/web/validation/JasperArtifactValidator", "isForceValidation"));
        }
        return Boolean.TRUE.equals(compileScope.getUserData(FORCE_JSP_VALIDATION));
    }

    public List<String> getValidatedPaths() {
        return this.myValidatedPaths;
    }

    public void addValidatedPath(String pathFromRoot) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myValidatedPaths.add(pathFromRoot);
        }
    }

    public List<String> getFileNamesWithComputedDependencies() {
        return this.myFileNamesWithComputedDependencies;
    }

    public void addFileNameWithComputedDependency(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/validation/JasperArtifactValidator", "addFileNameWithComputedDependency"));
        }
        this.myFileNamesWithComputedDependencies.add(path);
    }
}

