/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.javaee.web.validation.JasperValidationForArtifactRunner;
import com.intellij.javaee.web.validation.JasperValidatorItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.DummyPersistentState;
import com.intellij.openapi.compiler.generic.GenericCompilerCacheState;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.GenericCompilerProcessingItem;
import com.intellij.openapi.compiler.generic.VirtualFileWithDependenciesState;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.compiler.ArtifactBuildTarget;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasperArtifactValidatorInstance
extends GenericCompilerInstance<ArtifactBuildTarget, JasperValidatorItem, String, VirtualFileWithDependenciesState, DummyPersistentState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.validation.JasperArtifactValidatorInstance");
    @NonNls
    private static final Set<String> IGNORED_EXTENSIONS = new THashSet(Arrays.asList("jspf", "tag", "tagx"));
    private JasperArtifactValidator myValidator;

    public JasperArtifactValidatorInstance(JasperArtifactValidator validator, CompileContext context) {
        super(context);
        this.myValidator = validator;
    }

    @NotNull
    public List<ArtifactBuildTarget> getAllTargets() {
        List<ArtifactBuildTarget> list = JasperArtifactValidatorInstance.getTargets(Arrays.asList(ArtifactManager.getInstance((Project)this.getProject()).getArtifacts()), null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "getAllTargets"));
        }
        return list;
    }

    @NotNull
    public List<ArtifactBuildTarget> getSelectedTargets() {
        if (!ValidationConfiguration.shouldValidate((Compiler)this.myValidator, (CompileContext)this.myContext) && !JasperArtifactValidator.isForceValidation(this.myContext.getCompileScope())) {
            LOG.debug("JSP Validation is disabled");
            List<ArtifactBuildTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "getSelectedTargets"));
            }
            return list;
        }
        Set changedArtifacts = ArtifactsCompiler.getChangedArtifacts((CompileContext)this.myContext);
        if (LOG.isDebugEnabled() && changedArtifacts != null) {
            LOG.debug(changedArtifacts.size() + " artifacts are changed: " + StringUtil.join((Collection)changedArtifacts, (Function)StringUtil.createToStringFunction(Artifact.class), (String)","));
        }
        List<ArtifactBuildTarget> list = JasperArtifactValidatorInstance.getTargets(ArtifactCompileScope.getArtifactsToBuild((Project)this.getProject(), (CompileScope)this.myContext.getCompileScope(), (boolean)false), changedArtifacts);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "getSelectedTargets"));
        }
        return list;
    }

    private static List<ArtifactBuildTarget> getTargets(Collection<Artifact> artifacts, @Nullable Set<Artifact> changedArtifacts) {
        ArrayList<ArtifactBuildTarget> targets = new ArrayList<ArtifactBuildTarget>();
        for (Artifact artifact : artifacts) {
            if (!artifact.getArtifactType().equals((Object)ExplodedWarArtifactType.getInstance()) || StringUtil.isEmpty((String)artifact.getOutputPath()) || changedArtifacts != null && !changedArtifacts.contains(artifact)) continue;
            targets.add(new ArtifactBuildTarget(artifact));
        }
        return targets;
    }

    public void processObsoleteTarget(@NotNull String targetId, @NotNull List<GenericCompilerCacheState<String, VirtualFileWithDependenciesState, DummyPersistentState>> obsoleteItems) {
        if (targetId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processObsoleteTarget"));
        }
        if (obsoleteItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obsoleteItems", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processObsoleteTarget"));
        }
    }

    @NotNull
    public List<JasperValidatorItem> getItems(final @NotNull ArtifactBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "getItems"));
        }
        final ExcludesConfiguration excludesConfiguration = ValidationConfiguration.getExcludedEntriesConfiguration((Project)this.getProject());
        final ArrayList<JasperValidatorItem> items = new ArrayList<JasperValidatorItem>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Artifact artifact = target.getArtifact();
                final PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)JasperArtifactValidatorInstance.this.getProject()).getResolvingContext();
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)JasperArtifactValidatorInstance.this.getProject()).getFileIndex();
                THashSet filesFromScope = new THashSet();
                Collections.addAll(filesFromScope, JasperArtifactValidatorInstance.this.myContext.getCompileScope().getFiles((FileType)StdFileTypes.JSP, false));
                Collections.addAll(filesFromScope, JasperArtifactValidatorInstance.this.myContext.getCompileScope().getFiles((FileType)StdFileTypes.JSPX, false));
                ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>((Set)filesFromScope){
                    final /* synthetic */ Set val$filesFromScope;
                    {
                        this.val$filesFromScope = set;
                    }

                    public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance$1$1", "process"));
                        }
                        if (path == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance$1$1", "process"));
                        }
                        JavaeeFacet facet = element.findFacet(resolvingContext);
                        if (facet instanceof WebFacet) {
                            for (WebRoot webRoot : ((WebFacet)facet).getWebRoots()) {
                                VirtualFile file = webRoot.getFile();
                                if (file == null) continue;
                                JasperArtifactValidatorInstance.this.processFileRecursively(file, DeploymentUtil.appendToPath((String)path.getPathString(), (String)webRoot.getRelativePath()), items, excludesConfiguration, fileIndex, this.val$filesFromScope);
                            }
                        }
                        return true;
                    }
                }, (PackagingElementResolvingContext)resolvingContext, (boolean)true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Total " + items.size() + " JSP files:");
                    for (int i = 0; i < Math.min(items.size(), 20); ++i) {
                        LOG.debug("  " + ((JasperValidatorItem)((Object)items.get(i))).getJspFile().getPath());
                    }
                }
            }
        });
        ArrayList<JasperValidatorItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "getItems"));
        }
        return arrayList;
    }

    private void processFileRecursively(@NotNull VirtualFile file, String pathFromRoot, List<JasperValidatorItem> items, ExcludesConfiguration excludesConfiguration, ProjectFileIndex fileIndex, Set<VirtualFile> filesFromScope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processFileRecursively"));
        }
        if (fileIndex.isExcluded(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.processFileRecursively(child, pathFromRoot + "/" + child.getName(), items, excludesConfiguration, fileIndex, filesFromScope);
            }
            return;
        }
        if (!StdFileTypes.JSP.equals(file.getFileType()) && !StdFileTypes.JSPX.equals(file.getFileType()) || IGNORED_EXTENSIONS.contains(file.getExtension()) || JspFileIndex.getInstance((Project)this.getProject()).isIncluded(file) || excludesConfiguration.isExcluded(file)) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        items.add(new JasperValidatorItem(file, pathFromRoot, psiFile, !filesFromScope.contains(file)));
    }

    public void processItems(@NotNull ArtifactBuildTarget target, @NotNull List<GenericCompilerProcessingItem<JasperValidatorItem, VirtualFileWithDependenciesState, DummyPersistentState>> changedItems, @NotNull List<GenericCompilerCacheState<String, VirtualFileWithDependenciesState, DummyPersistentState>> obsoleteItems, @NotNull GenericCompilerInstance.OutputConsumer<JasperValidatorItem> consumer) {
        File explodedDir;
        Artifact artifact;
        String outputPath;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processItems"));
        }
        if (changedItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedItems", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processItems"));
        }
        if (obsoleteItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obsoleteItems", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processItems"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javaee/web/validation/JasperArtifactValidatorInstance", "processItems"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(changedItems.size() + " files will be validated:");
            for (int i = 0; i < Math.min(changedItems.size(), 20); ++i) {
                LOG.debug(((JasperValidatorItem)changedItems.get(i).getItem()).getJspFile().getPath());
            }
        }
        LOG.assertTrue((outputPath = (artifact = target.getArtifact()).getOutputPath()) != null, (Object)artifact);
        HashMap<VirtualFile, JasperValidatorItem> file2Item = new HashMap<VirtualFile, JasperValidatorItem>();
        ArrayList<JasperValidatorItem> toValidate = new ArrayList<JasperValidatorItem>();
        for (GenericCompilerProcessingItem<JasperValidatorItem, VirtualFileWithDependenciesState, DummyPersistentState> processingItem : changedItems) {
            JasperValidatorItem item = (JasperValidatorItem)processingItem.getItem();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myValidator.addValidatedPath(item.getJspFile().getPath());
            }
            file2Item.put(item.getJspFile(), item);
            toValidate.add(item);
        }
        JasperValidationForArtifactRunner validator = new JasperValidationForArtifactRunner(this.getProject(), artifact);
        List<VirtualFile> validated = validator.validate(this.myContext, toValidate, explodedDir = new File(FileUtil.toSystemDependentName((String)outputPath)));
        if (validated != null) {
            for (VirtualFile file : validated) {
                JasperValidatorItem item = (JasperValidatorItem)((Object)file2Item.get(file));
                if (item == null) continue;
                consumer.addProcessedItem((CompileItem)item);
            }
        }
    }
}

