/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.analysis.AnalysisScope;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.DummyPersistentState;
import com.intellij.openapi.compiler.generic.VirtualFileWithDependenciesState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JasperValidatorItem
extends CompileItem<String, VirtualFileWithDependenciesState, DummyPersistentState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.validation.JasperValidatorItem");
    private final VirtualFile myJspFile;
    private final String myPathFromRoot;
    private final PsiFile myPsiFile;
    private final boolean myExcluded;

    public JasperValidatorItem(VirtualFile jsp, String pathFromRoot, PsiFile psiFile, boolean excluded) {
        this.myJspFile = jsp;
        this.myPathFromRoot = pathFromRoot;
        this.myPsiFile = psiFile;
        this.myExcluded = excluded;
    }

    @NotNull
    public String getKey() {
        String string = this.myJspFile.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidatorItem", "getKey"));
        }
        return string;
    }

    public boolean isExcluded() {
        return this.myExcluded;
    }

    public String getPathFromRoot() {
        return this.myPathFromRoot;
    }

    public VirtualFile getJspFile() {
        return this.myJspFile;
    }

    public boolean isSourceUpToDate(@NotNull VirtualFileWithDependenciesState virtualFileWithDependenciesState) {
        if (virtualFileWithDependenciesState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileWithDependenciesState", "com/intellij/javaee/web/validation/JasperValidatorItem", "isSourceUpToDate"));
        }
        return virtualFileWithDependenciesState.isUpToDate(this.myJspFile);
    }

    @NotNull
    public VirtualFileWithDependenciesState computeSourceState() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JasperArtifactValidator.getInstance(this.myPsiFile.getProject()).addFileNameWithComputedDependency(this.myJspFile.getName());
        }
        ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(this.myPsiFile.getProject(), new AnalysisScope(this.myPsiFile));
        builder.analyze();
        Set dependentFiles = (Set)builder.getDependencies().get(this.myPsiFile);
        VirtualFileWithDependenciesState state = new VirtualFileWithDependenciesState(this.myJspFile.getTimeStamp());
        if (this.myPsiFile instanceof JspFile) {
            HashSet<BaseJspFile> included = new HashSet<BaseJspFile>();
            JasperValidatorItem.addIncludedFiles((BaseJspFile)((JspFile)this.myPsiFile), included, JspFileIndex.getInstance((Project)this.myPsiFile.getProject()));
            dependentFiles.addAll(included);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Computed dependencies of " + this.myJspFile.getPath() + " (" + dependentFiles.size() + "):");
            int max = 20;
            for (PsiFile file : dependentFiles) {
                if (max-- < 0) break;
                LOG.debug("  " + file);
            }
        }
        for (PsiFile dependentFile : dependentFiles) {
            VirtualFile virtualFile = dependentFile.getVirtualFile();
            if (virtualFile == null) continue;
            state.addDependency(virtualFile);
        }
        VirtualFileWithDependenciesState virtualFileWithDependenciesState = state;
        if (virtualFileWithDependenciesState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidatorItem", "computeSourceState"));
        }
        return virtualFileWithDependenciesState;
    }

    private static void addIncludedFiles(BaseJspFile psiFile, Set<BaseJspFile> files, JspFileIndex jspFileIndex) {
        BaseJspFile[] included;
        if (!files.add(psiFile)) {
            return;
        }
        for (BaseJspFile jspFile : included = jspFileIndex.getIncludedFiles(psiFile)) {
            JasperValidatorItem.addIncludedFiles(jspFile, files, jspFileIndex);
        }
    }

    public boolean isOutputUpToDate(@NotNull DummyPersistentState dummyPersistentState) {
        if (dummyPersistentState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyPersistentState", "com/intellij/javaee/web/validation/JasperValidatorItem", "isOutputUpToDate"));
        }
        return true;
    }

    @NotNull
    public DummyPersistentState computeOutputState() {
        DummyPersistentState dummyPersistentState = DummyPersistentState.INSTANCE;
        if (dummyPersistentState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidatorItem", "computeOutputState"));
        }
        return dummyPersistentState;
    }
}

