/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.model.RawConnectionConfig;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.model.PersistencePackage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaImplementationProviderBase
implements JpaImplementationProvider {
    private final String myDisplayName;
    private final String myProviderClassName;
    private final String myPropertyDriver;
    private final String myPropertyUrl;
    private final String myPropertyUser;
    private final String myPropertyPassword;

    protected JpaImplementationProviderBase(@NotNull String displayName, @NotNull String providerClass, @NotNull String driver, @NotNull String url, @NotNull String user, @NotNull String password) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/jpa/JpaImplementationProviderBase", "<init>"));
        }
        if (providerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerClass", "com/intellij/jpa/JpaImplementationProviderBase", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/jpa/JpaImplementationProviderBase", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jpa/JpaImplementationProviderBase", "<init>"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/jpa/JpaImplementationProviderBase", "<init>"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/jpa/JpaImplementationProviderBase", "<init>"));
        }
        this.myDisplayName = displayName;
        this.myProviderClassName = providerClass;
        this.myPropertyDriver = driver;
        this.myPropertyUrl = url;
        this.myPropertyUser = user;
        this.myPropertyPassword = password;
    }

    @NotNull
    public String getProviderName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaImplementationProviderBase", "getProviderName"));
        }
        return string;
    }

    @NonNls
    public String getProviderClassName() {
        return this.myProviderClassName;
    }

    public boolean isConfiguredFor(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/JpaImplementationProviderBase", "isConfiguredFor"));
        }
        return JpaUtil.findPersistenceUnitProperty(unit, this.myPropertyUrl, null) != null;
    }

    public void setConnectionProperties(@NotNull Project project, @NotNull PersistenceUnit unit, @NotNull RawConnectionConfig info, @NotNull Pair<String, String> credentials) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/JpaImplementationProviderBase", "setConnectionProperties"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/JpaImplementationProviderBase", "setConnectionProperties"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/jpa/JpaImplementationProviderBase", "setConnectionProperties"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/jpa/JpaImplementationProviderBase", "setConnectionProperties"));
        }
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUrl, this.getPropertyAlias(this.myPropertyUrl), info.getEffectiveUrl(project));
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyDriver, this.getPropertyAlias(this.myPropertyDriver), info.getDriverClass());
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUser, this.getPropertyAlias(this.myPropertyUser), (String)credentials.first);
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyPassword, this.getPropertyAlias(this.myPropertyPassword), (String)credentials.second);
    }

    @Nullable
    protected String getPropertyAlias(String propertyName) {
        return null;
    }

    public void setDefaultProperties(@NotNull PersistenceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/JpaImplementationProviderBase", "setDefaultProperties"));
        }
        unit.getProvider().setStringValue(this.myProviderClassName);
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUrl, null, "");
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyDriver, null, "");
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyUser, null, "");
        JpaUtil.setPersistenceUnitProperty(unit, this.myPropertyPassword, null, "");
    }
}

