/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LegendStatusAndProgressIcon
extends AbstractProgressIndicatorExBase
implements Disposable {
    private final JPanel myPanel;
    private final JPanel myProgressPanel;
    private final JProgressBar myProgressBar;
    private final JLabel myLabel;
    private final AsyncProcessIcon myProgressIcon = new AsyncProcessIcon("Progress"){

        protected void paintIcon(Graphics g, Icon icon, int x, int y) {
            super.paintIcon(g, icon, x, y);
            LegendStatusAndProgressIcon.this.update();
        }
    };
    private final JLabel myLegendLabel;

    public LegendStatusAndProgressIcon(Icon legend) {
        this.myPanel = new JPanel(new BorderLayout());
        this.myProgressPanel = new JPanel(new BorderLayout(5, 2));
        this.myProgressBar = new JProgressBar();
        this.myLabel = new JLabel();
        this.myProgressPanel.add((Component)this.myProgressIcon, "West");
        this.myProgressPanel.add((Component)this.myLabel, "Center");
        JPanel progressBarPanel = new JPanel(new BorderLayout());
        this.myProgressPanel.add((Component)progressBarPanel, "East");
        progressBarPanel.add((Component)this.myProgressBar, "Center");
        progressBarPanel.add((Component)new InplaceButton(new IconButton(JpaMessages.message((String)"button.text.cancel", (Object[])new Object[0]), AllIcons.Process.Stop, AllIcons.Process.StopHovered), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendStatusAndProgressIcon.this.cancel();
            }
        }).setFillBg(true), "East");
        this.myProgressPanel.setVisible(false);
        this.myProgressBar.setMaximum(1000);
        this.myLegendLabel = new JLabel(legend);
        this.myPanel.add((Component)this.myLegendLabel, "North");
        this.myPanel.add((Component)this.myProgressPanel, "South");
        Disposer.register((Disposable)this, (Disposable)this.myProgressIcon);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void start() {
        super.start();
        this.flipView(true);
        this.myProgressIcon.resume();
    }

    public void stop() {
        super.stop();
        this.myProgressIcon.suspend();
        this.flipView(false);
    }

    public void cancel() {
        super.cancel();
        this.flipView(false);
    }

    private void flipView(final boolean start) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                LegendStatusAndProgressIcon.this.myProgressPanel.setVisible(start);
                LegendStatusAndProgressIcon.this.myLegendLabel.setVisible(!start);
            }
        });
    }

    private void update() {
        String newText = this.getText() + (StringUtil.isNotEmpty((String)this.getText2()) ? ": " + this.getText2() : "");
        this.myLabel.setText(newText);
        this.myLabel.setToolTipText(newText);
        this.myProgressBar.setValue((int)(this.getFraction() * 1000.0));
        this.myLabel.paintImmediately(0, 0, this.myLabel.getWidth(), this.myLabel.getHeight());
        this.myProgressBar.paintImmediately(0, 0, this.myProgressBar.getWidth(), this.myProgressBar.getHeight());
    }

    public void dispose() {
    }
}

