/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethod;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodContainer;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.highlighting.RemoveQuickFix;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JpaEntityListenerInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.entity.listener", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaEntityListenerInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaEntityListenerInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaEntityListenerInspection", "getShortName"));
        }
        return "JpaEntityListenerInspection";
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        PersistenceClassRoleEnum type = role.getType();
        if (type == PersistenceClassRoleEnum.ENTITY_LISTENER) {
            JpaInspectionUtil.checkNoArgConstructorExists(aClass, holder, "public");
            JpaEntityListenerInspection.checkListenerMethods(aClass, (CommonModelElement)role.getEntityListener(), role, holder);
        } else {
            JpaEntityListenerInspection.checkListenerMethods(aClass, (CommonModelElement)role.getPersistentObject(), role, holder);
        }
    }

    private static void checkListenerMethods(PsiClass aClass, CommonModelElement element, PersistenceClassRole role, ProblemsHolder holder) {
        if (element instanceof EntityListenerMethodContainer) {
            final HashMap map = new HashMap();
            Processor<EntityListenerMethod> processor = new Processor<EntityListenerMethod>(){

                public boolean process(EntityListenerMethod t) {
                    ArrayList<EntityListenerMethod> list = (ArrayList<EntityListenerMethod>)map.get(t.getType());
                    if (list == null) {
                        list = new ArrayList<EntityListenerMethod>();
                        map.put(t.getType(), list);
                    }
                    if (!list.contains(t)) {
                        list.add(t);
                    }
                    return true;
                }
            };
            ((EntityListenerMethodContainer)element).processEntityListenerMethods(aClass, (Processor)processor);
            THashSet visitedMethods = new THashSet();
            for (Map.Entry entry : map.entrySet()) {
                ArrayList list = (ArrayList)entry.getValue();
                if (list.size() > 1) {
                    HashSet<PsiMethod> set = new HashSet<PsiMethod>();
                    for (EntityListenerMethod method : list) {
                        set.add(method.getMethod());
                    }
                    if (set.size() > 1) {
                        for (EntityListenerMethod method : list) {
                            holder.registerProblem((PsiElement)method.getMethod().getNameIdentifier(), JpaHighlightingMessages.message("more.than.one.method.defined.for.entity.listener.method.type", ((EntityListenerMethodType)entry.getKey()).getTypeName(), method.getMethod().getContainingClass().getName()), new LocalQuickFix[]{new RemoveQuickFix(method.getDefiningElement())});
                        }
                    }
                }
                for (EntityListenerMethod method : list) {
                    PsiMethod psiMethod = method.getMethod();
                    if (!visitedMethods.add((Object)psiMethod)) continue;
                    JpaEntityListenerInspection.checkEntityListenerMethodSignature(psiMethod, role, holder);
                }
            }
        }
    }

    private static void checkEntityListenerMethodSignature(PsiMethod psiMethod, PersistenceClassRole role, ProblemsHolder holder) {
        JpaInspectionUtil.checkMethodReturnType(psiMethod, holder, (PsiType)PsiType.VOID);
        if (role.getType() == PersistenceClassRoleEnum.ENTITY_LISTENER) {
            PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)psiMethod.getManager(), (GlobalSearchScope)psiMethod.getResolveScope());
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length == 1 && TypeConversionUtil.isAssignable((PsiType)objectType, (PsiType)parameters[0].getType())) {
                boolean ok = false;
                PsiType erasure = TypeConversionUtil.erasure((PsiType)parameters[0].getType());
                for (PersistenceClassRole classRole : PersistenceCommonUtil.getPersistenceRoles((PsiClass)PsiTypesUtil.getPsiClass((PsiType)erasure))) {
                    if (!browser.acceptsRole(classRole) || classRole.getType() != PersistenceClassRoleEnum.ENTITY && classRole.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    JpaInspectionUtil.checkMethodParameters(psiMethod, holder, new PsiType[]{objectType});
                }
            } else {
                JpaInspectionUtil.checkMethodParameters(psiMethod, holder, new PsiType[]{objectType});
            }
        } else {
            JpaInspectionUtil.checkMethodParameters(psiMethod, holder, new PsiType[0]);
        }
    }
}

