/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.jpa.model.annotations.mapping.JpaAttributeReference;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JpaModelReferenceInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.model.reference", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaModelReferenceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaModelReferenceInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaModelReferenceInspection", "getShortName"));
        }
        return "JpaModelReferenceInspection";
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getPersistentObject() != null) {
            JpaInspectionUtil.checkMemberAnnotations((PsiModifierListOwner)aClass, holder, JpaAttributeReference.class);
            JpaModelReferenceInspection.checkObjectMembers(aClass, holder);
        }
    }

    private static void checkObjectMembers(PsiClass aClass, final ProblemsHolder holder) {
        Processor<PsiMember> processor = new Processor<PsiMember>(){

            public boolean process(PsiMember psiMember) {
                JpaInspectionUtil.checkMemberAnnotations((PsiModifierListOwner)psiMember, holder, JpaAttributeReference.class);
                return true;
            }
        };
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }
}

