/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerSet;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.jpa.model.annotations.mapping.NamedQueryBaseImpl;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentSuperclass;
import com.intellij.persistence.model.helpers.PersistenceMappingsModelHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScopedEntityMappingsImpl
extends CommonModelElement.ModuleBase
implements JamEntityMappings,
PersistenceMappingsModelHelper {
    private final Condition<PsiClass> myCondition;
    private final EntityMappingsImpl myEntityMappings;
    private final CachedValue<Condition<PersistentObjectImpl>> myInheritanceCondition;

    protected ScopedEntityMappingsImpl(EntityMappingsImpl entityMappings, Condition<PsiClass> condition) {
        this.myEntityMappings = entityMappings;
        this.myCondition = condition;
        this.myInheritanceCondition = CachedValuesManager.getManager((Project)entityMappings.getModule().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Condition<PersistentObjectImpl>>(){

            public CachedValueProvider.Result<Condition<PersistentObjectImpl>> compute() {
                return new CachedValueProvider.Result((Object)ScopedEntityMappingsImpl.this.createInheritanceConditionInner(), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }, false);
    }

    public Condition<PsiClass> getCondition() {
        return this.myCondition;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myEntityMappings.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/ScopedEntityMappingsImpl", "getModule"));
        }
        return module;
    }

    public EntityMappingsImpl getEntityMappings() {
        return this.myEntityMappings;
    }

    public List<NamedQueryBaseImpl.NamedImpl> getNamedQueries() {
        return Collections.emptyList();
    }

    public List<NamedQueryBaseImpl.NativeImpl> getNamedNativeQueries() {
        return Collections.emptyList();
    }

    public EntityListenerSet getDefaultEntityListeners() {
        return this.myEntityMappings.getDefaultEntityListeners();
    }

    public List<EntityListenerImpl> getEntityListeners() {
        return this.myEntityMappings.getEntityListeners();
    }

    public List<EntityImpl> getEntities() {
        return ContainerUtil.findAll(this.myEntityMappings.getEntities(), (Condition)((Condition)this.myInheritanceCondition.getValue()));
    }

    public List<EmbeddableImpl> getEmbeddables() {
        return this.myEntityMappings.getEmbeddables();
    }

    public List<MappedSuperclassImpl> getMappedSuperclasses() {
        return ContainerUtil.findAll(this.myEntityMappings.getMappedSuperclasses(), (Condition)((Condition)this.myInheritanceCondition.getValue()));
    }

    private Condition<PersistentObjectImpl> createInheritanceConditionInner() {
        SmartList superClasses;
        PersistentObjectImpl object;
        PsiClass aClass;
        final THashSet classNames = new THashSet();
        Processor<PsiClass> processor = new Processor<PsiClass>(){

            public boolean process(PsiClass aClass) {
                String qualifiedName = aClass.getQualifiedName();
                return qualifiedName != null && classNames.add((Object)qualifiedName);
            }
        };
        Iterator<EntityImpl> iterator = this.myEntityMappings.getEntities().iterator();
        while (iterator.hasNext() && ((aClass = (object = (PersistentObjectImpl)iterator.next()).getPsiClass()) == null || !this.myCondition.value((Object)aClass) || JamCommonUtil.processSuperClassList((PsiClass)aClass, (Collection)(superClasses = new SmartList()), (Processor)processor))) {
        }
        return new Condition<PersistentObjectImpl>(){

            public boolean value(PersistentObjectImpl persistentObject) {
                PsiClass curClass = persistentObject.getPsiClass();
                return curClass != null && (ScopedEntityMappingsImpl.this.myCondition.value((Object)curClass) || classNames.contains((Object)curClass.getQualifiedName()));
            }
        };
    }

    @NotNull
    public PersistenceMappingsModelHelper getModelHelper() {
        ScopedEntityMappingsImpl scopedEntityMappingsImpl = this;
        if (scopedEntityMappingsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/ScopedEntityMappingsImpl", "getModelHelper"));
        }
        return scopedEntityMappingsImpl;
    }

    public GenericValue<PsiPackage> getPackage() {
        return this.myEntityMappings.getPackage();
    }

    public PropertyMemberType getDeclaredAccess() {
        return this.myEntityMappings.getDeclaredAccess();
    }

    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List<EntityListenerImpl> list = this.getEntityListeners();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/ScopedEntityMappingsImpl", "getPersistentListeners"));
        }
        return list;
    }

    @NotNull
    public List<? extends PersistentEntity> getPersistentEntities() {
        List<EntityImpl> list = this.getEntities();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/ScopedEntityMappingsImpl", "getPersistentEntities"));
        }
        return list;
    }

    @NotNull
    public List<? extends PersistentSuperclass> getPersistentSuperclasses() {
        List<MappedSuperclassImpl> list = this.getMappedSuperclasses();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/ScopedEntityMappingsImpl", "getPersistentSuperclasses"));
        }
        return list;
    }

    @NotNull
    public List<? extends PersistentEmbeddable> getPersistentEmbeddables() {
        List<EmbeddableImpl> list = this.getEmbeddables();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/ScopedEntityMappingsImpl", "getPersistentEmbeddables"));
        }
        return list;
    }
}

