/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.FrameworkRegistrationEntry;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.GetRegistrationEntries;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.GetRegistrationEntriesResponse;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.RegistrationExtendedAttribute2;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.RegistrationStub;
import com.microsoft.schemas.teamfoundation._2005._06.services.serverstatus._03.CheckAuthentication;
import com.microsoft.schemas.teamfoundation._2005._06.services.serverstatus._03.CheckAuthenticationResponse;
import com.microsoft.schemas.teamfoundation._2005._06.services.serverstatus._03.ServerStatusStub;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.QueryWorkspaces;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Workspace;
import com.microsoft.webservices.ArrayOfGuid;
import com.microsoft.webservices.ArrayOfKeyValueOfStringString;
import com.microsoft.webservices.ArrayOfServiceTypeFilter;
import com.microsoft.webservices.ArrayOfString;
import com.microsoft.webservices.CatalogResource;
import com.microsoft.webservices.CatalogWebServiceStub;
import com.microsoft.webservices.Connect;
import com.microsoft.webservices.ConnectResponse;
import com.microsoft.webservices.ConnectionData;
import com.microsoft.webservices.KeyValueOfStringString;
import com.microsoft.webservices.LocationWebServiceStub;
import com.microsoft.webservices.QueryNodes;
import com.microsoft.webservices.QueryNodesResponse;
import com.microsoft.webservices.QueryResources;
import com.microsoft.webservices.QueryResourcesResponse;
import com.microsoft.webservices.ServiceDefinition;
import com.microsoft.webservices.ServiceTypeFilter;
import com.microsoft.wsdl.types.Guid;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSConstants;
import org.jetbrains.tfsIntegration.core.TfsBeansHolder;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.HostNotApplicableException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.TfsExceptionManager;
import org.jetbrains.tfsIntegration.exceptions.UserCancelledException;
import org.jetbrains.tfsIntegration.ui.ChooseTeamProjectCollectionDialog;
import org.jetbrains.tfsIntegration.webservice.TfsRequestManager;
import org.jetbrains.tfsIntegration.webservice.WebServiceHelper;

public class TfsServerConnectionHelper {
    private static final Logger LOG = Logger.getInstance((String)TfsServerConnectionHelper.class.getName());

    public static void ensureAuthenticated(Object projectOrComponent, URI serverUri, boolean force) throws TfsException {
        TfsRequestManager.executeRequest(serverUri, projectOrComponent, force, new TfsRequestManager.Request<Void>(null){

            @Override
            public Void execute(Credentials credentials, URI serverUri, ProgressIndicator pi) throws Exception {
                TfsServerConnectionHelper.connect(serverUri, credentials, true, pi);
                return null;
            }

            @Override
            @NotNull
            public String getProgressTitle(Credentials credentials, URI serverUri) {
                String string = TFSBundle.message("connect.to", TfsUtil.getPresentableUri(serverUri));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/config/TfsServerConnectionHelper$1", "getProgressTitle"));
                }
                return string;
            }
        });
    }

    @Nullable
    public static AddServerResult addServer(JComponent parentComponent) {
        TeamProjectCollectionDescriptor collection;
        Trinity<URI, ServerDescriptor, Credentials> result;
        TfsRequestManager.Request<Trinity<URI, ServerDescriptor, Credentials>> connectRequest = new TfsRequestManager.Request<Trinity<URI, ServerDescriptor, Credentials>>(null){

            @Override
            public Trinity<URI, ServerDescriptor, Credentials> execute(Credentials credentials, URI serverUri, @Nullable ProgressIndicator pi) throws Exception {
                ServerDescriptor serverDescriptor = TfsServerConnectionHelper.connect(serverUri, credentials, false, pi);
                serverUri = serverDescriptor.uri;
                if (serverDescriptor instanceof Tfs200xServerDescriptor && TFSConfigurationManager.getInstance().serverKnown(((Tfs200xServerDescriptor)serverDescriptor).instanceId)) {
                    throw new TfsException(TFSBundle.message("duplicate.server", new Object[0]));
                }
                if (credentials.getType() != Credentials.Type.NtlmNative && !credentials.getUserName().equalsIgnoreCase(serverDescriptor.getUserName())) {
                    LOG.warn("authorized user mismatch: current=" + credentials.getQualifiedUsername() + ", authorized: " + serverDescriptor.authorizedCredentials);
                    throw new TfsException(TFSBundle.message("authorized.user.mismatch", new Object[0]));
                }
                if (serverDescriptor instanceof Tfs2010ServerDescriptor) {
                    Collection<TeamProjectCollectionDescriptor> teamProjectCollections = ((Tfs2010ServerDescriptor)serverDescriptor).teamProjectCollections;
                    if (teamProjectCollections.size() == 0) {
                        throw new TfsException(TFSBundle.message("no.team.project.collections", new Object[0]));
                    }
                    boolean newCollection = false;
                    for (TeamProjectCollectionDescriptor teamProjectCollection : teamProjectCollections) {
                        if (TFSConfigurationManager.getInstance().serverKnown(teamProjectCollection.instanceId)) continue;
                        newCollection = true;
                        break;
                    }
                    if (!newCollection) {
                        throw new TfsException(TFSBundle.message("all.team.project.collections.duplicate", new Object[0]));
                    }
                }
                return Trinity.create((Object)serverUri, (Object)serverDescriptor, (Object)credentials);
            }

            @Override
            @NotNull
            public String getProgressTitle(Credentials credentials, URI serverUri) {
                String string = TFSBundle.message("connect.to", TfsUtil.getPresentableUri(serverUri));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/config/TfsServerConnectionHelper$2", "getProgressTitle"));
                }
                return string;
            }

            @Override
            public boolean retrieveAuthorizedCredentials() {
                return false;
            }
        };
        try {
            result = TfsRequestManager.getInstance(null).executeRequestInForeground(parentComponent, true, null, true, connectRequest);
        }
        catch (UserCancelledException e) {
            return null;
        }
        catch (TfsException e) {
            LOG.error((Throwable)e);
            return null;
        }
        final ServerDescriptor serverDescriptor = (ServerDescriptor)result.second;
        if (serverDescriptor instanceof Tfs200xServerDescriptor) {
            Tfs200xServerDescriptor tfs200xServerDescriptor = (Tfs200xServerDescriptor)serverDescriptor;
            return new AddServerResult((URI)result.first, tfs200xServerDescriptor.instanceId, serverDescriptor.authorizedCredentials, tfs200xServerDescriptor.workspaces, null, serverDescriptor.beans);
        }
        Collection<TeamProjectCollectionDescriptor> teamProjectCollections = ((Tfs2010ServerDescriptor)serverDescriptor).teamProjectCollections;
        if (teamProjectCollections.size() == 1) {
            collection = teamProjectCollections.iterator().next();
        } else {
            ChooseTeamProjectCollectionDialog d2 = new ChooseTeamProjectCollectionDialog(parentComponent, ((URI)result.first).toString(), teamProjectCollections);
            if (!d2.showAndGet()) {
                return null;
            }
            collection = d2.getSelectedItem();
            LOG.assertTrue(collection != null);
        }
        URI collectionUri = TfsServerConnectionHelper.getCollectionUri((URI)result.first, collection);
        final TfsBeansHolder collectionBeans = new TfsBeansHolder(collectionUri);
        TfsRequestManager.Request<Workspace[]> loadWorkspacesRequest = new TfsRequestManager.Request<Workspace[]>(null){

            @Override
            public Workspace[] execute(Credentials credentials, URI serverUri, @Nullable ProgressIndicator pi) throws Exception {
                return TfsServerConnectionHelper.queryWorkspaces(serverDescriptor.authorizedCredentials, pi, collectionBeans);
            }

            @Override
            @NotNull
            public String getProgressTitle(Credentials credentials, URI serverUri) {
                String string = TFSBundle.message("connect.to", TfsUtil.getPresentableUri(serverUri));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/config/TfsServerConnectionHelper$3", "getProgressTitle"));
                }
                return string;
            }

            @Override
            public boolean retrieveAuthorizedCredentials() {
                return false;
            }
        };
        Workspace[] workspaces = null;
        String workspacesLoadError = null;
        try {
            workspaces = TfsRequestManager.getInstance(collectionUri).executeRequestInForeground(parentComponent, false, (Credentials)result.third, true, loadWorkspacesRequest);
        }
        catch (UserCancelledException e) {
            return null;
        }
        catch (TfsException e) {
            workspacesLoadError = e.getMessage();
        }
        return new AddServerResult(collectionUri, collection.instanceId, serverDescriptor.authorizedCredentials, workspaces, workspacesLoadError, collectionBeans);
    }

    private static URI getCollectionUri(URI serverUri, TeamProjectCollectionDescriptor collection) {
        String path = serverUri.getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        try {
            return new URI(serverUri.getScheme(), serverUri.getUserInfo(), serverUri.getHost(), serverUri.getPort(), path + collection.name, null, null);
        }
        catch (URISyntaxException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static ServerDescriptor connect(URI uri, final Credentials credentials, boolean justAuthenticate, @Nullable ProgressIndicator pi) throws RemoteException, TfsException {
        Pair<URI, ConnectResponse> connectResponse;
        if (pi != null) {
            pi.setText(TFSBundle.message("connecting.to.server", new Object[0]));
        }
        if (justAuthenticate) {
            uri = TfsServerConnectionHelper.getBareUri(uri);
        }
        final ConfigurationContext context = WebServiceHelper.getStubConfigurationContext();
        Pair<URI, FrameworkRegistrationEntry[]> registrationEntries = null;
        try {
            connectResponse = TfsServerConnectionHelper.tryDifferentUris(uri, !justAuthenticate, new ThrowableConvertor<URI, ConnectResponse, RemoteException>(){

                public ConnectResponse convert(URI uri) throws RemoteException {
                    LocationWebServiceStub locationService = new LocationWebServiceStub(context, TfsUtil.appendPath(uri, "TeamFoundation/Administration/v3.0/LocationService.asmx"));
                    WebServiceHelper.setupStub((Stub)locationService, credentials, uri);
                    Connect connectParam = new Connect();
                    connectParam.setConnectOptions(1);
                    ArrayOfServiceTypeFilter serviceTypeFilters = new ArrayOfServiceTypeFilter();
                    ServiceTypeFilter filter = new ServiceTypeFilter();
                    filter.setServiceType("*");
                    filter.setIdentifier(TFSConstants.FRAMEWORK_SERVER_DATA_PROVIDER_FILTER_GUID);
                    serviceTypeFilters.addServiceTypeFilter(filter);
                    connectParam.setServiceTypeFilters(serviceTypeFilters);
                    connectParam.setLastChangeId(-1);
                    return locationService.connect(connectParam);
                }
            });
        }
        catch (RemoteException e) {
            connectResponse = null;
            ThrowableConvertor<URI, FrameworkRegistrationEntry[], RemoteException> throwableConvertor = new ThrowableConvertor<URI, FrameworkRegistrationEntry[], RemoteException>(){

                public FrameworkRegistrationEntry[] convert(URI uri) throws RemoteException {
                    RegistrationStub registrationStub = new RegistrationStub(context, TfsUtil.appendPath(uri, "Services/v1.0/Registration.asmx"));
                    WebServiceHelper.setupStub((Stub)registrationStub, credentials, uri);
                    GetRegistrationEntries getRegistrationEntriesParam = new GetRegistrationEntries();
                    getRegistrationEntriesParam.setToolId("vstfs");
                    GetRegistrationEntriesResponse registrationEntries1 = registrationStub.getRegistrationEntries(getRegistrationEntriesParam);
                    return registrationEntries1.getGetRegistrationEntriesResult().getRegistrationEntry();
                }
            };
            registrationEntries = TfsServerConnectionHelper.tryDifferentUris(uri, !justAuthenticate, throwableConvertor);
        }
        if (connectResponse != null) {
            ServiceDefinition[] serviceDefinitions;
            uri = (URI)connectResponse.first;
            ConnectionData connectResult = ((ConnectResponse)connectResponse.second).getConnectResult();
            ArrayOfKeyValueOfStringString arrayOfKeyValueOfStringString = connectResult.getAuthorizedUser().getAttributes();
            String domain = TfsServerConnectionHelper.getPropertyValue(arrayOfKeyValueOfStringString, "Domain");
            String userName = TfsServerConnectionHelper.getPropertyValue(arrayOfKeyValueOfStringString, "Account");
            Credentials authorizedCredentials = new Credentials(userName, domain, credentials.getPassword(), credentials.isStorePassword(), credentials.getType());
            if (justAuthenticate) {
                return new ServerDescriptor(authorizedCredentials, uri, null);
            }
            if (pi != null) {
                pi.setText(TFSBundle.message("loading.team.project.collections", new Object[0]));
            }
            if ((serviceDefinitions = connectResult.getLocationServiceData().getServiceDefinitions().getServiceDefinition()) == null) {
                LOG.warn("service definitions node is null");
                throw new HostNotApplicableException(null);
            }
            String catalogServicePath = null;
            for (ServiceDefinition serviceDefinition : serviceDefinitions) {
                if (!"c2f9106f-127a-45b7-b0a3-e0ad8239a2a7".equalsIgnoreCase(serviceDefinition.getIdentifier().getGuid())) continue;
                catalogServicePath = serviceDefinition.getRelativePath();
            }
            if (catalogServicePath == null) {
                LOG.warn("catalog service not found by guid");
                throw new HostNotApplicableException(null);
            }
            Guid catalogResourceId = connectResult.getCatalogResourceId();
            CatalogWebServiceStub catalogService = new CatalogWebServiceStub(context, TfsUtil.appendPath(uri, catalogServicePath));
            WebServiceHelper.setupStub((Stub)catalogService, credentials, uri);
            QueryResources queryResourcesParam = new QueryResources();
            ArrayOfGuid resourceIdentitiers = new ArrayOfGuid();
            resourceIdentitiers.addGuid(catalogResourceId);
            queryResourcesParam.setResourceIdentifiers(resourceIdentitiers);
            QueryResourcesResponse queryResourcesResponse = catalogService.queryResources(queryResourcesParam);
            String referencePath = null;
            for (CatalogResource catalogResource : queryResourcesResponse.getQueryResourcesResult().getCatalogResources().getCatalogResource()) {
                if (!catalogResource.getIdentifier().getGuid().equals(catalogResourceId.getGuid())) continue;
                referencePath = catalogResource.getNodeReferencePaths().getString()[0];
                break;
            }
            if (referencePath == null) {
                throw new HostNotApplicableException(null);
            }
            QueryNodes queryNodesParam = new QueryNodes();
            ArrayOfString pathSpecs = new ArrayOfString();
            pathSpecs.addString(referencePath + "*");
            queryNodesParam.setPathSpecs(pathSpecs);
            ArrayOfGuid resourceTypeFilters = new ArrayOfGuid();
            resourceTypeFilters.addGuid(TFSConstants.PROJECT_COLLECTION_GUID);
            queryNodesParam.setResourceTypeFilters(resourceTypeFilters);
            QueryNodesResponse queryNodesResponse = catalogService.queryNodes(queryNodesParam);
            CatalogResource[] teamProjectCollections = queryNodesResponse.getQueryNodesResult().getCatalogResources().getCatalogResource();
            ArrayList<TeamProjectCollectionDescriptor> descriptors = new ArrayList<TeamProjectCollectionDescriptor>(teamProjectCollections.length);
            for (CatalogResource collectionNode : teamProjectCollections) {
                String instanceId = TfsServerConnectionHelper.getPropertyValue(collectionNode.getProperties(), "InstanceId");
                if (instanceId == null) {
                    throw new HostNotApplicableException(null);
                }
                descriptors.add(new TeamProjectCollectionDescriptor(collectionNode.getDisplayName(), instanceId));
            }
            TfsBeansHolder beans = new TfsBeansHolder(uri);
            return new Tfs2010ServerDescriptor(descriptors, authorizedCredentials, uri, beans);
        }
        LOG.assertTrue(registrationEntries != null);
        uri = (URI)registrationEntries.first;
        if (justAuthenticate) {
            String authorizedUsername = TfsServerConnectionHelper.getAuthorizedCredentialsFor200x(context, uri, credentials);
            Credentials credentials2 = new Credentials(authorizedUsername, credentials.getPassword(), credentials.isStorePassword(), credentials.getType());
            return new ServerDescriptor(credentials2, uri, null);
        }
        String instanceId = null;
        if (registrationEntries.second != null) {
            block5: for (FrameworkRegistrationEntry entry : (FrameworkRegistrationEntry[])registrationEntries.second) {
                if (!"vstfs".equals(entry.getType())) continue;
                for (RegistrationExtendedAttribute2 attribute : entry.getRegistrationExtendedAttributes().getRegistrationExtendedAttribute()) {
                    if (!"InstanceId".equals(attribute.getName())) continue;
                    instanceId = attribute.getValue();
                    break block5;
                }
            }
        }
        if (instanceId == null) {
            throw new HostNotApplicableException(null);
        }
        String string = TfsServerConnectionHelper.getAuthorizedCredentialsFor200x(context, uri, credentials);
        Credentials authorizedCredentials = new Credentials(string, credentials.getPassword(), credentials.isStorePassword(), credentials.getType());
        TfsBeansHolder beans = new TfsBeansHolder(uri);
        Workspace[] workspaces = TfsServerConnectionHelper.queryWorkspaces(authorizedCredentials, pi, beans);
        return new Tfs200xServerDescriptor(instanceId, authorizedCredentials, uri, workspaces, beans);
    }

    private static RemoteException getMoreDescriptiveException(RemoteException first, RemoteException second) {
        if (first instanceof AxisFault && second instanceof AxisFault) {
            if (((AxisFault)first).getFaultDetailElement() == null && ((AxisFault)second).getFaultDetailElement() != null) {
                return second;
            }
            int transportErrorCode1 = TfsExceptionManager.getTransportErrorCode((AxisFault)first);
            int transportErrorCode2 = TfsExceptionManager.getTransportErrorCode((AxisFault)second);
            if (transportErrorCode1 == 404 && transportErrorCode2 != -1) {
                return second;
            }
        }
        return first;
    }

    private static URI getBareUri(URI uri) {
        String path = uri.getPath();
        if (StringUtil.isNotEmpty((String)path) && !path.equals("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
            try {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, null, null);
            }
            catch (URISyntaxException e) {
                LOG.error((Throwable)e);
            }
        }
        return uri;
    }

    private static Workspace[] queryWorkspaces(Credentials authorizedCredentials, @Nullable ProgressIndicator pi, TfsBeansHolder beans) throws RemoteException, HostNotApplicableException {
        if (pi != null) {
            pi.setText(TFSBundle.message("loading.workspaces", new Object[0]));
        }
        QueryWorkspaces param = new QueryWorkspaces();
        param.setOwnerName(authorizedCredentials.getQualifiedUsername());
        param.setComputer(Workstation.getComputerName());
        return beans.getRepositoryStub(authorizedCredentials, pi).queryWorkspaces(param).getQueryWorkspacesResult().getWorkspace();
    }

    private static String getAuthorizedCredentialsFor200x(ConfigurationContext context, URI uri, Credentials credentials) throws RemoteException {
        ServerStatusStub serverStatusStub = new ServerStatusStub(context, TfsUtil.appendPath(uri, "Services/v1.0/ServerStatus.asmx"));
        WebServiceHelper.setupStub((Stub)serverStatusStub, credentials, uri);
        CheckAuthenticationResponse response = serverStatusStub.checkAuthentication(new CheckAuthentication());
        return response.getCheckAuthenticationResult();
    }

    @Nullable
    private static String getPropertyValue(ArrayOfKeyValueOfStringString props, String propertyKey) {
        for (KeyValueOfStringString prop : props.getKeyValueOfStringString()) {
            if (!propertyKey.equals(prop.getKey())) continue;
            return prop.getValue();
        }
        return null;
    }

    private static <T> Pair<URI, T> tryDifferentUris(URI initialUri, boolean doTry, ThrowableConvertor<URI, T, RemoteException> request) throws RemoteException {
        try {
            return Pair.create((Object)initialUri, (Object)request.convert((Object)initialUri));
        }
        catch (RemoteException e) {
            URI uri;
            LOG.debug("connect to URI '" + initialUri + "' failed", (Throwable)e);
            if (!doTry) {
                throw e;
            }
            String path = initialUri.getPath();
            path = StringUtil.isEmpty((String)path) || "/".equals(path) ? "/tfs" : "/";
            try {
                uri = new URI(initialUri.getScheme(), initialUri.getUserInfo(), initialUri.getHost(), initialUri.getPort(), path, null, null);
            }
            catch (URISyntaxException e1) {
                LOG.error((Throwable)e);
                return null;
            }
            LOG.debug("Trying to connect to '" + uri + "'");
            try {
                return Pair.create((Object)uri, (Object)request.convert((Object)uri));
            }
            catch (RemoteException e1) {
                throw TfsServerConnectionHelper.getMoreDescriptiveException(e, e1);
            }
        }
    }

    public static class AddServerResult {
        public final URI uri;
        public final String instanceId;
        public final Credentials authorizedCredentials;
        public final Workspace[] workspaces;
        public final String workspacesLoadError;
        @Nullable
        public final TfsBeansHolder beans;

        public AddServerResult(URI uri, String instanceId, Credentials authorizedCredentials, Workspace[] workspaces, String workspacesLoadError, TfsBeansHolder beans) {
            this.uri = uri;
            this.instanceId = instanceId;
            this.authorizedCredentials = authorizedCredentials;
            this.workspaces = workspaces;
            this.workspacesLoadError = workspacesLoadError;
            this.beans = beans;
        }
    }

    public static class TeamProjectCollectionDescriptor {
        public final String name;
        public final String instanceId;

        public TeamProjectCollectionDescriptor(String name, String instanceId) {
            this.name = name;
            this.instanceId = instanceId;
        }
    }

    private static class Tfs2010ServerDescriptor
    extends ServerDescriptor {
        public final Collection<TeamProjectCollectionDescriptor> teamProjectCollections;

        public Tfs2010ServerDescriptor(Collection<TeamProjectCollectionDescriptor> teamProjectCollections, Credentials authorizedCredentials, URI uri, TfsBeansHolder servicesPaths) {
            super(authorizedCredentials, uri, servicesPaths);
            this.teamProjectCollections = teamProjectCollections;
        }
    }

    private static class Tfs200xServerDescriptor
    extends ServerDescriptor {
        public final String instanceId;
        public final Workspace[] workspaces;

        public Tfs200xServerDescriptor(String instanceId, Credentials authorizedCredentials, URI uri, Workspace[] workspaces, TfsBeansHolder servicesPaths) {
            super(authorizedCredentials, uri, servicesPaths);
            this.instanceId = instanceId;
            this.workspaces = workspaces;
        }
    }

    public static class ServerDescriptor {
        public final Credentials authorizedCredentials;
        @Nullable
        public final TfsBeansHolder beans;
        @Nullable
        public final URI uri;

        protected ServerDescriptor(Credentials authorizedCredentials, URI uri, TfsBeansHolder beans) {
            this.authorizedCredentials = authorizedCredentials;
            this.uri = uri;
            this.beans = beans;
        }

        public String getUserName() {
            return this.authorizedCredentials.getUserName();
        }
    }
}

