/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Component;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.ui.TfsLoginForm;

public class TfsLoginDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)TfsLoginDialog.class.getName());
    private TfsLoginForm myLoginForm;
    @Nullable
    private Condition<TfsLoginDialog> myOkActionCallback;

    public TfsLoginDialog(Project project, URI initialUri, Credentials initialCredentials, boolean allowAddressChange, @Nullable Condition<TfsLoginDialog> okActionCallback) {
        super(project, true);
        this.doInit(initialUri, initialCredentials, allowAddressChange, okActionCallback);
    }

    public TfsLoginDialog(JComponent parentComponent, URI initialUri, Credentials initialCredentials, boolean allowAddressChange, @Nullable Condition<TfsLoginDialog> okActionCallback) {
        super((Component)parentComponent, true);
        this.doInit(initialUri, initialCredentials, allowAddressChange, okActionCallback);
    }

    private void doInit(URI initialUri, Credentials initialCredentials, boolean allowAddressChange, Condition<TfsLoginDialog> okActionCallback) {
        this.myOkActionCallback = okActionCallback;
        this.setTitle(TFSBundle.message(allowAddressChange ? "logindialog.title.connect" : "logindialog.title.login", new Object[0]));
        this.myLoginForm = new TfsLoginForm(initialUri, initialCredentials, allowAddressChange);
        this.myLoginForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TfsLoginDialog.this.revalidate();
            }
        });
        this.init();
        this.revalidate();
    }

    protected JComponent createCenterPanel() {
        return this.myLoginForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLoginForm.getPreferredFocusedComponent();
    }

    private void revalidate() {
        this.setMessage(this.getErrorMessage(), true);
    }

    @Nullable
    private String getErrorMessage() {
        if (StringUtil.isEmptyOrSpaces((String)this.myLoginForm.getUrl())) {
            return TFSBundle.message("login.dialog.address.empty", new Object[0]);
        }
        if (TfsUtil.getUrl(this.myLoginForm.getUrl(), false, false) == null) {
            return TFSBundle.message("login.dialog.address.invalid", new Object[0]);
        }
        if (!this.myLoginForm.isUseNative() && StringUtil.isEmptyOrSpaces((String)this.myLoginForm.getUsername())) {
            return TFSBundle.message("login.dialog.username.empty", new Object[0]);
        }
        return null;
    }

    public URI getUri() {
        URI uri = TfsUtil.getUrl(this.myLoginForm.getUrl(), false, false);
        LOG.assertTrue(uri != null);
        return uri;
    }

    public Credentials getCredentials() {
        return this.myLoginForm.getCredentials();
    }

    public void setMessage(@Nullable String message, boolean disableOkAction) {
        if (message != null && !message.endsWith(".")) {
            message = message + ".";
        }
        this.setErrorText(message);
        this.setOKActionEnabled(!disableOkAction || message == null);
    }

    protected String getDimensionServiceKey() {
        return "TFS.Login";
    }

    protected void doOKAction() {
        if (TfsLoginDialog.shouldPromptForProxyPassword(false)) {
            HttpConfigurable hc = HttpConfigurable.getInstance();
            hc.setPlainProxyPassword(this.myLoginForm.getProxyPassword());
        }
        if (this.myLoginForm.getCredentials().getType() == Credentials.Type.Alternate && "http".equals(this.getUri().getScheme()) && Messages.showYesNoDialog((Component)this.myLoginForm.getContentPane(), (String)"You're about to send your credentials over unsecured HTTP connection. Continue?", (String)this.getTitle(), null) != 0) {
            return;
        }
        if (this.myOkActionCallback == null || this.myOkActionCallback.value((Object)this)) {
            super.doOKAction();
        }
    }

    public static boolean shouldPromptForProxyPassword(boolean strictOnly) {
        HttpConfigurable hc = HttpConfigurable.getInstance();
        return TFSConfigurationManager.getInstance().useIdeaHttpProxy() && hc.USE_HTTP_PROXY && hc.PROXY_AUTHENTICATION && !hc.KEEP_PROXY_PASSWORD && (!strictOnly || StringUtil.isEmpty((String)hc.getPlainProxyPassword()));
    }
}

