/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.ui.TfsLoginDialog;
import org.jetbrains.tfsIntegration.webservice.auth.NativeNTLM2Scheme;

public class TfsLoginForm {
    private JTextField myAddressField;
    private JTextField myUsernameField;
    private JTextField myDomainField;
    private JPasswordField myPasswordField;
    private JCheckBox myStorePasswordCheckbox;
    private JPanel myContentPane;
    private HyperlinkLabel myProxyPasswordLabel;
    private JPasswordField myProxyPasswordField;
    private JPanel myProxyPanel;
    private JLabel myUsernameLabel;
    private JLabel myDomainLabel;
    private JLabel myPasswordLabel;
    private ComboBox myTypeCombo;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public TfsLoginForm(URI initialUri, Credentials initialCredentials, boolean allowUrlChange) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myAddressField.setText(initialUri != null ? TfsUtil.getPresentableUri(initialUri) : null);
        this.myAddressField.setEditable(allowUrlChange);
        this.myUsernameField.setText(initialCredentials != null ? initialCredentials.getUserName() : null);
        this.myDomainField.setText(initialCredentials != null ? initialCredentials.getDomain() : null);
        this.myPasswordField.setText(initialCredentials != null ? initialCredentials.getPassword() : null);
        DocumentAdapter changeListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)TfsLoginForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        };
        this.myAddressField.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.myUsernameField.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.myDomainField.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.myProxyPasswordLabel.setHyperlinkText("", TFSBundle.message("login.dialog.proxy.label.1", new Object[0]), TFSBundle.message("login.dialog.proxy.label.2", new Object[0]));
        this.myProxyPasswordLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HttpConfigurable.editConfigurable((JComponent)TfsLoginForm.this.myContentPane);
                }
            }
        });
        if (TfsLoginDialog.shouldPromptForProxyPassword(false)) {
            HttpConfigurable hc = HttpConfigurable.getInstance();
            this.myProxyPasswordField.setText(hc.getPlainProxyPassword());
            this.myProxyPanel.setVisible(true);
        } else {
            this.myProxyPanel.setVisible(false);
        }
        this.myTypeCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Credentials.Type>(){

            public void customize(JList list, Credentials.Type value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableText());
            }
        });
        if (NativeNTLM2Scheme.isAvailable()) {
            this.myTypeCombo.setModel(new DefaultComboBoxModel<Credentials.Type>(new Credentials.Type[]{Credentials.Type.NtlmNative, Credentials.Type.NtlmExplicit, Credentials.Type.Alternate}));
            this.myTypeCombo.setSelectedItem((Object)(initialCredentials == null ? Credentials.Type.NtlmNative : initialCredentials.getType()));
            this.myTypeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TfsLoginForm.this.updateOnTypeChange();
                    if (TfsLoginForm.this.getCredentialsType() != Credentials.Type.NtlmNative) {
                        IdeFocusManager.findInstanceByComponent((Component)TfsLoginForm.this.myContentPane).requestFocus((Component)TfsLoginForm.this.myUsernameField, true);
                    }
                }
            });
        } else {
            this.myTypeCombo.setModel(new DefaultComboBoxModel<Credentials.Type>(new Credentials.Type[]{Credentials.Type.NtlmExplicit, Credentials.Type.Alternate}));
        }
        this.updateOnTypeChange();
    }

    private Credentials.Type getCredentialsType() {
        return (Credentials.Type)((Object)this.myTypeCombo.getSelectedItem());
    }

    private void updateOnTypeChange() {
        boolean isNative = this.getCredentialsType() == Credentials.Type.NtlmNative;
        this.myUsernameLabel.setEnabled(!isNative);
        this.myUsernameField.setEnabled(!isNative);
        this.myDomainLabel.setEnabled(this.getCredentialsType() == Credentials.Type.NtlmExplicit);
        this.myDomainField.setEnabled(this.getCredentialsType() == Credentials.Type.NtlmExplicit);
        this.myPasswordLabel.setEnabled(!isNative);
        this.myPasswordField.setEnabled(!isNative);
        this.myStorePasswordCheckbox.setEnabled(!isNative);
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myAddressField.isEditable()) {
            return this.myAddressField;
        }
        if (StringUtil.isEmpty((String)this.myUsernameField.getText())) {
            return this.myUsernameField;
        }
        return this.myPasswordField;
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public String getUrl() {
        return this.myAddressField.getText();
    }

    public String getUsername() {
        return this.myUsernameField.getText();
    }

    public String getDomain() {
        return this.myDomainField.getText();
    }

    public String getPassword() {
        return String.valueOf(this.myPasswordField.getPassword());
    }

    public Credentials getCredentials() {
        if (this.getCredentialsType() == Credentials.Type.NtlmNative) {
            return Credentials.createNative();
        }
        return new Credentials(this.getUsername(), this.getDomain(), this.getPassword(), this.myStorePasswordCheckbox.isSelected(), this.getCredentialsType());
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ChangeListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public String getProxyPassword() {
        return String.valueOf(this.myProxyPasswordField.getPassword());
    }

    private void createUIComponents() {
        this.myProxyPasswordLabel = new HyperlinkLabel(){

            protected void applyRenderingHints(Graphics g) {
            }
        };
    }

    public boolean isUseNative() {
        return this.getCredentialsType() == Credentials.Type.NtlmNative;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPasswordField jPasswordField;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPasswordField jPasswordField2;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JTextField jTextField2;
        JLabel jLabel3;
        JTextField jTextField3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Address:");
        jLabel4.setDisplayedMnemonic('A');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddressField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUsernameLabel = jLabel3 = new JLabel();
        jLabel3.setText("User name:");
        jLabel3.setDisplayedMnemonic('U');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDomainLabel = jLabel2 = new JLabel();
        jLabel2.setText("Domain:");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDomainField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordLabel = jLabel = new JLabel();
        jLabel.setText("Password:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStorePasswordCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox.setText("Save password");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myProxyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myProxyPasswordLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myProxyPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 5), null));
        this.myTypeCombo = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Auth:");
        jLabel5.setDisplayedMnemonic('U');
        jLabel5.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel4.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jPasswordField2);
        jLabel5.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

