/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice;

import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;

public class HTTPProxyInfo {
    @Nullable
    public final String host;
    public final int port;
    @Nullable
    public final String user;
    @Nullable
    public final String password;

    private HTTPProxyInfo(@Nullable String host, int port, @Nullable String user, @Nullable String password) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public static boolean shouldPromptForPassword() {
        if (TFSConfigurationManager.getInstance().useIdeaHttpProxy()) {
            HttpConfigurable hc = HttpConfigurable.getInstance();
            return hc.USE_HTTP_PROXY && hc.PROXY_AUTHENTICATION && !hc.KEEP_PROXY_PASSWORD;
        }
        return false;
    }

    public static void promptForPassword() {
        HttpConfigurable hc = HttpConfigurable.getInstance();
        hc.getPromptedAuthentication(hc.PROXY_HOST, "Proxy authentication");
    }

    public static HTTPProxyInfo getCurrent() {
        CommonProxy.isInstalledAssertion();
        if (TFSConfigurationManager.getInstance().useIdeaHttpProxy()) {
            HttpConfigurable hc = HttpConfigurable.getInstance();
            if (hc.USE_HTTP_PROXY) {
                if (hc.PROXY_AUTHENTICATION) {
                    return new HTTPProxyInfo(hc.PROXY_HOST, hc.PROXY_PORT, hc.PROXY_LOGIN, hc.getPlainProxyPassword());
                }
                return new HTTPProxyInfo(hc.PROXY_HOST, hc.PROXY_PORT, null, null);
            }
        }
        return new HTTPProxyInfo(null, -1, null, null);
    }
}

