/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfigurationProducer;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

public class CucumberJavaFeatureRunConfigurationProducer
extends CucumberJavaRunConfigurationProducer {
    @Override
    protected NullableComputable<String> getStepsGlue(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaFeatureRunConfigurationProducer", "getStepsGlue"));
        }
        final PsiFile file = element.getContainingFile();
        if (file instanceof GherkinFile) {
            return new NullableComputable<String>(){

                @Nullable
                public String compute() {
                    CucumberJvmExtensionPoint[] extensions;
                    Set<String> glues = CucumberJavaFeatureRunConfigurationProducer.this.getHookGlue(element);
                    for (CucumberJvmExtensionPoint extension : extensions = (CucumberJvmExtensionPoint[])Extensions.getExtensions((ExtensionPointName)CucumberJvmExtensionPoint.EP_NAME)) {
                        glues.addAll(extension.getGlues((GherkinFile)file, glues));
                    }
                    return StringUtil.join(glues, (String)" ");
                }
            };
        }
        return null;
    }

    @Override
    protected String getConfigurationName(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaFeatureRunConfigurationProducer", "getConfigurationName"));
        }
        VirtualFile featureFile = this.getFileToRun(context);
        assert (featureFile != null);
        return "Feature: " + featureFile.getNameWithoutExtension();
    }

    @Override
    @Nullable
    protected VirtualFile getFileToRun(ConfigurationContext context) {
        PsiElement element = context.getPsiLocation();
        GherkinStepsHolder scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GherkinScenario.class, GherkinScenarioOutline.class});
        if (element != null && scenario == null && element.getContainingFile() instanceof GherkinFile) {
            return element.getContainingFile().getVirtualFile();
        }
        return null;
    }
}

