/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.ActionScriptUnusedImportsHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;

public class JSShortenFQNamesProcessor
implements TemplateOptionalProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.JSShortenFQNamesProcessor");

    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        if (!template.isToShortenLongNames()) {
            return;
        }
        try {
            PsiFile file;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            psiDocumentManager.commitDocument(document);
            PsiFile hostFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            PsiFile psiFile = file = hostFile != null && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)hostFile) ? InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)hostFile, (int)templateRange.getStartOffset()) : hostFile;
            if (file instanceof JSFile && file.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
                ActionScriptUnusedImportsHelper.Results unusedImportsResults = ActionScriptUnusedImportsHelper.getUnusedImports((PsiFile)file);
                for (JSReferenceExpression reference : unusedImportsResults.fqnsToReplaceWithShortName) {
                    FormatFixer fixer;
                    String resolved;
                    TextRange range = InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)file, reference.getTextRange());
                    if (!TextRange.create((Segment)templateRange).contains(range)) continue;
                    String shortName = StringUtil.getShortName((String)reference.getReferencedName());
                    if (shortName.equals(resolved = JSImportHandlingUtil.resolveTypeName((String)shortName, (PsiElement)reference)) && (fixer = ImportUtils.insertImportStatements((PsiElement)reference, Collections.singletonList(reference.getText()))) != null) {
                        fixer.fixFormat();
                    }
                    reference.replace(JSChangeUtil.createExpressionFromText((Project)project, (String)shortName).getPsi());
                }
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.shorten.fq.names", (Object[])new Object[0]);
    }

    public boolean isEnabled(Template template) {
        return template.isToShortenLongNames();
    }

    public void setEnabled(Template template, boolean value) {
    }

    public boolean isVisible(Template template) {
        return false;
    }
}

