/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.NonStructuralModifiableBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        VirtualFile file;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (element instanceof PsiDirectoryContainer || element instanceof JSPackage || element instanceof JSPackageStatement) {
            String packageName = FlexRefactoringListenerProvider.getPackageName(element);
            return StringUtil.isEmpty((String)packageName) ? null : new PackageRefactoringListener(element.getProject(), module, packageName);
        }
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return null;
        }
        JSClass jsClass = FlexRefactoringListenerProvider.getJSClass(element);
        if (jsClass != null) {
            return new JSClassRefactoringListener(module, jsClass.getQualifiedName());
        }
        VirtualFile virtualFile = file = element instanceof PsiFile ? element.getContainingFile().getVirtualFile() : null;
        if (file != null) {
            if ("css".equalsIgnoreCase(file.getExtension())) {
                return new CssFileRefactoringListener(module, file.getPath());
            }
            if ("xml".equalsIgnoreCase(file.getExtension())) {
                return new XmlFileRefactoringListener(module, file.getPath());
            }
        }
        return null;
    }

    @Nullable
    public static JSClass getJSClass(PsiElement element) {
        if (element instanceof JSClass) {
            return (JSClass)element;
        }
        if (element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((XmlFile)element))) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
        }
        if (element instanceof JSFile) {
            return JSPsiImplUtils.findClass((JSFile)((JSFile)element));
        }
        return null;
    }

    @Nullable
    public static String getPackageName(PsiElement element) {
        assert (element instanceof PsiDirectoryContainer || element instanceof JSPackage || element instanceof JSPackageStatement);
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element).getDirectories();
            if (directories.length == 0) {
                return null;
            }
            return DirectoryIndex.getInstance((Project)element.getProject()).getPackageName(directories[0].getVirtualFile());
        }
        return ((JSQualifiedNamedElement)element).getQualifiedName();
    }

    private static class XmlFileRefactoringListener
    extends FileRefactoringListener {
        public XmlFileRefactoringListener(Module module, String oldFilePath) {
            super(module, oldFilePath);
        }

        @Override
        protected void filePathChanged(String oldFilePath, final String newFilePath) {
            for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(this.myModule).getBuildConfigurations()) {
                if (!bc.getCompilerOptions().getAdditionalConfigFilePath().equals(oldFilePath)) continue;
                FlexProjectConfigurationEditor.makeNonStructuralModification(bc, new Consumer<NonStructuralModifiableBuildConfiguration>(){

                    public void consume(NonStructuralModifiableBuildConfiguration configuration) {
                        configuration.getCompilerOptions().setAdditionalConfigFilePath(newFilePath);
                    }
                });
            }
        }
    }

    private static class CssFileRefactoringListener
    extends FileRefactoringListener {
        public CssFileRefactoringListener(Module module, String oldFilePath) {
            super(module, oldFilePath);
        }

        @Override
        protected void filePathChanged(String oldFilePath, String newFilePath) {
            for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(this.myModule).getBuildConfigurations()) {
                Collection<String> cssFiles;
                if (!BCUtils.canHaveRLMsAndRuntimeStylesheets(bc) || (cssFiles = bc.getCssFilesToCompile()).isEmpty()) continue;
                final ArrayList<String> newCssFiles = new ArrayList<String>(cssFiles.size());
                boolean changed = false;
                for (String cssFile : cssFiles) {
                    if (cssFile.equals(oldFilePath)) {
                        newCssFiles.add(newFilePath);
                        changed = true;
                        continue;
                    }
                    newCssFiles.add(cssFile);
                }
                if (!changed) continue;
                FlexProjectConfigurationEditor.makeNonStructuralModification(bc, new Consumer<NonStructuralModifiableBuildConfiguration>(){

                    public void consume(NonStructuralModifiableBuildConfiguration configuration) {
                        configuration.setCssFilesToCompile(newCssFiles);
                    }
                });
            }
        }
    }

    private static abstract class FileRefactoringListener
    extends RefactoringElementAdapter {
        @NotNull
        protected final Module myModule;
        protected final String myOldFilePath;
        protected String myNewFilePath;

        public FileRefactoringListener(@NotNull Module module, String oldFilePath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$FileRefactoringListener", "<init>"));
            }
            this.myModule = module;
            this.myOldFilePath = oldFilePath;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            VirtualFile file;
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$FileRefactoringListener", "elementRenamedOrMoved"));
            }
            VirtualFile virtualFile = file = newElement instanceof PsiFile ? ((PsiFile)newElement).getVirtualFile() : null;
            if (file != null) {
                this.myNewFilePath = file.getPath();
                this.filePathChanged(this.myOldFilePath, this.myNewFilePath);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldFilePath) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$FileRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (oldFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFilePath", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$FileRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (this.myNewFilePath != null) {
                this.filePathChanged(this.myNewFilePath, this.myOldFilePath);
            }
        }

        protected abstract void filePathChanged(String var1, String var2);
    }

    private static class JSClassRefactoringListener
    extends RefactoringElementAdapter {
        private final Module myModule;
        private final String myOldClassName;
        private String myNewClassName;

        public JSClassRefactoringListener(Module module, String oldClassName) {
            this.myModule = module;
            this.myOldClassName = oldClassName;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$JSClassRefactoringListener", "elementRenamedOrMoved"));
            }
            JSClass newClass = FlexRefactoringListenerProvider.getJSClass(newElement);
            if (newClass != null) {
                this.myNewClassName = newClass.getQualifiedName();
                this.classNameChanged(this.myOldClassName, this.myNewClassName);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$JSClassRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$JSClassRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (this.myNewClassName != null) {
                this.classNameChanged(this.myNewClassName, this.myOldClassName);
            }
        }

        private void classNameChanged(String oldClassName, final String newClassName) {
            for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(this.myModule).getBuildConfigurations()) {
                if (bc.getOutputType() == OutputType.Application && bc.getMainClass().equals(oldClassName)) {
                    FlexProjectConfigurationEditor.makeNonStructuralModification(bc, new Consumer<NonStructuralModifiableBuildConfiguration>(){

                        public void consume(NonStructuralModifiableBuildConfiguration configuration) {
                            configuration.setMainClass(newClassName);
                        }
                    });
                }
                if (!BCUtils.canHaveRLMsAndRuntimeStylesheets(bc)) continue;
                Collection<FlexBuildConfiguration.RLMInfo> oldRLMs = bc.getRLMs();
                final ArrayList<FlexBuildConfiguration.RLMInfo> newRLMs = new ArrayList<FlexBuildConfiguration.RLMInfo>();
                boolean changed = false;
                for (FlexBuildConfiguration.RLMInfo rlm : oldRLMs) {
                    if (rlm.MAIN_CLASS.equals(oldClassName)) {
                        changed = true;
                        String outputFileName = rlm.OUTPUT_FILE.equals(BCUtils.suggestRLMOutputPath(rlm.MAIN_CLASS)) ? BCUtils.suggestRLMOutputPath(newClassName) : rlm.OUTPUT_FILE;
                        newRLMs.add(new FlexBuildConfiguration.RLMInfo(newClassName, outputFileName, rlm.OPTIMIZE));
                        continue;
                    }
                    newRLMs.add(rlm);
                }
                if (!changed) continue;
                FlexProjectConfigurationEditor.makeNonStructuralModification(bc, new Consumer<NonStructuralModifiableBuildConfiguration>(){

                    public void consume(NonStructuralModifiableBuildConfiguration configuration) {
                        configuration.setRLMs(newRLMs);
                    }
                });
            }
        }
    }

    private static class PackageRefactoringListener
    extends RefactoringElementAdapter {
        @NotNull
        private final Project myProject;
        @Nullable
        private final Module myModule;
        private final String myOldPackageName;
        private String myNewPackageName;

        public PackageRefactoringListener(@NotNull Project project, @Nullable Module module, String oldPackageName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$PackageRefactoringListener", "<init>"));
            }
            this.myProject = project;
            this.myModule = module;
            this.myOldPackageName = oldPackageName;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$PackageRefactoringListener", "elementRenamedOrMoved"));
            }
            String newPackageName = FlexRefactoringListenerProvider.getPackageName(newElement);
            if (newPackageName != null) {
                this.myNewPackageName = newPackageName;
                this.updatePackageName(this.myOldPackageName, this.myNewPackageName);
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$PackageRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$PackageRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (this.myNewPackageName != null) {
                this.updatePackageName(this.myNewPackageName, this.myOldPackageName);
            }
        }

        private void updatePackageName(String oldPackageName, String newPackageName) {
            if (this.myModule == null) {
                for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
                    PackageRefactoringListener.packageNameChanged(module, oldPackageName, newPackageName);
                }
            } else {
                PackageRefactoringListener.packageNameChanged(this.myModule, oldPackageName, newPackageName);
            }
        }

        private static void packageNameChanged(@NotNull Module module, String oldPackageName, String newPackageName) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/FlexRefactoringListenerProvider$PackageRefactoringListener", "packageNameChanged"));
            }
            String oldPackageWithDot = oldPackageName + ".";
            for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                if (bc.getOutputType() == OutputType.Application && bc.getMainClass().startsWith(oldPackageWithDot)) {
                    final String mainClass = (newPackageName.isEmpty() ? "" : newPackageName + ".") + bc.getMainClass().substring(oldPackageWithDot.length());
                    FlexProjectConfigurationEditor.makeNonStructuralModification(bc, new Consumer<NonStructuralModifiableBuildConfiguration>(){

                        public void consume(NonStructuralModifiableBuildConfiguration configuration) {
                            configuration.setMainClass(mainClass);
                        }
                    });
                }
                if (!BCUtils.canHaveRLMsAndRuntimeStylesheets(bc)) continue;
                Collection<FlexBuildConfiguration.RLMInfo> oldRLMs = bc.getRLMs();
                final ArrayList<FlexBuildConfiguration.RLMInfo> newRLMs = new ArrayList<FlexBuildConfiguration.RLMInfo>();
                boolean changed = false;
                for (FlexBuildConfiguration.RLMInfo rlm : oldRLMs) {
                    if (rlm.MAIN_CLASS.startsWith(oldPackageWithDot)) {
                        changed = true;
                        String mainClass = (newPackageName.isEmpty() ? "" : newPackageName + ".") + rlm.MAIN_CLASS.substring(oldPackageWithDot.length());
                        String outputFileName = rlm.OUTPUT_FILE.equals(BCUtils.suggestRLMOutputPath(rlm.MAIN_CLASS)) ? BCUtils.suggestRLMOutputPath(mainClass) : rlm.OUTPUT_FILE;
                        newRLMs.add(new FlexBuildConfiguration.RLMInfo(mainClass, outputFileName, rlm.OPTIMIZE));
                        continue;
                    }
                    newRLMs.add(rlm);
                }
                if (!changed) continue;
                FlexProjectConfigurationEditor.makeNonStructuralModification(bc, new Consumer<NonStructuralModifiableBuildConfiguration>(){

                    public void consume(NonStructuralModifiableBuildConfiguration configuration) {
                        configuration.setRLMs(newRLMs);
                    }
                });
            }
        }
    }
}

