/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexStackTraceFilter
implements Filter {
    public static final String GLOBAL_PREFIX = "global/";
    private final Project myProject;
    private static final String AT = "at ";

    public FlexStackTraceFilter(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        String pathAndLineNumber;
        String trimmed = StringUtil.trimStart((String)line, (String)"[trace]").trim();
        int bracketOpenIndex = line.lastIndexOf(91);
        if (!trimmed.startsWith(AT) || bracketOpenIndex < 0 || !trimmed.endsWith("]")) {
            return null;
        }
        int bracketCloseIndex = line.lastIndexOf(93);
        String filePath = pathAndLineNumber = FileUtil.toSystemIndependentName((String)line.substring(bracketOpenIndex + 1, bracketCloseIndex));
        int lineNumber = -1;
        int colonIndex = pathAndLineNumber.lastIndexOf(58);
        if (colonIndex > 0) {
            try {
                lineNumber = Integer.parseInt(pathAndLineNumber.substring(colonIndex + 1)) - 1;
                filePath = pathAndLineNumber.substring(0, colonIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (filePath.startsWith("//")) {
            return null;
        }
        String fileName = PathUtil.getFileName((String)filePath);
        if (!FlexCommonUtils.isSourceFile((String)fileName)) {
            return null;
        }
        int atIndex = line.indexOf(AT);
        String fqnInfo = line.substring(atIndex + AT.length(), bracketOpenIndex).trim();
        int slashOrParenIndex = StringUtil.indexOfAny((String)(fqnInfo = StringUtil.trimStart((String)fqnInfo, (String)GLOBAL_PREFIX)), (String)"/(");
        if (slashOrParenIndex > 0) {
            String relativePath;
            String somethingLikeFqn = fqnInfo.substring(0, slashOrParenIndex);
            somethingLikeFqn = StringUtil.trimEnd((String)somethingLikeFqn, (String)"$");
            int dotIndex = fileName.lastIndexOf(46);
            String dotExtension = dotIndex < 0 ? "" : fileName.substring(dotIndex);
            String fileNameWithoutExtension = FileUtil.getNameWithoutExtension((String)fileName);
            if ((somethingLikeFqn.equals(fileNameWithoutExtension) || somethingLikeFqn.endsWith("::" + fileNameWithoutExtension)) && filePath.endsWith(relativePath = StringUtil.replace((String)somethingLikeFqn, (String)"::", (String)"/").replace('.', '/') + dotExtension)) {
                int textStartOffset = entireLength - line.length();
                int highlightEndOffset = textStartOffset + bracketCloseIndex;
                return this.applyFlexStackTraceFilter(filePath, relativePath, lineNumber, highlightEndOffset);
            }
        }
        return null;
    }

    @Nullable
    private Filter.Result applyFlexStackTraceFilter(String filePath, String matchingRelativePath, int lineNumber, int highlightEndOffset) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Collection files = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)PathUtil.getFileName((String)filePath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        for (VirtualFile file : files) {
            if (!file.getPath().endsWith(matchingRelativePath)) continue;
            result.add(file);
        }
        if (!result.isEmpty()) {
            int colonLineNumberLength = lineNumber > 0 ? ":".length() + String.valueOf(lineNumber).length() : 0;
            int highlightingLength = matchingRelativePath.length() + colonLineNumberLength;
            if (result.size() == 1 && ((VirtualFile)result.iterator().next()).getPath().equals(filePath)) {
                highlightingLength = filePath.length() + colonLineNumberLength;
            }
            int highlightStartOffset = highlightEndOffset - highlightingLength;
            return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)new OpenOneOfSeveralFilesHyperlinkInfo(result, lineNumber));
        }
        return null;
    }

    private static class OpenOneOfSeveralFilesHyperlinkInfo
    implements HyperlinkInfo {
        private final Collection<VirtualFile> myFiles;
        private final int myLine;

        public OpenOneOfSeveralFilesHyperlinkInfo(@NotNull Collection<VirtualFile> files, int line) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/flex/FlexStackTraceFilter$OpenOneOfSeveralFilesHyperlinkInfo", "<init>"));
            }
            this.myFiles = files;
            this.myLine = line;
        }

        public void navigate(Project project) {
            ArrayList<VirtualFile> validFiles = new ArrayList<VirtualFile>(this.myFiles.size());
            for (VirtualFile file : this.myFiles) {
                if (!file.isValid()) continue;
                validFiles.add(file);
            }
            if (validFiles.isEmpty()) {
                return;
            }
            if (validFiles.size() == 1) {
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, (VirtualFile)validFiles.get(0), this.myLine, 0), true);
            } else {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>(validFiles.size());
                for (VirtualFile file : validFiles) {
                    PsiFile psiFile = psiManager.findFile(file);
                    if (psiFile == null) continue;
                    psiFiles.add(psiFile);
                }
                JBList list = new JBList((Object[])PsiUtilCore.toPsiFileArray(psiFiles));
                list.setCellRenderer(new DefaultPsiElementCellRenderer());
                PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
                JBPopup popup = builder.setItemChoosenCallback(new Runnable((JList)list, project){
                    final /* synthetic */ JList val$list;
                    final /* synthetic */ Project val$project;
                    {
                        this.val$list = jList;
                        this.val$project = project;
                    }

                    @Override
                    public void run() {
                        VirtualFile file;
                        Object[] selectedElements = this.val$list.getSelectedValues();
                        if (selectedElements != null && selectedElements.length == 1 && selectedElements[0] instanceof PsiFile && (file = ((PsiFile)selectedElements[0]).getVirtualFile()) != null) {
                            FileEditorManager.getInstance((Project)this.val$project).openTextEditor(new OpenFileDescriptor(this.val$project, file, myLine, 0), true);
                        }
                    }
                }).createPopup();
                JFrame frame = WindowManager.getInstance().getFrame(project);
                Point mousePosition = frame.getMousePosition();
                if (mousePosition != null) {
                    popup.show(new RelativePoint((Component)frame, mousePosition));
                }
            }
        }
    }
}

