/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.AirDescriptorOptions;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.build.FlexCompilationTask;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.build.FlexCompilerException;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.projectStructure.FlexProjectLevelCompilerOptionsHolder;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.Dependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCompilationUtils {
    private FlexCompilationUtils() {
    }

    static void deleteCacheForFile(String filePath) throws IOException {
        final VirtualFile cacheFile = LocalFileSystem.getInstance().findFileByPath(filePath + ".cache");
        if (cacheFile != null) {
            final Ref exceptionRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            if (cacheFile.exists()) {
                                try {
                                    cacheFile.delete((Object)this);
                                }
                                catch (IOException e) {
                                    exceptionRef.set((Object)e);
                                }
                            }
                        }
                    });
                }
            }, ProgressManager.getInstance().getProgressIndicator().getModalityState());
            if (!exceptionRef.isNull()) {
                throw (IOException)exceptionRef.get();
            }
        }
    }

    static List<String> buildCommand(List<String> compilerCommand, List<VirtualFile> configFiles, Module module, FlexBuildConfiguration bc) {
        ArrayList<String> command = new ArrayList<String>(compilerCommand);
        for (VirtualFile configFile : configFiles) {
            command.add("-load-config=" + configFile.getPath());
        }
        Sdk sdk = bc.getSdk();
        assert (sdk != null);
        FlexCompilationUtils.addAdditionalOptions(command, module, sdk.getHomePath(), FlexProjectLevelCompilerOptionsHolder.getInstance(module.getProject()).getProjectLevelCompilerOptions().getAdditionalOptions());
        FlexCompilationUtils.addAdditionalOptions(command, module, sdk.getHomePath(), FlexBuildConfigurationManager.getInstance(module).getModuleLevelCompilerOptions().getAdditionalOptions());
        FlexCompilationUtils.addAdditionalOptions(command, module, sdk.getHomePath(), bc.getCompilerOptions().getAdditionalOptions());
        return command;
    }

    private static void addAdditionalOptions(List<String> command, Module module, String sdkHome, String additionalOptions) {
        if (!StringUtil.isEmpty((String)additionalOptions)) {
            for (String s : StringUtil.split((String)additionalOptions, (String)" ")) {
                command.add(FlexUtils.replacePathMacros(s, module, sdkHome));
            }
        }
    }

    static List<String> getMxmlcCompcCommand(Project project, Sdk flexSdk, boolean isApp) {
        String mainClass = isApp ? (FlexSdkUtils.isFlex4Sdk(flexSdk) ? "flex2.tools.Mxmlc" : "flex2.tools.Compiler") : "flex2.tools.Compc";
        String additionalClasspath = FileUtil.toSystemDependentName((String)FlexCommonUtils.getPathToBundledJar((String)"idea-flex-compiler-fix.jar"));
        if (!(flexSdk.getSdkType() instanceof FlexmojosSdkType)) {
            additionalClasspath = additionalClasspath + File.pathSeparator + FileUtil.toSystemDependentName((String)(flexSdk.getHomePath() + "/lib/compc.jar"));
        }
        return FlexSdkUtils.getCommandLineForSdkTool(project, flexSdk, additionalClasspath, mainClass, null);
    }

    static List<String> getASC20Command(Project project, Sdk flexSdk, boolean isApp) {
        String mainClass = isApp ? "com.adobe.flash.compiler.clients.MXMLC" : "com.adobe.flash.compiler.clients.COMPC";
        String additionalClasspath = flexSdk.getSdkType() instanceof FlexmojosSdkType ? null : FileUtil.toSystemDependentName((String)(flexSdk.getHomePath() + "/lib/compiler.jar"));
        return FlexSdkUtils.getCommandLineForSdkTool(project, flexSdk, additionalClasspath, mainClass, null);
    }

    static boolean handleCompilerOutput(FlexCompilationManager compilationManager, FlexCompilationTask task, String output) {
        boolean failureDetected = false;
        List lines = StringUtil.split((String)StringUtil.replace((String)output, (String)"\r", (String)"\n"), (String)"\n");
        for (int i = 0; i < lines.size(); ++i) {
            String nextLine;
            String text = (String)lines.get(i);
            if (StringUtil.isEmptyOrSpaces((String)text) || "^".equals(text.trim())) continue;
            String string = nextLine = i + 1 < lines.size() ? (String)lines.get(i + 1) : null;
            if (nextLine != null && nextLine.trim().equals("^")) continue;
            Matcher matcher = FlexCommonUtils.ERROR_PATTERN.matcher(text);
            if (matcher.matches()) {
                String filePath = matcher.group(1);
                String additionalInfo = matcher.group(2);
                String line = matcher.group(3);
                String column = matcher.group(4);
                String type = matcher.group(5);
                String message = matcher.group(6);
                CompilerMessageCategory messageCategory = "Warning".equals(type) ? CompilerMessageCategory.WARNING : CompilerMessageCategory.ERROR;
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
                StringBuilder fullMessage = new StringBuilder();
                if (file == null) {
                    fullMessage.append(filePath).append(": ");
                }
                if (additionalInfo != null) {
                    fullMessage.append(additionalInfo).append(' ');
                }
                fullMessage.append(message);
                compilationManager.addMessage(task, messageCategory, fullMessage.toString(), file != null ? file.getUrl() : null, line != null ? Integer.parseInt(line) : 0, column != null ? Integer.parseInt(column) : 0);
                failureDetected |= messageCategory == CompilerMessageCategory.ERROR;
                continue;
            }
            if (text.startsWith("Error: ") || text.startsWith("Exception in thread \"")) {
                String updatedText = text.startsWith("Error: ") ? text.substring("Error: ".length()) : text;
                compilationManager.addMessage(task, CompilerMessageCategory.ERROR, updatedText, null, -1, -1);
                failureDetected = true;
                continue;
            }
            compilationManager.addMessage(task, CompilerMessageCategory.INFORMATION, text, null, -1, -1);
        }
        return !failureDetected;
    }

    public static void ensureOutputFileWritable(final Project project, String filePath) {
        final VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file != null && !file.isWritable()) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file});
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public static void performPostCompileActions(Module module, @NotNull FlexBuildConfiguration bc, List<String> compileInfoMessages) throws FlexCompilerException {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/build/FlexCompilationUtils", "performPostCompileActions"));
        }
        FlexCompilationManager.refreshAndFindFileInWriteAction(bc.getActualOutputFilePath(), new String[0]);
        Sdk sdk = bc.getSdk();
        assert (sdk != null);
        LinkageType linkage = bc.getDependencies().getFrameworkLinkage();
        if (linkage == LinkageType.Default) {
            linkage = FlexCommonUtils.getDefaultFrameworkLinkage((String)sdk.getVersionString(), (BuildConfigurationNature)bc.getNature());
        }
        if (linkage == LinkageType.RSL) {
            FlexCompilationUtils.handleFrameworkRsls(bc, compileInfoMessages);
        }
        if (bc.getOutputType() != OutputType.Application || BCUtils.isRLMTemporaryBC(bc) || BCUtils.isRuntimeStyleSheetBC(bc)) {
            return;
        }
        switch (bc.getTargetPlatform()) {
            case Web: {
                if (!bc.isUseHtmlWrapper()) break;
                FlexCompilationUtils.handleHtmlWrapper(module, bc);
                break;
            }
            case Desktop: {
                FlexCompilationUtils.handleAirDescriptor(module, bc, bc.getAirDesktopPackagingOptions());
                break;
            }
            case Mobile: {
                if (bc.getAndroidPackagingOptions().isEnabled()) {
                    FlexCompilationUtils.handleAirDescriptor(module, bc, bc.getAndroidPackagingOptions());
                }
                if (!bc.getIosPackagingOptions().isEnabled()) break;
                FlexCompilationUtils.handleAirDescriptor(module, bc, bc.getIosPackagingOptions());
            }
        }
    }

    private static void handleFrameworkRsls(FlexBuildConfiguration bc, List<String> compileInfoMessages) throws FlexCompilerException {
        Sdk sdk = bc.getSdk();
        assert (sdk != null);
        if (!FlexSdkUtils.isAirSdkWithoutFlex(sdk) && StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4.8") >= 0) {
            List<String> rsls = FlexCompilationUtils.getRequiredRsls(compileInfoMessages);
            THashSet filesToRefresh = new THashSet();
            String rslBaseDir = sdk.getHomePath() + "/frameworks/rsls/";
            String outputPath = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
            for (String rsl : rsls) {
                File file = new File(rslBaseDir + rsl);
                if (!file.isFile()) continue;
                try {
                    File toFile = new File(outputPath + '/' + rsl);
                    FileUtil.copy((File)file, (File)toFile);
                    filesToRefresh.add(toFile);
                }
                catch (IOException e) {
                    throw new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.copy.file", (Object[])new Object[]{rsl, rslBaseDir, outputPath, e.getMessage()}));
                }
            }
            CompilerUtil.refreshIOFiles((Collection)filesToRefresh);
        }
    }

    private static List<String> getRequiredRsls(List<String> compileInfoMessages) {
        ArrayList<String> rsls = new ArrayList<String>();
        boolean rslListStarted = false;
        for (String message : compileInfoMessages) {
            if (rslListStarted) {
                if (!message.startsWith("    ") || message.length() <= 4 || Character.isWhitespace(message.charAt(5))) break;
                String text = message.substring(4);
                int nextSpaceIndex = text.indexOf(32);
                rsls.add(nextSpaceIndex == -1 ? text : text.substring(0, nextSpaceIndex));
                continue;
            }
            if (!"Required RSLs:".equals(message)) continue;
            rslListStarted = true;
        }
        return rsls;
    }

    private static void handleHtmlWrapper(final Module module, final FlexBuildConfiguration bc) throws FlexCompilerException {
        final VirtualFile templateDir = LocalFileSystem.getInstance().findFileByPath(bc.getWrapperTemplatePath());
        if (templateDir == null || !templateDir.isDirectory()) {
            throw new FlexCompilerException(FlexCommonBundle.message((String)"html.wrapper.dir.not.found", (Object[])new Object[]{bc.getWrapperTemplatePath()}));
        }
        final VirtualFile templateFile = templateDir.findChild("index.template.html");
        if (templateFile == null) {
            throw new FlexCompilerException(FlexCommonBundle.message((String)"no.index.template.html.file", (Object[])new Object[]{bc.getWrapperTemplatePath()}));
        }
        final InfoFromConfigFile info = FlexCompilerConfigFileUtil.getInfoFromConfigFile(bc.getCompilerOptions().getAdditionalConfigFilePath());
        String outputFolderPath = StringUtil.notNullize((String)info.getOutputFolderPath(), (String)bc.getOutputFolder());
        final String outputFileName = bc.isTempBCForCompilation() ? bc.getOutputFileName() : StringUtil.notNullize((String)info.getOutputFileName(), (String)bc.getOutputFileName());
        final String targetPlayer = StringUtil.notNullize((String)info.getTargetPlayer(), (String)bc.getDependencies().getTargetPlayer());
        final VirtualFile outputDir = LocalFileSystem.getInstance().findFileByPath(outputFolderPath);
        if (outputDir == null || !outputDir.isDirectory()) {
            throw new FlexCompilerException(FlexCommonBundle.message((String)"output.folder.does.not.exist", (Object[])new Object[]{outputFolderPath}));
        }
        final Ref exceptionRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                exceptionRef.set(ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<FlexCompilerException>(){

                    public FlexCompilerException compute() {
                        for (VirtualFile file : templateDir.getChildren()) {
                            if (Comparing.equal((Object)file, (Object)templateFile)) {
                                String wrapperText;
                                try {
                                    wrapperText = VfsUtilCore.loadText((VirtualFile)file);
                                }
                                catch (IOException e) {
                                    return new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.load.template.file", (Object[])new Object[]{file.getPresentableUrl(), e.getMessage()}));
                                }
                                if (!wrapperText.contains("${swf}")) {
                                    return new FlexCompilerException(FlexCommonBundle.message((String)"no.swf.macro", (Object[])new Object[]{FileUtil.toSystemDependentName((String)file.getPath())}));
                                }
                                String mainClass = StringUtil.notNullize((String)info.getMainClass(module), (String)bc.getMainClass());
                                PsiElement jsClass = ActionScriptClassResolver.findClassByQNameStatic(mainClass, module.getModuleScope());
                                String fixedText = FlexCompilationUtils.replaceMacros(wrapperText, FileUtil.getNameWithoutExtension((String)outputFileName), targetPlayer, jsClass instanceof JSClass ? (JSClass)jsClass : null);
                                String wrapperFileName = BCUtils.getWrapperFileName(bc);
                                try {
                                    FlexUtils.addFileWithContent(wrapperFileName, fixedText, outputDir);
                                    continue;
                                }
                                catch (IOException e) {
                                    return new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.create.file.in", (Object[])new Object[]{wrapperFileName, outputDir.getPresentableUrl(), e.getMessage()}));
                                }
                            }
                            try {
                                file.copy((Object)this, outputDir, file.getName());
                            }
                            catch (IOException e) {
                                return new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.copy.file", (Object[])new Object[]{file.getName(), templateDir.getPath(), outputDir.getPath(), e.getMessage()}));
                            }
                        }
                        return null;
                    }
                }));
            }
        }, ModalityState.any());
        if (!exceptionRef.isNull()) {
            throw (FlexCompilerException)exceptionRef.get();
        }
    }

    private static String replaceMacros(String wrapperText, String outputFileName, String targetPlayer, @Nullable JSClass mainClass) {
        PsiFile psiFile;
        THashMap replacementMap = new THashMap();
        replacementMap.put("${swf}", outputFileName);
        replacementMap.put("${title}", outputFileName);
        replacementMap.put("${application}", outputFileName);
        replacementMap.put("${bgcolor}", "#ffffff");
        replacementMap.put("${width}", "100%");
        replacementMap.put("${height}", "100%");
        List versionParts = StringUtil.split((String)targetPlayer, (String)".");
        replacementMap.put("${version_major}", versionParts.size() >= 1 ? (String)versionParts.get(0) : "0");
        replacementMap.put("${version_minor}", versionParts.size() >= 2 ? (String)versionParts.get(1) : "0");
        replacementMap.put("${version_revision}", versionParts.size() >= 3 ? (String)versionParts.get(2) : "0");
        final Ref swfMetadataRef = new Ref();
        PsiFile psiFile2 = psiFile = mainClass == null ? null : mainClass.getContainingFile();
        if (psiFile instanceof XmlFile) {
            XmlTag rootTag = ((XmlFile)psiFile).getRootTag();
            if (rootTag != null) {
                String ns = rootTag.getPrefixByNamespace("http://ns.adobe.com/mxml/2009") == null ? "http://www.adobe.com/2006/mxml" : "http://ns.adobe.com/mxml/2009";
                for (XmlTag tag : rootTag.findSubTags("Metadata", ns)) {
                    JSResolveUtil.processInjectedFileForTag((XmlTag)tag, (JSResolveUtil.JSInjectedFilesVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                        protected void process(JSFile file) {
                            for (PsiElement elt : file.getChildren()) {
                                if (!(elt instanceof JSAttributeList)) continue;
                                JSAttribute swfMetadata = ((JSAttributeList)elt).findAttributeByName("SWF");
                                if (!swfMetadataRef.isNull() || swfMetadata == null) continue;
                                swfMetadataRef.set((Object)swfMetadata);
                                return;
                            }
                        }
                    });
                }
            }
        } else {
            JSAttributeList attributeList = mainClass == null ? null : mainClass.getAttributeList();
            swfMetadataRef.set(attributeList == null ? null : attributeList.findAttributeByName("SWF"));
        }
        if (!swfMetadataRef.isNull()) {
            JSAttribute swfMetadata = (JSAttribute)swfMetadataRef.get();
            JSAttributeNameValuePair titleAttr = swfMetadata.getValueByName("pageTitle");
            ContainerUtil.putIfNotNull((Object)"${title}", (Object)(titleAttr == null ? null : titleAttr.getSimpleValue()), (Map)replacementMap);
            JSAttributeNameValuePair bgColorAttr = swfMetadata.getValueByName("backgroundColor");
            ContainerUtil.putIfNotNull((Object)"${bgcolor}", (Object)(bgColorAttr == null ? null : bgColorAttr.getSimpleValue()), (Map)replacementMap);
            JSAttributeNameValuePair widthAttr = swfMetadata.getValueByName("width");
            ContainerUtil.putIfNotNull((Object)"${width}", (Object)(widthAttr == null ? null : widthAttr.getSimpleValue()), (Map)replacementMap);
            JSAttributeNameValuePair heightAttr = swfMetadata.getValueByName("height");
            ContainerUtil.putIfNotNull((Object)"${height}", (Object)(heightAttr == null ? null : heightAttr.getSimpleValue()), (Map)replacementMap);
        }
        return FlexCommonUtils.replace((String)wrapperText, (Map)replacementMap);
    }

    private static void handleAirDescriptor(Module module, FlexBuildConfiguration bc, AirPackagingOptions packagingOptions) throws FlexCompilerException {
        if (packagingOptions.isUseGeneratedDescriptor()) {
            boolean android = packagingOptions instanceof AndroidPackagingOptions;
            boolean ios = packagingOptions instanceof IosPackagingOptions;
            FlexCompilationUtils.generateAirDescriptor(module, bc, BCUtils.getGeneratedAirDescriptorName(bc, packagingOptions), android, ios);
        } else {
            FlexCompilationUtils.copyAndFixCustomAirDescriptor(bc, packagingOptions);
        }
    }

    private static void generateAirDescriptor(final Module module, final FlexBuildConfiguration bc, final String descriptorFileName, final boolean android, final boolean ios) throws FlexCompilerException {
        final Ref exceptionRef = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Sdk sdk = bc.getSdk();
                assert (sdk != null);
                String outputFilePath = bc.getActualOutputFilePath();
                String outputFolderPath = PathUtil.getParentPath((String)outputFilePath);
                final VirtualFile outputFolder = LocalFileSystem.getInstance().findFileByPath(outputFolderPath);
                if (outputFolder == null) {
                    exceptionRef.set((Object)new FlexCompilerException(FlexCommonBundle.message((String)"output.folder.does.not.exist", (Object[])new Object[]{FileUtil.toSystemDependentName((String)outputFolderPath)})));
                    return;
                }
                final String airVersion = FlexCommonUtils.getAirVersion((String)sdk.getHomePath(), (String)sdk.getVersionString());
                if (airVersion == null) {
                    exceptionRef.set((Object)new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.get.air.sdk.version.use.custom.descriptor", (Object[])new Object[0])));
                    return;
                }
                final String appId = FlexCommonUtils.fixApplicationId((String)bc.getMainClass());
                final String appName = StringUtil.getShortName((String)bc.getMainClass());
                final String swfName = PathUtil.getFileName((String)outputFilePath);
                final String[] extensions = FlexCompilationUtils.getAirExtensionIDs((ModuleRootModel)ModuleRootManager.getInstance((Module)module), bc.getDependencies());
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AirDescriptorOptions descriptorOptions = new AirDescriptorOptions(airVersion, appId, appName, swfName, extensions, android, ios);
                            String descriptorText = descriptorOptions.getAirDescriptorText();
                            FlexUtils.addFileWithContent(descriptorFileName, descriptorText, outputFolder);
                        }
                        catch (IOException e) {
                            exceptionRef.set((Object)new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.generate.air.descriptor", (Object[])new Object[]{e.getMessage()})));
                        }
                    }
                });
            }
        };
        ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.any());
        if (!exceptionRef.isNull()) {
            throw (FlexCompilerException)exceptionRef.get();
        }
    }

    public static Collection<VirtualFile> getANEFiles(ModuleRootModel moduleRootModel, Dependencies dependencies) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (DependencyEntry entry : dependencies.getEntries()) {
            Library library;
            if (entry instanceof ModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, moduleRootModel);
                if (orderEntry == null) continue;
                for (VirtualFile libFile : orderEntry.getRootFiles(OrderRootType.CLASSES)) {
                    FlexCompilationUtils.addIfANE(result, libFile);
                }
                continue;
            }
            if (!(entry instanceof SharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(moduleRootModel.getModule().getProject(), (SharedLibraryEntry)entry)) == null) continue;
            for (VirtualFile libFile : library.getFiles(OrderRootType.CLASSES)) {
                FlexCompilationUtils.addIfANE(result, libFile);
            }
        }
        return result;
    }

    private static void addIfANE(Collection<VirtualFile> result, VirtualFile libFile) {
        VirtualFile realFile = FlexCompilerHandler.getRealFile(libFile);
        if (realFile != null && !realFile.isDirectory() && "ane".equalsIgnoreCase(realFile.getExtension())) {
            result.add(realFile);
        }
    }

    public static String[] getAirExtensionIDs(ModuleRootModel moduleRootModel, Dependencies dependencies) {
        Collection<VirtualFile> aneFiles = FlexCompilationUtils.getANEFiles(moduleRootModel, dependencies);
        ArrayList extensionIDs = new ArrayList();
        for (VirtualFile aneFile : aneFiles) {
            String extensionId = FlexCompilationUtils.getExtensionId(aneFile);
            ContainerUtil.addIfNotNull(extensionIDs, (Object)extensionId);
        }
        return extensionIDs.toArray(new String[extensionIDs.size()]);
    }

    @Nullable
    private static String getExtensionId(VirtualFile aneFile) {
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(aneFile);
        if (jarRoot == null) {
            return null;
        }
        VirtualFile xmlFile = VfsUtil.findRelativeFile((String)"META-INF/ANE/extension.xml", (VirtualFile)jarRoot);
        if (xmlFile == null) {
            return null;
        }
        try {
            return FlexUtils.findXMLElement(xmlFile.getInputStream(), "<extension><id>");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void unzipANEFiles(Collection<VirtualFile> aneFiles, ProgressIndicator indicator) {
        File baseDir = new File(FlexCompilationUtils.getPathToUnzipANE());
        if (!baseDir.exists() && !baseDir.mkdir()) {
            Logger.getLogger(FlexCompilationUtils.class.getName()).warning("Failed to create " + baseDir.getPath());
            return;
        }
        for (VirtualFile file : aneFiles) {
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            File subDir = new File(baseDir, file.getName());
            if (!subDir.exists() && !subDir.mkdir()) {
                Logger.getLogger(FlexCompilationUtils.class.getName()).warning("Failed to create " + baseDir.getPath());
                continue;
            }
            try {
                ZipUtil.extract((File)new File(file.getPath()), (File)subDir, null, (boolean)true);
            }
            catch (IOException e) {
                Logger.getLogger(FlexCompilationUtils.class.getName()).warning("Failed to unzip " + file.getPath() + " to " + baseDir.getPath());
            }
        }
    }

    public static void deleteUnzippedANEFiles() {
        FileUtil.delete((File)new File(FlexCompilationUtils.getPathToUnzipANE()));
    }

    public static String getPathToUnzipANE() {
        return FileUtil.getTempDirectory() + File.separator + "IntelliJ_ANE_unzipped";
    }

    private static void copyAndFixCustomAirDescriptor(final FlexBuildConfiguration bc, final AirPackagingOptions packagingOptions) throws FlexCompilerException {
        String customDescriptorPath = packagingOptions.getCustomDescriptorPath();
        final VirtualFile descriptorTemplateFile = LocalFileSystem.getInstance().findFileByPath(customDescriptorPath);
        if (descriptorTemplateFile == null) {
            throw new FlexCompilerException(FlexCommonBundle.message((String)"air.descriptor.not.found", (Object[])new Object[]{customDescriptorPath}));
        }
        final String outputFilePath = bc.getActualOutputFilePath();
        String outputFolderPath = PathUtil.getParentPath((String)outputFilePath);
        final VirtualFile outputFolder = LocalFileSystem.getInstance().findFileByPath(outputFolderPath);
        if (outputFolder == null) {
            throw new FlexCompilerException(FlexCommonBundle.message((String)"output.folder.does.not.exist", (Object[])new Object[]{outputFolderPath}));
        }
        final Ref exceptionRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String content = FlexCompilationUtils.fixInitialContent(descriptorTemplateFile, PathUtil.getFileName((String)outputFilePath));
                            String descriptorFileName = bc.isTempBCForCompilation() ? BCUtils.getGeneratedAirDescriptorName(bc, packagingOptions) : descriptorTemplateFile.getName();
                            FlexUtils.addFileWithContent(descriptorFileName, content, outputFolder);
                        }
                        catch (FlexCompilerException e) {
                            exceptionRef.set((Object)e);
                        }
                        catch (IOException e) {
                            exceptionRef.set((Object)new FlexCompilerException(FlexCommonBundle.message((String)"failed.to.copy.air.descriptor", (Object[])new Object[]{e.getMessage()})));
                        }
                    }
                });
            }
        }, ModalityState.any());
        if (!exceptionRef.isNull()) {
            throw (FlexCompilerException)exceptionRef.get();
        }
    }

    private static String fixInitialContent(VirtualFile descriptorFile, String swfName) throws FlexCompilerException {
        try {
            Element contentElement;
            Document document;
            try {
                document = JDOMUtil.loadDocument((InputStream)descriptorFile.getInputStream());
            }
            catch (IOException e) {
                throw new FlexCompilerException("Failed to read AIR descriptor content: " + e.getMessage(), descriptorFile.getUrl(), -1, -1);
            }
            Element rootElement = document.getRootElement();
            if (!"application".equals(rootElement.getName())) {
                throw new FlexCompilerException("AIR descriptor file has incorrect root tag", descriptorFile.getUrl(), -1, -1);
            }
            Element initialWindowElement = rootElement.getChild("initialWindow", rootElement.getNamespace());
            if (initialWindowElement == null) {
                initialWindowElement = new Element("initialWindow", rootElement.getNamespace());
                rootElement.addContent(initialWindowElement);
            }
            if ((contentElement = initialWindowElement.getChild("content", rootElement.getNamespace())) == null) {
                contentElement = new Element("content", rootElement.getNamespace());
                initialWindowElement.addContent(contentElement);
            }
            contentElement.setText(swfName);
            return JDOMUtil.writeDocument((Document)document, (String)SystemProperties.getLineSeparator());
        }
        catch (JDOMException e) {
            throw new FlexCompilerException("AIR descriptor file has incorrect format: " + e.getMessage(), descriptorFile.getUrl(), -1, -1);
        }
    }
}

