/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.lang.javascript.flex.actions.airpackage.DeviceInfo;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.DumpSourceLocationCommand;
import com.intellij.lang.javascript.flex.debug.FilterSwfLoadUnloadMessagesAction;
import com.intellij.lang.javascript.flex.debug.FlexBreakpointsHandler;
import com.intellij.lang.javascript.flex.debug.FlexDebuggerEditorsProvider;
import com.intellij.lang.javascript.flex.debug.FlexSmartStepIntoHandler;
import com.intellij.lang.javascript.flex.debug.FlexStackFrame;
import com.intellij.lang.javascript.flex.debug.FlexSuspendContext;
import com.intellij.lang.javascript.flex.debug.FlexValue;
import com.intellij.lang.javascript.flex.debug.KnownFilesInfo;
import com.intellij.lang.javascript.flex.debug.LibrarySourcesSearchScope;
import com.intellij.lang.javascript.flex.debug.ResponseLineIterator;
import com.intellij.lang.javascript.flex.debug.VMState;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitConnection;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.flexunit.ServerConnectionBase;
import com.intellij.lang.javascript.flex.flexunit.SwfPolicyFileConnection;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.run.BCBasedRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunnerParameters;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class FlexDebugProcess
extends XDebugProcess {
    private static final String TRACE_MARKER = "[trace] ";
    public static final String DEBUGGER_GROUP_ID = "Debugger";
    private static final String SRC_PATH_ELEMENT = "/src/";
    private boolean debugSessionInitialized;
    private final Process fdbProcess;
    private Process adlProcess;
    private final MyFdbOutputReader reader;
    private Alarm myOutputAlarm;
    private final Module myModule;
    private final FlexBuildConfiguration myBC;
    private final BCBasedRunnerParameters myRunnerParameters;
    private final String myAppSdkHome;
    private final String myDebuggerSdkHome;
    private final String myDebuggerVersion;
    @NonNls
    static final String RESOLVED_BREAKPOINT_MARKER = "Resolved breakpoint ";
    @NonNls
    static final String BREAKPOINT_MARKER = "Breakpoint ";
    @NonNls
    private static final String FDB_MARKER = "(fdb) ";
    @NonNls
    private static final String WAITING_PLAYER_MARKER_1 = "Waiting for Player to connect";
    @NonNls
    private static final String WAITING_PLAYER_MARKER_2 = "Trying to connect to Player";
    @NonNls
    static final String ATTEMPTING_TO_RESOLVE_BREAKPOINT_MARKER = "Attempting to resolve breakpoint ";
    @NonNls
    private static final String ADL_PREFIX = "[AIR Debug Launcher]: ";
    private boolean myCheckForUnexpectedStartupStop;
    private Thread myDebuggerManagerThread;
    @NonNls
    static final String AMBIGUOUS_MATCHING_FILE_NAMES = "Ambiguous matching file names:";
    private final FlexBreakpointsHandler myBreakpointsHandler;
    @NonNls
    private static final String FAULT_MARKER = "[Fault] ";
    private static final Logger LOG = Logger.getInstance((String)FlexDebugProcess.class.getName());
    private static final boolean doSimpleTracing = ((ApplicationEx)ApplicationManager.getApplication()).isInternal();
    private Object myStackFrameEqualityObject;
    private Map<String, String> myQName2IdMap;
    private int myCurrentWorker = 0;
    private final KnownFilesInfo myKnownFilesInfo = new KnownFilesInfo(this);
    private String myFdbLaunchCommand;
    private final LinkedList<DebuggerCommand> commandsToWrite = new LinkedList<DebuggerCommand>(){

        @Override
        public synchronized DebuggerCommand removeFirst() {
            this.waitForData();
            return (DebuggerCommand)super.removeFirst();
        }

        @Override
        public synchronized void addFirst(DebuggerCommand debuggerCommand) {
            super.addFirst(debuggerCommand);
            this.notify();
        }

        @Override
        public synchronized void addLast(DebuggerCommand debuggerCommand) {
            super.addLast(debuggerCommand);
            this.notify();
        }

        private void waitForData() {
            try {
                while (this.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    private boolean suspended;
    private boolean fdbWaitingForPlayerStateReached;
    private boolean startupDone;
    private ConsoleView myConsoleView;
    private FlexUnitConnection myFlexUnitConnection;
    private SwfPolicyFileConnection myPolicyFileConnection;
    private static final Set<String> ourAlreadyMadeExecutable = new THashSet();

    public FlexDebugProcess(XDebugSession session, FlexBuildConfiguration bc, BCBasedRunnerParameters params) throws IOException {
        super(session);
        this.myModule = ModuleManager.getInstance((Project)session.getProject()).findModuleByName(params.getModuleName());
        this.myBC = bc;
        this.myRunnerParameters = params;
        LOG.assertTrue(this.myModule != null);
        Sdk sdk = bc.getSdk();
        LOG.assertTrue(sdk != null);
        this.myAppSdkHome = FileUtil.toSystemIndependentName((String)sdk.getHomePath());
        Sdk sdkForDebugger = params instanceof FlashRunnerParameters && bc.getTargetPlatform() == TargetPlatform.Web ? FlexDebugProcess.getDebuggerSdk(((FlashRunnerParameters)params).getDebuggerSdkRaw(), sdk) : sdk;
        this.myDebuggerSdkHome = FileUtil.toSystemIndependentName((String)sdkForDebugger.getHomePath());
        this.myDebuggerVersion = sdkForDebugger.getVersionString();
        this.myBreakpointsHandler = new FlexBreakpointsHandler(this);
        List<String> fdbLaunchCommand = FlexSdkUtils.getCommandLineForSdkTool(session.getProject(), sdkForDebugger, this.getFdbClasspath(), "flex.tools.debugger.cli.DebugCLI", null);
        if (this.isFlexSdk_4_12plus_IdeMode()) {
            fdbLaunchCommand.add("-ide");
        }
        if (params instanceof FlashRunnerParameters && bc.getTargetPlatform() == TargetPlatform.Mobile && (((FlashRunnerParameters)params).getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.AndroidDevice || ((FlashRunnerParameters)params).getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.iOSDevice) && ((FlashRunnerParameters)params).getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB) {
            fdbLaunchCommand.add("-p");
            fdbLaunchCommand.add(String.valueOf(((FlashRunnerParameters)params).getUsbDebugPort()));
        }
        if (params instanceof RemoteFlashRunnerParameters && (((RemoteFlashRunnerParameters)params).getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.AndroidDevice || ((RemoteFlashRunnerParameters)params).getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.iOSDevice) && ((RemoteFlashRunnerParameters)params).getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB) {
            fdbLaunchCommand.add("-p");
            fdbLaunchCommand.add(String.valueOf(((RemoteFlashRunnerParameters)params).getUsbDebugPort()));
        }
        this.fdbProcess = this.launchFdb(fdbLaunchCommand);
        if (params instanceof FlashRunnerParameters) {
            FlashRunnerParameters appParams = (FlashRunnerParameters)params;
            block0 : switch (bc.getTargetPlatform()) {
                case Web: {
                    String urlOrPath = appParams.isLaunchUrl() ? appParams.getUrl() : (bc.isUseHtmlWrapper() ? PathUtil.getParentPath((String)bc.getActualOutputFilePath()) + "/" + BCUtils.getWrapperFileName(bc) : bc.getActualOutputFilePath());
                    this.sendCommand(new LaunchBrowserCommand(urlOrPath, appParams.getLauncherParameters()));
                    break;
                }
                case Desktop: {
                    this.sendAdlStartingCommand(bc, appParams);
                    break;
                }
                case Mobile: {
                    switch (appParams.getMobileRunTarget()) {
                        case Emulator: {
                            this.sendAdlStartingCommand(bc, appParams);
                            break block0;
                        }
                        case AndroidDevice: {
                            String androidAppId = FlexBaseRunner.getApplicationId(FlexBaseRunner.getAirDescriptorPath(bc, bc.getAndroidPackagingOptions()));
                            this.sendCommand(new StartAppOnAndroidDeviceCommand(bc.getSdk(), appParams.getDeviceInfo(), androidAppId));
                            break block0;
                        }
                        case iOSSimulator: {
                            String iosSimulatorAppId = FlexBaseRunner.getApplicationId(FlexBaseRunner.getAirDescriptorPath(bc, bc.getIosPackagingOptions()));
                            this.sendCommand(new StartAppOnIosSimulatorCommand(bc.getSdk(), iosSimulatorAppId, ((FlashRunnerParameters)params).getIOSSimulatorSdkPath()));
                            break block0;
                        }
                        case iOSDevice: {
                            String iosAppName = FlexBaseRunner.getApplicationName(FlexBaseRunner.getAirDescriptorPath(bc, bc.getIosPackagingOptions()));
                            this.sendCommand(new StartAppOnIosDeviceCommand(iosAppName));
                        }
                    }
                }
            }
        } else if (params instanceof FlexUnitRunnerParameters) {
            FlexUnitRunnerParameters flexUnitParams = (FlexUnitRunnerParameters)params;
            this.openFlexUnitConnections(flexUnitParams.getSocketPolicyPort(), flexUnitParams.getPort());
            if (bc.getTargetPlatform() == TargetPlatform.Web) {
                this.sendCommand(new LaunchBrowserCommand(bc.getActualOutputFilePath(), flexUnitParams.getLauncherParameters()));
            } else {
                this.sendAdlStartingCommand(bc, params);
            }
        } else {
            this.sendCommand(new StartDebuggingCommand());
        }
        this.reader = new MyFdbOutputReader(this.fdbProcess.getInputStream());
        this.startCommandProcessingThread();
    }

    @Nullable
    public Module getModule() {
        return this.myModule.isDisposed() ? null : this.myModule;
    }

    public FlexBuildConfiguration getBC() {
        return this.myBC;
    }

    public boolean isFlexUnit() {
        return this.myRunnerParameters instanceof FlexUnitRunnerParameters;
    }

    public String getAppSdkHome() {
        return this.myAppSdkHome;
    }

    public static Sdk getDebuggerSdk(String sdkRaw, Sdk bcSdk) {
        if (sdkRaw.equals("BC SDK")) {
            return bcSdk;
        }
        Sdk sdk = FlexSdkUtils.findFlexOrFlexmojosSdk(sdkRaw);
        LOG.assertTrue(sdk != null);
        return sdk;
    }

    private String getFdbClasspath() {
        String legacyFdbPath = this.myDebuggerSdkHome + "/lib/legacy/fdb.jar";
        if (new File(legacyFdbPath).isFile()) {
            return legacyFdbPath;
        }
        String classpath = this.myDebuggerSdkHome + "/lib/fdb.jar";
        if (this.isDebuggerFromSdk3()) {
            classpath = FlexCommonUtils.getPathToBundledJar((String)"idea-fdb-3-fix.jar") + File.pathSeparator + classpath;
        } else if (!this.myDebuggerVersion.startsWith("AIR SDK ")) {
            if (StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.0") >= 0 && StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.1.1") < 0) {
                classpath = FlexCommonUtils.getPathToBundledJar((String)"idea-fdb-4.0.0.14159-fix.jar") + File.pathSeparator + classpath;
            } else if (this.myDebuggerVersion.startsWith("4.6.b") || StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.5") >= 0 && StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.6.1") < 0 || StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.8") >= 0 && StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.12") < 0) {
                classpath = FlexCommonUtils.getPathToBundledJar((String)"idea-fdb-4.5.0.20967-fix.jar") + File.pathSeparator + classpath;
            }
        }
        return classpath;
    }

    private void openFlexUnitConnections(int socketPolicyPort, int port) {
        try {
            this.myPolicyFileConnection = new SwfPolicyFileConnection();
            this.myPolicyFileConnection.open(socketPolicyPort);
            this.myFlexUnitConnection = new FlexUnitConnection();
            this.myFlexUnitConnection.addListener(new FlexUnitConnection.Listener(){

                @Override
                public void statusChanged(ServerConnectionBase.ConnectionStatus status) {
                    if (status == ServerConnectionBase.ConnectionStatus.CONNECTION_FAILED) {
                        FlexDebugProcess.this.getSession().stop();
                    }
                }

                @Override
                public void onData(String line) {
                    FlexDebugProcess.this.getProcessHandler().notifyTextAvailable(line + "\n", ProcessOutputTypes.STDOUT);
                }

                @Override
                public void onFinish() {
                    FlexDebugProcess.this.getProcessHandler().detachProcess();
                }
            });
            this.myFlexUnitConnection.open(port);
        }
        catch (ExecutionException e) {
            Notifications.Bus.notify((Notification)new Notification(DEBUGGER_GROUP_ID, FlexBundle.message("flex.debugger.startup.error", new Object[0]), FlexBundle.message("flexunit.startup.error", e.getMessage()), NotificationType.ERROR), (Project)this.getSession().getProject());
            this.myFlexUnitConnection = null;
            this.myPolicyFileConnection = null;
        }
    }

    private Process launchFdb(List<String> fdbLaunchCommand) throws IOException {
        FlexDebugProcess.ensureExecutable(fdbLaunchCommand.get(0));
        this.myFdbLaunchCommand = StringUtil.join(fdbLaunchCommand, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.indexOf(32) >= 0 && (!s.startsWith("\"") || !s.endsWith("\"")) ? '\"' + s + '\"' : s;
            }
        }, (String)" ");
        Process process = Runtime.getRuntime().exec(ArrayUtil.toStringArray(fdbLaunchCommand));
        this.sendCommand(new ReadGreetingCommand());
        return process;
    }

    private void startCommandProcessingThread() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                FlexDebugProcess.this.myDebuggerManagerThread = Thread.currentThread();
                FlexDebugProcess flexDebugProcess = FlexDebugProcess.this;
                synchronized (flexDebugProcess) {
                    if (!FlexDebugProcess.this.debugSessionInitialized) {
                        try {
                            ((Object)((Object)FlexDebugProcess.this)).wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    while (true) {
                        FlexDebugProcess.this.processOneCommandLoop();
                    }
                }
                catch (IOException ex2) {
                    FlexDebugProcess.this.myConsoleView.print(ex2.toString(), ConsoleViewContentType.ERROR_OUTPUT);
                    FlexDebugProcess.this.getProcessHandler().detachProcess();
                    FlexDebugProcess.this.fdbProcess.destroy();
                    LOG.warn((Throwable)ex2);
                    try {
                        FlexDebugProcess.this.fdbProcess.getInputStream().close();
                        return;
                    }
                    catch (IOException ex2) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    try {
                        FlexDebugProcess.this.fdbProcess.getInputStream().close();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                catch (RuntimeException ex) {
                    Throwable throwable = ex.getCause();
                    if (!(throwable instanceof InterruptedException)) throw ex;
                    return;
                }
            }
        });
    }

    private void sendAdlStartingCommand(FlexBuildConfiguration bc, BCBasedRunnerParameters params) throws IOException {
        try {
            VirtualFile airRuntimeDirForFlexmojosSdk;
            boolean needToRemoveAirRuntimeDir;
            Sdk sdk = bc.getSdk();
            LOG.assertTrue(sdk != null);
            if (sdk.getSdkType() instanceof FlexmojosSdkType) {
                Pair<VirtualFile, Boolean> airRuntimeDirInfo = FlexSdkUtils.getAirRuntimeDirInfoForFlexmojosSdk(sdk);
                needToRemoveAirRuntimeDir = (Boolean)airRuntimeDirInfo.second;
                airRuntimeDirForFlexmojosSdk = (VirtualFile)airRuntimeDirInfo.first;
            } else {
                needToRemoveAirRuntimeDir = false;
                airRuntimeDirForFlexmojosSdk = null;
            }
            String airRuntimePath = airRuntimeDirForFlexmojosSdk == null ? null : airRuntimeDirForFlexmojosSdk.getPath();
            this.sendCommand(new StartAirAppDebuggingCommand(FlexBaseRunner.createAdlCommandLine(this.getSession().getProject(), params, bc, airRuntimePath), (VirtualFile)(needToRemoveAirRuntimeDir ? airRuntimeDirForFlexmojosSdk : null)));
        }
        catch (CantRunException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getCurrentStateMessage() {
        return this.getSession().isStopped() ? XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]) : (this.startupDone ? XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]) : (this.fdbWaitingForPlayerStateReached ? FlexBundle.message("debugger.waiting.player", new Object[0]) : FlexBundle.message("initializing.flex.debugger", new Object[0])));
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        FlexDebuggerEditorsProvider flexDebuggerEditorsProvider = new FlexDebuggerEditorsProvider();
        if (flexDebuggerEditorsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "getEditorsProvider"));
        }
        return flexDebuggerEditorsProvider;
    }

    private static synchronized void ensureExecutable(String path) {
        if (!SystemInfo.isWindows && !ourAlreadyMadeExecutable.contains(path)) {
            try {
                ourAlreadyMadeExecutable.add(path);
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", path});
            }
            catch (IOException ex) {
                FlexDebugProcess.log(ex);
            }
        }
    }

    private void processOneCommandLoop() throws IOException, InterruptedException {
        assert (Thread.currentThread() == this.myDebuggerManagerThread);
        DebuggerCommand command = this.postCommand();
        if (command == null) {
            return;
        }
        boolean explicitlyContinueRead = false;
        do {
            String commandOutput;
            CommandOutputProcessingType outputProcessingType;
            block31: {
                if ((outputProcessingType = command.getOutputProcessingMode()) == CommandOutputProcessingType.NO_PROCESSING || outputProcessingType == CommandOutputProcessingType.DEFAULT_PROCESSING && !this.reader.hasSomeDataPending()) {
                    return;
                }
                if (this.myCheckForUnexpectedStartupStop && !(command instanceof DumpOutputCommand)) {
                    this.myCheckForUnexpectedStartupStop = false;
                }
                commandOutput = null;
                try {
                    commandOutput = command.read(this);
                }
                catch (IOException e) {
                    if (command instanceof QuitCommand) break block31;
                    throw e;
                }
            }
            if (command instanceof QuitCommand) {
                Thread.currentThread().interrupt();
            }
            if (commandOutput == null) break;
            if (commandOutput.contains("Player session terminated")) {
                this.handleProbablyUnexpectedStop(commandOutput);
                break;
            }
            commandOutput = commandOutput.trim();
            FlexDebugProcess.log(commandOutput);
            if (outputProcessingType == CommandOutputProcessingType.SPECIAL_PROCESSING) {
                FlexDebugProcess.log("Processed by " + command);
                if (command.onTextAvailable(commandOutput) == CommandOutputProcessingMode.DONE) break;
                explicitlyContinueRead = true;
                continue;
            }
            ResponseLineIterator iterator = new ResponseLineIterator(commandOutput);
            boolean toInsertContinue = false;
            boolean encounteredNonsuspendableBreakpoint = false;
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (line.startsWith("Active worker has changed to worker ")) {
                    try {
                        String workerText = line.substring("Active worker has changed to worker ".length());
                        if ("Main Thread".equals(workerText)) {
                            this.myCurrentWorker = 0;
                            continue;
                        }
                        this.myCurrentWorker = Integer.parseInt(workerText);
                    }
                    catch (NumberFormatException e) {
                        FlexDebugProcess.log("Unexpected worker number");
                    }
                    continue;
                }
                if (line.contains("Additional ActionScript code has been loaded")) {
                    if (!this.suspended) {
                        this.reader.readLine(false);
                    }
                    this.myKnownFilesInfo.setUpToDate(false);
                    continue;
                }
                int index = line.indexOf(BREAKPOINT_MARKER);
                if (index != -1 && !line.contains(" created")) {
                    try {
                        XLineBreakpoint<XBreakpointProperties> breakpoint;
                        int from = index + BREAKPOINT_MARKER.length();
                        int endOfBreakpointIndexPosition = line.indexOf(44, from);
                        int colonIndex = line.indexOf(58, from);
                        int spaceIndex = line.indexOf(32, from);
                        if (endOfBreakpointIndexPosition == -1) continue;
                        if (colonIndex != -1) {
                            endOfBreakpointIndexPosition = Math.min(colonIndex, endOfBreakpointIndexPosition);
                        }
                        if (spaceIndex != -1) {
                            endOfBreakpointIndexPosition = Math.min(spaceIndex, endOfBreakpointIndexPosition);
                        }
                        if ((breakpoint = this.myBreakpointsHandler.getBreakpointByIndex(index = Integer.parseInt(line.substring(from, endOfBreakpointIndexPosition)))) != null) {
                            FlexStackFrame frame = new FlexStackFrame(this, breakpoint.getSourcePosition());
                            boolean suspend = false;
                            if (this.evaluateCondition(breakpoint.getConditionExpression(), frame)) {
                                String message = this.evaluateMessage(breakpoint.getLogExpressionObject(), frame);
                                suspend = this.getSession().breakpointReached(breakpoint, message, (XSuspendContext)new FlexSuspendContext(frame));
                            }
                            if (suspend) continue;
                            encounteredNonsuspendableBreakpoint = true;
                            toInsertContinue = true;
                            continue;
                        }
                        FlexBreakpointsHandler flexBreakpointsHandler = this.myBreakpointsHandler;
                        flexBreakpointsHandler.getClass();
                        this.insertCommand(new FlexBreakpointsHandler.RemoveBreakpointCommand(flexBreakpointsHandler, index, breakpoint));
                    }
                    catch (NumberFormatException ex) {
                        FlexDebugProcess.log(ex);
                    }
                    continue;
                }
                if (line.length() > 0 && Character.isDigit(line.charAt(0))) {
                    if (encounteredNonsuspendableBreakpoint) continue;
                    this.insertCommand(new DumpSourceLocationCommand(this));
                    continue;
                }
                if (this.handleStdResponse(line, iterator)) continue;
                if (line.startsWith(RESOLVED_BREAKPOINT_MARKER)) {
                    String breakPointNumber = line.substring(RESOLVED_BREAKPOINT_MARKER.length(), line.indexOf(32, RESOLVED_BREAKPOINT_MARKER.length()));
                    this.myBreakpointsHandler.updateBreakpointStatusToVerified(breakPointNumber);
                    continue;
                }
                if (line.startsWith(ATTEMPTING_TO_RESOLVE_BREAKPOINT_MARKER)) {
                    int breakpointId = Integer.parseInt(line.substring(ATTEMPTING_TO_RESOLVE_BREAKPOINT_MARKER.length(), line.indexOf(44)));
                    XLineBreakpoint<XBreakpointProperties> breakpoint = this.myBreakpointsHandler.getBreakpointByIndex(breakpointId);
                    if (iterator.hasNext() && iterator.getNext().contains("no executable code")) {
                        iterator.next();
                        this.myBreakpointsHandler.updateBreakpointStatusToInvalid(breakpoint);
                        toInsertContinue = true;
                        continue;
                    }
                    if (!iterator.hasNext() || !iterator.getNext().contains(AMBIGUOUS_MATCHING_FILE_NAMES)) continue;
                    iterator.next();
                    iterator.next();
                    while (iterator.hasNext() && iterator.getNext().contains("#")) {
                        iterator.next();
                    }
                    if (this.getFileId(breakpoint.getSourcePosition().getFile().getPath()) != null) {
                        XBreakpointHandler<?> handler = this.getBreakpointHandlers()[0];
                        handler.unregisterBreakpoint(breakpoint, false);
                        handler.registerBreakpoint(breakpoint);
                    }
                    toInsertContinue = true;
                    continue;
                }
                if (line.startsWith("Set additional breakpoints")) {
                    toInsertContinue = true;
                    continue;
                }
                if (!line.contains("Execution halted") || this.getSession().isPaused()) continue;
                this.getSession().pause();
            }
            if (!toInsertContinue) continue;
            this.insertCommand(new ContinueCommand());
        } while (explicitlyContinueRead || this.reader.hasSomeDataPending());
    }

    private boolean evaluateCondition(@Nullable XExpression expression, FlexStackFrame frame) {
        if (expression == null || StringUtil.isEmptyOrSpaces((String)expression.getExpression())) {
            return true;
        }
        String result = frame.eval(expression.getExpression(), this);
        if (result != null && (result.equalsIgnoreCase("true") || result.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(result);
        }
        final String message = result == null || result.startsWith("Cannot evaluate expression: ") ? FlexBundle.message("failed.to.evaluate.breakpoint.condition", expression) : FlexBundle.message("not.boolean.breakpoint.condition", expression, result);
        final Ref stopRef = new Ref((Object)false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Project project = FlexDebugProcess.this.getSession().getProject();
                int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)FlexBundle.message("breakpoint.condition.error", new Object[0]), (Icon)Messages.getQuestionIcon());
                stopRef.set((Object)(answer == 0 ? 1 : 0));
            }
        }, ModalityState.defaultModalityState());
        return (Boolean)stopRef.get();
    }

    @Nullable
    private String evaluateMessage(@Nullable XExpression expression, FlexStackFrame frame) {
        if (expression == null || StringUtil.isEmptyOrSpaces((String)expression.getExpression())) {
            return null;
        }
        return frame.eval(expression.getExpression(), this);
    }

    String defaultReadCommand(DebuggerCommand command) throws IOException {
        return this.reader.readLine(command.getEndVMState() == VMState.RUNNING);
    }

    private boolean handleStdResponse(String line, ResponseLineIterator iterator) {
        if (line.startsWith(TRACE_MARKER)) {
            this.myConsoleView.print(line + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            return true;
        }
        if (line.startsWith(FAULT_MARKER)) {
            this.myConsoleView.print(line + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            while (iterator.hasNext() && iterator.getNext().startsWith("at ")) {
                this.myConsoleView.print(iterator.next() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            return true;
        }
        if (line.startsWith("[SWF]") || line.startsWith("[UnloadSWF]")) {
            if (!FilterSwfLoadUnloadMessagesAction.isFilterEnabled(this.getSession().getProject())) {
                this.myConsoleView.print(line + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            return true;
        }
        return false;
    }

    protected String resolveFileReference(VirtualFile file) {
        String marker;
        String id = this.myKnownFilesInfo.getIdByFilePathNoUpdate(file.getPath());
        if (id != null) {
            marker = "#" + id;
        } else {
            marker = file.getName();
            String expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)file, (Project)this.getSession().getProject());
            if (!StringUtil.isEmpty((String)expectedPackageNameFromFile)) {
                marker = expectedPackageNameFromFile + "." + marker;
            }
        }
        return marker;
    }

    protected String getFileId(String filePath) {
        return this.myKnownFilesInfo.getIdByFilePath(filePath);
    }

    @Nullable
    VirtualFile findFileByNameOrId(@NotNull String fileName, @Nullable String packageName, @Nullable String id) {
        String path;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "findFileByNameOrId"));
        }
        if (id != null && (path = this.myKnownFilesInfo.getFilePathById(this.myCurrentWorker, id)) != null) {
            VirtualFile fileById = LocalFileFinder.findFile((String)path);
            if (packageName == null) {
                String mavenStyleSrc = "/src/main/flex/";
                int srcIndex = path.indexOf("/src/main/flex/");
                if (srcIndex > 0) {
                    packageName = StringUtil.getPackageName((String)path.substring(srcIndex + "/src/main/flex/".length()), (char)'/').replace('/', '.');
                } else {
                    srcIndex = path.indexOf(SRC_PATH_ELEMENT);
                    if (srcIndex > 0) {
                        packageName = StringUtil.getPackageName((String)path.substring(srcIndex + SRC_PATH_ELEMENT.length()), (char)'/').replace('/', '.');
                    }
                }
            }
            if (fileById != null) {
                return this.getThisOrSimilarFileInProject(fileById, packageName);
            }
        }
        if ("<null>".equals(fileName)) {
            return null;
        }
        return packageName == null ? this.findFile(fileName) : this.findFile(fileName, packageName);
    }

    @Nullable
    private VirtualFile findFile(String fileName, @NotNull String packageName) {
        VirtualFile file;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "findFile"));
        }
        String packagePath = packageName.replace('.', '/');
        Collection<String> paths = this.myKnownFilesInfo.getPathsByName(this.myCurrentWorker, fileName);
        if (paths != null) {
            for (String path : paths) {
                String folderPath = PathUtil.getParentPath((String)path);
                if (!folderPath.endsWith(packagePath) || (file = LocalFileFinder.findFile((String)path)) == null) continue;
                return this.getThisOrSimilarFileInProject(file, packageName);
            }
        }
        ModuleWithDependenciesScope bcScopeBase = FlexUtils.getModuleWithDependenciesAndLibrariesScope(this.myModule, this.myBC, this.isFlexUnit());
        GlobalSearchScope bcScope = FlexDebugProcess.uniteWithLibrarySourcesOfBC((GlobalSearchScope)bcScopeBase, this.myModule, this.myBC, (Collection<FlexBuildConfiguration>)new THashSet());
        Collection<VirtualFile> files = FlexDebugProcess.getFilesByName(this.getSession().getProject(), bcScope, fileName);
        file = FlexDebugProcess.getFileMatchingPackageName(this.getSession().getProject(), files, packageName);
        if (file == null) {
            files = FlexDebugProcess.getFilesByName(this.getSession().getProject(), GlobalSearchScope.allScope((Project)this.getSession().getProject()), fileName);
            file = FlexDebugProcess.getFileMatchingPackageName(this.getSession().getProject(), files, packageName);
        }
        return file != null ? file : this.findFile(fileName);
    }

    @Nullable
    private VirtualFile findFile(String fileName) {
        ModuleWithDependenciesScope bcScope = FlexUtils.getModuleWithDependenciesAndLibrariesScope(this.myModule, this.myBC, this.isFlexUnit());
        Collection<VirtualFile> files = FlexDebugProcess.getFilesByName(this.getSession().getProject(), (GlobalSearchScope)bcScope, fileName);
        if (files.isEmpty()) {
            files = FlexDebugProcess.getFilesByName(this.getSession().getProject(), GlobalSearchScope.allScope((Project)this.getSession().getProject()), fileName);
        }
        if (!files.isEmpty()) {
            return files.iterator().next();
        }
        Collection<String> paths = this.myKnownFilesInfo.getPathsByName(this.myCurrentWorker, fileName);
        if (paths != null) {
            for (String path : paths) {
                VirtualFile file = LocalFileFinder.findFile((String)path);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    @NotNull
    private VirtualFile getThisOrSimilarFileInProject(@NotNull VirtualFile file, String packageName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "getThisOrSimilarFileInProject"));
        }
        Project project = this.getSession().getProject();
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        if (allScope.contains(file)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "getThisOrSimilarFileInProject"));
            }
            return virtualFile;
        }
        Collection<VirtualFile> files = FlexDebugProcess.getFilesByName(project, allScope, file.getName());
        if (packageName == null) {
            VirtualFile virtualFile = !files.isEmpty() ? files.iterator().next() : file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "getThisOrSimilarFileInProject"));
            }
            return virtualFile;
        }
        VirtualFile fileMatchingPackage = FlexDebugProcess.getFileMatchingPackageName(project, files, packageName);
        VirtualFile virtualFile = fileMatchingPackage != null ? fileMatchingPackage : file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "getThisOrSimilarFileInProject"));
        }
        return virtualFile;
    }

    private static Collection<VirtualFile> getFilesByName(final Project project, final GlobalSearchScope scope, final String fileName) {
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Collection<VirtualFile>>(){

            public Collection<VirtualFile> compute() {
                return FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
            }
        });
    }

    @Nullable
    private static VirtualFile getFileMatchingPackageName(Project project, Collection<VirtualFile> files, String packageName) {
        for (VirtualFile file : files) {
            VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file);
            String relPath = sourceRoot == null ? null : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
            String packagePath = relPath == null ? null : PathUtil.getParentPath((String)relPath).replace('/', '.');
            if (packagePath == null || !packagePath.equals(packageName)) continue;
            return file;
        }
        return null;
    }

    private static GlobalSearchScope uniteWithLibrarySourcesOfBC(GlobalSearchScope scope, Module module, FlexBuildConfiguration bc, Collection<FlexBuildConfiguration> processedConfigurations) {
        if (!processedConfigurations.add(bc)) {
            return scope;
        }
        THashSet libSourceRoots = new THashSet();
        Sdk sdk = bc.getSdk();
        if (sdk != null) {
            Collections.addAll(libSourceRoots, sdk.getRootProvider().getFiles(OrderRootType.SOURCES));
        }
        for (DependencyEntry entry : bc.getDependencies().getEntries()) {
            Library library;
            if (entry instanceof BuildConfigurationEntry) {
                Module otherModule = ((BuildConfigurationEntry)entry).findModule();
                FlexBuildConfiguration otherBC = ((BuildConfigurationEntry)entry).findBuildConfiguration();
                if (otherModule == null || otherBC == null) continue;
                scope = FlexDebugProcess.uniteWithLibrarySourcesOfBC(scope, otherModule, otherBC, processedConfigurations);
                continue;
            }
            if (entry instanceof ModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, (ModuleRootModel)ModuleRootManager.getInstance((Module)module));
                if (orderEntry == null) continue;
                Collections.addAll(libSourceRoots, orderEntry.getFiles(OrderRootType.SOURCES));
                continue;
            }
            if (!(entry instanceof SharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(module.getProject(), (SharedLibraryEntry)entry)) == null) continue;
            Collections.addAll(libSourceRoots, library.getFiles(OrderRootType.SOURCES));
        }
        return libSourceRoots.isEmpty() ? scope : scope.uniteWith((GlobalSearchScope)new LibrarySourcesSearchScope(module.getProject(), (Collection<VirtualFile>)libSourceRoots));
    }

    private void handleProbablyUnexpectedStop(String s) {
        if (!this.getSession().isStopped()) {
            FlexDebugProcess.log(s);
            if (this.myCheckForUnexpectedStartupStop) {
                this.myConsoleView.print(s + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            this.getProcessHandler().detachProcess();
        }
    }

    private DebuggerCommand postCommand() throws IOException {
        DebuggerCommand nextCommand;
        boolean currentlyExecuting;
        DebuggerCommand command = this.commandsToWrite.removeFirst();
        boolean bl = currentlyExecuting = !this.suspended && this.startupDone;
        if (command.getStartVMState() == VMState.RUNNING) {
            if (!currentlyExecuting) {
                if (command instanceof SuspendDebuggerCommand) {
                    ((SuspendDebuggerCommand)command).doCommandAfterSuspend();
                }
                if (command.getOutputProcessingMode() != CommandOutputProcessingType.DEFAULT_PROCESSING) {
                    return null;
                }
            }
            command.post(this);
            return command;
        }
        if (!currentlyExecuting && command.getEndVMState() == VMState.RUNNING && (nextCommand = this.commandsToWrite.peek()) != null && nextCommand.getStartVMState() == VMState.SUSPENDED) {
            command = this.commandsToWrite.removeFirst();
            if (nextCommand.getEndVMState() == VMState.SUSPENDED && !(nextCommand instanceof QuitCommand)) {
                this.insertCommand(new ContinueCommand());
            }
        }
        if (currentlyExecuting) {
            command = new SuspendResumeDebuggerCommand(command);
        }
        command.post(this);
        return command;
    }

    boolean isDebuggerFromSdk3() {
        return this.myDebuggerVersion != null && this.myDebuggerVersion.startsWith("3.");
    }

    boolean isFlexSdk_4_12plus_IdeMode() {
        return !this.myDebuggerVersion.startsWith("AIR SDK ") && StringUtil.compareVersionNumbers((String)this.myDebuggerVersion, (String)"4.12") > 0;
    }

    void doSendCommandText(DebuggerCommand command) throws IOException {
        String text = command.getText();
        this.setSuspended(command.getOutputProcessingMode() == CommandOutputProcessingType.NO_PROCESSING && command.getEndVMState() == VMState.SUSPENDED);
        FlexDebugProcess.log("Sent:" + text);
        this.fdbProcess.getOutputStream().write((text + "\n").getBytes());
        try {
            this.fdbProcess.getOutputStream().flush();
        }
        catch (IOException ex) {
            this.handleProbablyUnexpectedStop(FlexBundle.message("flex.debugger.unexpected.communication.error", new Object[0]));
        }
    }

    protected static void log(@NonNls String s) {
        s = System.currentTimeMillis() + " " + s;
        if (doSimpleTracing) {
            System.out.println(s);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(s);
        }
    }

    static void log(Throwable ex) {
        if (doSimpleTracing) {
            ex.printStackTrace();
        }
        LOG.error(ex);
    }

    public void startStepOver() {
        this.sendCommand(new DebuggerCommand("next"));
    }

    public void startStepInto() {
        this.sendCommand(new DebuggerCommand("step"));
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        XBreakpointHandler<?>[] xBreakpointHandlerArray = this.myBreakpointsHandler.getBreakpointHandlers();
        if (xBreakpointHandlerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "getBreakpointHandlers"));
        }
        return xBreakpointHandlerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionInitialized() {
        super.sessionInitialized();
        this.sendCommand(new ContinueCommand(){

            @Override
            public CommandOutputProcessingType getOutputProcessingMode() {
                FlexDebugProcess.this.myCheckForUnexpectedStartupStop = true;
                return super.getOutputProcessingMode();
            }
        });
        this.myConsoleView = (ConsoleView)this.getSession().getRunContentDescriptor().getExecutionConsole();
        if (this.myFdbLaunchCommand != null) {
            this.myConsoleView.print(this.myFdbLaunchCommand + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        this.myOutputAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)this.myConsoleView);
        this.scheduleOutputReading();
        this.scheduleFdbErrorStreamReading();
        this.getSession().setPauseActionSupported(true);
        FlexDebugProcess flexDebugProcess = this;
        synchronized (flexDebugProcess) {
            this.debugSessionInitialized = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    private void scheduleOutputReading() {
        if (this.myOutputAlarm.isDisposed()) {
            return;
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                try {
                    if (FlexDebugProcess.this.reader.hasSomeDataPending()) {
                        FlexDebugProcess.this.sendCommand(new DumpOutputCommand());
                    } else if (!FlexDebugProcess.this.myOutputAlarm.isDisposed()) {
                        FlexDebugProcess.this.myOutputAlarm.addRequest((Runnable)this, 100);
                    }
                }
                catch (IOException ex) {
                    FlexDebugProcess.this.myOutputAlarm.cancelAllRequests();
                }
            }
        };
        this.myOutputAlarm.addRequest(action, 0);
    }

    void addPendingCommand(final DebuggerCommand command, int delay) {
        this.myOutputAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                FlexDebugProcess.this.sendCommand(command);
            }
        }, delay);
    }

    private void scheduleFdbErrorStreamReading() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader myErrorStreamReader = new InputStreamReader(FlexDebugProcess.this.fdbProcess.getErrorStream());
                try {
                    int read;
                    char[] buf = new char[1024];
                    while ((read = myErrorStreamReader.read(buf, 0, buf.length)) >= 0) {
                        String message = new String(buf, 0, read);
                        LOG.debug("[fdb error stream]: " + message);
                        FlexDebugProcess.this.myConsoleView.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
                catch (IOException e) {
                    LOG.debug("fdb error stream reading error", (Throwable)e);
                }
                finally {
                    try {
                        myErrorStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public void startPausing() {
        this.sendCommand(new SuspendDebuggerCommand(new DumpSourceLocationCommand(this)));
    }

    public void startStepOut() {
        this.sendCommand(new DebuggerCommand("finish"));
    }

    public void stop() {
        if (this.myFlexUnitConnection != null) {
            this.myFlexUnitConnection.close();
        }
        if (this.myPolicyFileConnection != null) {
            this.myPolicyFileConnection.close();
        }
        this.sendCommand(new QuitCommand());
        if (this.adlProcess != null) {
            this.adlProcess.destroy();
        }
        if (!this.startupDone) {
            this.fdbProcess.destroy();
        }
    }

    private void reportProblem(final String s) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Notifications.Bus.notify((Notification)new Notification(FlexDebugProcess.DEBUGGER_GROUP_ID, FlexBundle.message("flex.debugger.startup.error", new Object[0]), s.replace("\n", "<br>"), NotificationType.ERROR), (Project)FlexDebugProcess.this.getSession().getProject());
            }
        });
    }

    void insertCommand(DebuggerCommand command) {
        this.commandsToWrite.addFirst(command);
    }

    void sendCommand(DebuggerCommand command) {
        this.commandsToWrite.addLast(command);
    }

    public void resume() {
        this.sendCommand(new ContinueCommand());
    }

    public void runToPosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "runToPosition"));
        }
        this.myBreakpointsHandler.handleRunToPosition(position, this);
    }

    public void sendAndProcessOneCommand(DebuggerCommand command, @Nullable Function<Exception, Void> onException) {
        this.insertCommand(command);
        try {
            this.processOneCommandLoop();
        }
        catch (Exception e) {
            FlexDebugProcess.log(e);
            if (onException != null) {
                onException.fun((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    private void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    boolean filterStdResponse(String line) {
        ResponseLineIterator iterator = new ResponseLineIterator(line);
        boolean stdcontent = true;
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (s.startsWith("$")) {
                stdcontent = false;
                break;
            }
            if (s.length() > 0 && Character.isDigit(s.charAt(0))) {
                this.sendCommand(new DumpSourceLocationCommand(this));
                continue;
            }
            if (this.handleStdResponse(line, iterator)) continue;
            stdcontent = false;
        }
        return stdcontent;
    }

    void setQName2Id(Map<String, String> qName2IdMap, Object equalityObject) {
        this.myStackFrameEqualityObject = equalityObject;
        this.myQName2IdMap = qName2IdMap;
    }

    @Nullable
    Map<String, String> getQName2IdIfSameEqualityObject(Object equalityObject) {
        if (equalityObject != null && equalityObject.equals(this.myStackFrameEqualityObject)) {
            return this.myQName2IdMap;
        }
        return null;
    }

    public XValueMarkerProvider<FlexValue, String> createValueMarkerProvider() {
        return new XValueMarkerProvider<FlexValue, String>(FlexValue.class){

            public boolean canMark(@NotNull FlexValue value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess$12", "canMark"));
                }
                return this.getObjectId(value) != null;
            }

            public String getMarker(@NotNull FlexValue value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess$12", "getMarker"));
                }
                return this.getObjectId(value);
            }

            private String getObjectId(FlexValue value) {
                int suffixIndex;
                String text = value.getResult();
                String prefix = "[Object ";
                String suffix = ", class='";
                if (text.startsWith("[Object ") && (suffixIndex = text.indexOf(", class='", "[Object ".length())) > 0) {
                    try {
                        return FlexStackFrame.validObjectId(text.substring("[Object ".length(), suffixIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
    }

    protected void notifyFdbWaitingForPlayerStateReached() {
        if (this.myRunnerParameters instanceof RemoteFlashRunnerParameters) {
            String message;
            RemoteFlashRunnerParameters.RemoteDebugTarget remoteDebugTarget = ((RemoteFlashRunnerParameters)this.myRunnerParameters).getRemoteDebugTarget();
            FlashRunnerParameters.AirMobileDebugTransport mobileDebugTransport = ((RemoteFlashRunnerParameters)this.myRunnerParameters).getDebugTransport();
            int usbDebugPort = ((RemoteFlashRunnerParameters)this.myRunnerParameters).getUsbDebugPort();
            if (remoteDebugTarget == RemoteFlashRunnerParameters.RemoteDebugTarget.Computer) {
                message = FlexBundle.message("remote.flash.debug.computer", FlexUtils.getOwnIpAddress());
            } else {
                String device = remoteDebugTarget == RemoteFlashRunnerParameters.RemoteDebugTarget.AndroidDevice ? "Android" : "iOS";
                message = mobileDebugTransport == FlashRunnerParameters.AirMobileDebugTransport.Network ? FlexBundle.message("remote.flash.debug.mobile.network", device, FlexUtils.getOwnIpAddress()) : FlexBundle.message("remote.flash.debug.mobile.usb", device, String.valueOf(usbDebugPort));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolWindowManager.getInstance((Project)FlexDebugProcess.this.getSession().getProject()).notifyByBalloon(ToolWindowId.DEBUG, MessageType.INFO, message);
                }
            });
        }
    }

    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return new FlexSmartStepIntoHandler(this);
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftToolbar", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "registerAdditionalActions"));
        }
        if (topToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topToolbar", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "registerAdditionalActions"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess", "registerAdditionalActions"));
        }
        topToolbar.addAction(ActionManager.getInstance().getAction("Flex.Debugger.FilterSwfLoadUnloadMessages"));
    }

    private class DumpOutputCommand
    extends DebuggerCommand {
        DumpOutputCommand() {
            super("dump", CommandOutputProcessingType.DEFAULT_PROCESSING, VMState.RUNNING, VMState.RUNNING);
        }

        @Override
        public void post(FlexDebugProcess flexDebugProcess) throws IOException {
            FlexDebugProcess.this.scheduleOutputReading();
        }
    }

    private class SuspendDebuggerCommand
    extends DebuggerCommand {
        protected final DebuggerCommand myCommand1;

        public SuspendDebuggerCommand(DebuggerCommand command1) {
            super("suspend", CommandOutputProcessingType.SPECIAL_PROCESSING, VMState.RUNNING, VMState.SUSPENDED);
            this.myCommand1 = command1;
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
            FlexDebugProcess.this.insertCommand(new DebuggerCommand("y", CommandOutputProcessingType.SPECIAL_PROCESSING){

                @Override
                CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                    SuspendDebuggerCommand.this.doCommandAfterSuspend();
                    return CommandOutputProcessingMode.DONE;
                }
            });
            return CommandOutputProcessingMode.DONE;
        }

        protected void doCommandAfterSuspend() {
            FlexDebugProcess.this.insertCommand(this.myCommand1);
        }
    }

    private class SuspendResumeDebuggerCommand
    extends SuspendDebuggerCommand {
        public SuspendResumeDebuggerCommand(DebuggerCommand command1) {
            super(command1);
        }

        @Override
        protected void doCommandAfterSuspend() {
            if (!(this.myCommand1 instanceof QuitCommand)) {
                FlexDebugProcess.this.insertCommand(new ContinueCommand());
            }
            super.doCommandAfterSuspend();
        }
    }

    class StartDebuggingCommand
    extends DebuggerCommand {
        StartDebuggingCommand() {
            super("run", CommandOutputProcessingType.SPECIAL_PROCESSING);
            FlexDebugProcess.this.setSuspended(true);
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(String s) {
            StringBuilder builder = new StringBuilder(s.length());
            StringTokenizer tokenizer = new StringTokenizer(s, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken();
                if (next.contains("type 'continue'")) continue;
                builder.append(next).append("\n");
            }
            s = builder.toString();
            int unexpectedVersionIndex = s.indexOf("Unexpected version of the Flash Player");
            if (unexpectedVersionIndex >= 0) {
                s = s.substring(0, unexpectedVersionIndex) + "Session timed out or u" + s.substring(unexpectedVersionIndex + 1);
            }
            ResponseLineIterator iterator = new ResponseLineIterator(s);
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (line.startsWith("[SWF]") || line.startsWith("[UnloadSWF]")) {
                    if (FilterSwfLoadUnloadMessagesAction.isFilterEnabled(FlexDebugProcess.this.getSession().getProject())) continue;
                    FlexDebugProcess.this.myConsoleView.print(line + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    continue;
                }
                FlexDebugProcess.this.myConsoleView.print(line + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            if (s.contains("Another Flash debugger is probably running")) {
                FlexDebugProcess.this.reportProblem(s);
                FlexDebugProcess.this.getProcessHandler().detachProcess();
                return CommandOutputProcessingMode.DONE;
            }
            if (s.contains("Failed to connect") || s.contains("unexpected version of the Flash Player") || s.contains("Connection refused")) {
                FlexDebugProcess.this.reportProblem(s);
                FlexDebugProcess.this.handleProbablyUnexpectedStop(s);
                return CommandOutputProcessingMode.DONE;
            }
            if (s.contains(FlexDebugProcess.WAITING_PLAYER_MARKER_1) || s.contains(FlexDebugProcess.WAITING_PLAYER_MARKER_2)) {
                FlexDebugProcess.this.fdbWaitingForPlayerStateReached = true;
                FlexDebugProcess.this.getSession().rebuildViews();
                FlexDebugProcess.this.notifyFdbWaitingForPlayerStateReached();
                try {
                    this.launchDebuggedApplication();
                }
                catch (IOException e) {
                    FlexDebugProcess.this.reportProblem(s);
                    FlexDebugProcess.this.handleProbablyUnexpectedStop(s);
                    return CommandOutputProcessingMode.DONE;
                }
            } else {
                FlexDebugProcess.this.startupDone = s.contains("Player connected; session starting.");
                if (FlexDebugProcess.this.startupDone) {
                    final Balloon balloon = ToolWindowManager.getInstance((Project)FlexDebugProcess.this.getSession().getProject()).getToolWindowBalloon(ToolWindowId.DEBUG);
                    if (balloon != null) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                balloon.hide();
                            }
                        });
                    }
                    FlexDebugProcess.this.getSession().rebuildViews();
                    return CommandOutputProcessingMode.DONE;
                }
            }
            return CommandOutputProcessingMode.PROCEEDING;
        }

        void launchDebuggedApplication() throws IOException {
        }
    }

    class LaunchBrowserCommand
    extends StartDebuggingCommand {
        @NotNull
        private final String myUrl;
        private final LauncherParameters myLauncherParameters;

        LaunchBrowserCommand(String url, LauncherParameters launcherParameters) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/flex/debug/FlexDebugProcess$LaunchBrowserCommand", "<init>"));
            }
            this.myUrl = url;
            this.myLauncherParameters = launcherParameters;
        }

        @Override
        void launchDebuggedApplication() {
            FlexBaseRunner.launchWithSelectedApplication(this.myUrl, this.myLauncherParameters);
        }
    }

    class StartAppOnIosDeviceCommand
    extends StartDebuggingCommand {
        private final String myAppName;

        public StartAppOnIosDeviceCommand(String appName) {
            this.myAppName = appName;
        }

        @Override
        void launchDebuggedApplication() throws IOException {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String adtVersion = AirPackageUtil.getAdtVersion(FlexDebugProcess.this.myModule.getProject(), FlexDebugProcess.this.myBC.getSdk());
                    if (StringUtil.compareVersionNumbers((String)adtVersion, (String)"3.4") >= 0) {
                        String message = FlexBundle.message("ios.application.installed.to.debug", StartAppOnIosDeviceCommand.this.myAppName);
                        ToolWindowManager.getInstance((Project)FlexDebugProcess.this.myModule.getProject()).notifyByBalloon(ToolWindowId.DEBUG, MessageType.INFO, message);
                    } else {
                        final String ipaName = FlexDebugProcess.this.myBC.getIosPackagingOptions().getPackageFileName() + ".ipa";
                        final String outputFolder = PathUtil.getParentPath((String)FlexDebugProcess.this.myBC.getActualOutputFilePath());
                        String message = FlexBundle.message("ios.application.packaged.to.debug", ipaName);
                        ToolWindowManager.getInstance((Project)FlexDebugProcess.this.myModule.getProject()).notifyByBalloon(ToolWindowId.DEBUG, MessageType.INFO, message, null, (HyperlinkListener)new HyperlinkAdapter(){

                            protected void hyperlinkActivated(HyperlinkEvent e) {
                                ShowFilePathAction.openFile((File)new File(outputFolder + "/" + ipaName));
                            }
                        });
                    }
                }
            });
        }
    }

    class StartAppOnIosSimulatorCommand
    extends StartDebuggingCommand {
        private final Sdk myFlexSdk;
        private final String myAppId;
        private final String myIOSSdkPath;

        StartAppOnIosSimulatorCommand(Sdk flexSdk, String appId, String iOSSdkPath) {
            this.myFlexSdk = flexSdk;
            this.myAppId = appId;
            this.myIOSSdkPath = iOSSdkPath;
        }

        @Override
        void launchDebuggedApplication() throws IOException {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlexBaseRunner.launchOnIosSimulator(FlexDebugProcess.this.getSession().getProject(), StartAppOnIosSimulatorCommand.this.myFlexSdk, StartAppOnIosSimulatorCommand.this.myAppId, StartAppOnIosSimulatorCommand.this.myIOSSdkPath, true);
                }
            });
        }
    }

    class StartAppOnAndroidDeviceCommand
    extends StartDebuggingCommand {
        private final Sdk myFlexSdk;
        @Nullable
        private final DeviceInfo myDevice;
        private final String myAppId;

        StartAppOnAndroidDeviceCommand(@Nullable Sdk flexSdk, DeviceInfo device, String appId) {
            this.myFlexSdk = flexSdk;
            this.myDevice = device;
            this.myAppId = appId;
        }

        @Override
        void launchDebuggedApplication() throws IOException {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlexBaseRunner.launchOnAndroidDevice(FlexDebugProcess.this.getSession().getProject(), StartAppOnAndroidDeviceCommand.this.myFlexSdk, StartAppOnAndroidDeviceCommand.this.myDevice, StartAppOnAndroidDeviceCommand.this.myAppId, true);
                }
            });
        }
    }

    class StartAirAppDebuggingCommand
    extends StartDebuggingCommand {
        private final GeneralCommandLine myAdlCommandLine;
        @Nullable
        private final VirtualFile myTempDirToDeleteWhenProcessFinished;

        public StartAirAppDebuggingCommand(@Nullable GeneralCommandLine adlCommandLine, VirtualFile tempDirToDeleteWhenProcessFinished) {
            this.myAdlCommandLine = adlCommandLine;
            this.myTempDirToDeleteWhenProcessFinished = tempDirToDeleteWhenProcessFinished;
        }

        @Override
        void launchDebuggedApplication() throws IOException {
            this.launchAdl();
        }

        private void launchAdl() throws IOException {
            try {
                FlexDebugProcess.this.myConsoleView.print(this.myAdlCommandLine.getCommandLineString() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                FlexDebugProcess.this.adlProcess = this.myAdlCommandLine.createProcess();
            }
            catch (ExecutionException e) {
                throw new IOException(e.getMessage());
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStreamReader reader = new InputStreamReader(FlexDebugProcess.this.adlProcess.getInputStream());
                    try {
                        int read;
                        char[] buf = new char[1024];
                        while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                            String message = new String(buf, 0, read);
                            LOG.debug("[adl input stream]: " + message);
                            if (FlexDebugProcess.this.startupDone) continue;
                            FlexDebugProcess.this.myConsoleView.print(FlexDebugProcess.ADL_PREFIX + message + (message.endsWith("\n") ? "" : "\n"), ConsoleViewContentType.ERROR_OUTPUT);
                        }
                        FlexDebugProcess.this.adlProcess.destroy();
                        try {
                            int exitCode = FlexDebugProcess.this.adlProcess.exitValue();
                            FlexDebugProcess.this.myConsoleView.print(FlexDebugProcess.ADL_PREFIX + IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) + "\n", exitCode == 0 ? ConsoleViewContentType.SYSTEM_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT);
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            // empty catch block
                        }
                        FlexDebugProcess.this.getProcessHandler().detachProcess();
                    }
                    catch (IOException e) {
                        LOG.debug("adl input stream reading error", (Throwable)e);
                        FlexDebugProcess.this.myConsoleView.print(FlexDebugProcess.ADL_PREFIX + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                    finally {
                        if (StartAirAppDebuggingCommand.this.myTempDirToDeleteWhenProcessFinished != null) {
                            FlexUtils.removeFileLater(StartAirAppDebuggingCommand.this.myTempDirToDeleteWhenProcessFinished);
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStreamReader reader = new InputStreamReader(FlexDebugProcess.this.adlProcess.getErrorStream());
                    try {
                        int read;
                        char[] buf = new char[1024];
                        while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                            String message = new String(buf, 0, read);
                            LOG.debug("[adl error stream]: " + message);
                        }
                    }
                    catch (IOException e) {
                        LOG.debug("adl error stream reading error", (Throwable)e);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
    }

    class ReadGreetingCommand
    extends DebuggerCommand {
        ReadGreetingCommand() {
            super("does not matter because post() is empty", CommandOutputProcessingType.SPECIAL_PROCESSING);
        }

        @Override
        public String read(FlexDebugProcess flexDebugProcess) throws IOException {
            return FlexDebugProcess.this.reader.readLine(true);
        }

        @Override
        public void post(FlexDebugProcess flexDebugProcess) throws IOException {
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
            FlexDebugProcess.this.myConsoleView.print(s + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            return CommandOutputProcessingMode.DONE;
        }
    }

    static class ContinueCommand
    extends DebuggerCommand {
        ContinueCommand() {
            super("continue", CommandOutputProcessingType.NO_PROCESSING, VMState.SUSPENDED, VMState.RUNNING);
        }
    }

    static class QuitCommand
    extends DebuggerCommand {
        QuitCommand() {
            super("quit\ny", CommandOutputProcessingType.SPECIAL_PROCESSING);
        }
    }

    class MyFdbOutputReader {
        private final InputStreamReader myReader;
        private final char[] buf = new char[8192];
        private final StringBuilder lastText = new StringBuilder();
        private int lastTextMarkerScanningStart;
        private final InputStream myInputStream;

        public MyFdbOutputReader(InputStream _inputStream) {
            this.myReader = FlexCommonUtils.createInputStreamReader((InputStream)_inputStream);
            this.myInputStream = _inputStream;
        }

        boolean hasSomeDataPending() throws IOException {
            return this.myInputStream.available() > 0;
        }

        String readLine(boolean nonblock) throws IOException {
            String lastText;
            int read;
            String lastText2;
            if (this.lastText != null && (lastText2 = this.getNextLine(nonblock)) != null) {
                return lastText2;
            }
            do {
                if ((read = this.myReader.read(this.buf, 0, this.buf.length)) == -1) {
                    return null;
                }
                this.lastText.append(this.buf, 0, read);
            } while (read >= this.buf.length || (lastText = this.getNextLine(nonblock)) == null);
            return lastText;
        }

        private String getNextLine(boolean allowEmptyMarker) {
            String marker = FlexDebugProcess.FDB_MARKER;
            int i = this.lastText.indexOf(marker, this.lastTextMarkerScanningStart);
            if (i == -1) {
                marker = "(y or n)";
                i = this.lastText.indexOf(marker, this.lastTextMarkerScanningStart);
            }
            if (i == -1 && (allowEmptyMarker || this.lastText.indexOf(FlexDebugProcess.WAITING_PLAYER_MARKER_1, this.lastTextMarkerScanningStart) >= 0 || this.lastText.indexOf(FlexDebugProcess.WAITING_PLAYER_MARKER_2, this.lastTextMarkerScanningStart) >= 0) && this.lastText.length() > 0) {
                i = this.lastText.length();
                marker = "";
            }
            if (i != -1) {
                String result = this.lastText.substring(0, i);
                this.lastText.delete(0, i + marker.length());
                this.lastTextMarkerScanningStart = 0;
                if (this.isBlank(this.lastText)) {
                    this.lastText.setLength(0);
                }
                FlexDebugProcess.this.setSuspended(marker.length() != 0);
                return result;
            }
            this.lastTextMarkerScanningStart = this.lastText.length();
            String result = null;
            return result;
        }

        private boolean isBlank(StringBuilder lastText) {
            for (int i = 0; i < lastText.length(); ++i) {
                if (lastText.charAt(i) == ' ') continue;
                return false;
            }
            return true;
        }
    }
}

