/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.CompositeDebuggerCommand;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.FlexValue;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Function;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexStackFrame
extends XStackFrame {
    private static final String ANONYMOUS = "<anonymous>";
    private final FlexDebugProcess myDebugProcess;
    @Nullable
    private final XSourcePosition mySourcePosition;
    @Nullable
    private final String myFileNameIfSourcePositionIsNull;
    private final int myLineIfSourcePositionIsNull;
    @NonNls
    static final String DELIM = " = ";
    private Map<String, String> qName2IdMap;
    private List<String> scopeChain;
    private final XDebuggerEvaluator myXDebuggerEvaluator = new FlexDebuggerEvaluator();
    private String myScope = "<unknown>";
    private int myFrameIndex;
    @NonNls
    protected static final String UNKNOWN_SCOPE = "<unknown>";
    static final String CLASS_MARKER = ", class='";
    static final String CANNOT_EVALUATE_EXPRESSION = "Cannot evaluate expression: ";
    private String myQualifiedFunctionName;

    FlexStackFrame(FlexDebugProcess debugProcess, @Nullable XSourcePosition sourcePosition) {
        this.myDebugProcess = debugProcess;
        this.mySourcePosition = sourcePosition;
        this.myFileNameIfSourcePositionIsNull = null;
        this.myLineIfSourcePositionIsNull = -1;
    }

    FlexStackFrame(FlexDebugProcess debugProcess, @Nullable String fileName, int line) {
        this.myDebugProcess = debugProcess;
        this.mySourcePosition = null;
        this.myFileNameIfSourcePositionIsNull = "<null>".equals(fileName) ? null : fileName;
        this.myLineIfSourcePositionIsNull = line;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/flex/debug/FlexStackFrame", "computeChildren"));
        }
        ArrayList<DebuggerCommand> commands = new ArrayList<DebuggerCommand>();
        commands.add(new MyDebuggerCommand("print this", node, true, FlexValue.ValueType.This));
        commands.add(new MyDebuggerCommand("info arguments", node, false, FlexValue.ValueType.Parameter));
        commands.add(new MyDebuggerCommand("info locals", node, false, FlexValue.ValueType.Variable));
        if (this.mySourcePosition != null) {
            commands.add(new DebuggerCommand("does not matter", CommandOutputProcessingType.SPECIAL_PROCESSING){

                @Override
                public void post(FlexDebugProcess flexDebugProcess) throws IOException {
                    FlexStackFrame.this.ensureQName2IdMapLoaded();
                    XValueChildrenList resultChildren = new XValueChildrenList(1);
                    Boolean insideFunExpr = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            Project project = FlexStackFrame.this.getDebugProcess().getSession().getProject();
                            PsiElement element = XDebuggerUtil.getInstance().findContextElement(FlexStackFrame.this.mySourcePosition.getFile(), FlexStackFrame.this.mySourcePosition.getOffset(), project, true);
                            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
                            return function instanceof JSFunctionExpression;
                        }
                    });
                    if (Boolean.TRUE.equals(insideFunExpr)) {
                        FlexStackFrame.this.scopeChain = new ArrayList(2);
                        String firstTokenAfterLastClosure = null;
                        for (String token : FlexStackFrame.this.qName2IdMap.keySet()) {
                            int slashIndex = token.indexOf(47);
                            if (slashIndex != -1 || token.contains(FlexStackFrame.ANONYMOUS)) {
                                String funName = token.substring(slashIndex + 1);
                                this.addScopeChainElement(token, funName, resultChildren);
                                continue;
                            }
                            if (firstTokenAfterLastClosure != null || resultChildren.size() <= 0) continue;
                            firstTokenAfterLastClosure = token;
                        }
                        if (firstTokenAfterLastClosure != null) {
                            this.addScopeChainElement(firstTokenAfterLastClosure, firstTokenAfterLastClosure, resultChildren);
                        }
                    }
                    node.addChildren(resultChildren, false);
                }

                @Override
                public String read(FlexDebugProcess flexDebugProcess) throws IOException {
                    return "";
                }

                private void addScopeChainElement(String token, String funName, XValueChildrenList resultChildren) {
                    String id = (String)FlexStackFrame.this.qName2IdMap.get(token);
                    String path = "#" + FlexStackFrame.validObjectId(id);
                    FlexStackFrame.this.scopeChain.add(path);
                    String name = "Locals of " + funName;
                    String flexValueResult = "[Object " + id + FlexStackFrame.CLASS_MARKER + token + "']";
                    resultChildren.add(name, (XValue)new FlexValue(FlexStackFrame.this, FlexStackFrame.this.myDebugProcess, FlexStackFrame.this.mySourcePosition, name, path, flexValueResult, null, FlexValue.ValueType.ScopeChainEntry));
                }
            });
        }
        this.myDebugProcess.sendCommand(new CompositeDebuggerCommand((Obsolescent)node, commands.toArray(new DebuggerCommand[commands.size()])){

            @Override
            protected void obsolete() {
                super.obsolete();
                node.addChildren(XValueChildrenList.EMPTY, true);
            }

            @Override
            protected void succeeded() {
                super.succeeded();
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
        });
    }

    private String addFrameOffset(String text) {
        text = "frame " + (this.myFrameIndex != 0 ? Integer.valueOf(this.myFrameIndex) : "") + "\n" + text;
        return text;
    }

    public XDebuggerEvaluator getEvaluator() {
        return this.myXDebuggerEvaluator;
    }

    public void setFrameIndex(int frameIndex) {
        this.myFrameIndex = frameIndex;
    }

    @NonNls
    private String buildCommandForExpression(final String _expression) {
        String evalCommand;
        if (_expression.indexOf(61) != -1 && (evalCommand = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                JSExpression expression;
                PsiFile fromText = PsiFileFactory.getInstance((Project)FlexStackFrame.this.myDebugProcess.getSession().getProject()).createFileFromText("A.js2", (Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, (CharSequence)_expression);
                PsiElement[] elements = fromText.getChildren();
                if (elements.length == 1 && elements[0] instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)elements[0]).getExpression()) instanceof JSAssignmentExpression) {
                    JSAssignmentExpression expr = (JSAssignmentExpression)expression;
                    JSExpression lOperand = expr.getLOperand();
                    String lOperandText = lOperand == null ? null : lOperand.getText();
                    JSExpression rOperand = expr.getROperand();
                    if (lOperandText != null && rOperand != null) {
                        return FlexStackFrame.this.addFrameOffset("set " + lOperandText + FlexStackFrame.DELIM + rOperand.getText() + "\nprint " + lOperandText);
                    }
                }
                return null;
            }
        })) != null) {
            return evalCommand;
        }
        return this.addFrameOffset("print " + _expression);
    }

    private void ensureQName2IdMapLoaded() {
        if (this.qName2IdMap != null) {
            return;
        }
        this.qName2IdMap = this.myDebugProcess.getQName2IdIfSameEqualityObject(this.getEqualityObject());
        if (this.qName2IdMap != null) {
            return;
        }
        this.qName2IdMap = new LinkedHashMap<String, String>();
        DebuggerCommand command = new DebuggerCommand("info scopechain", CommandOutputProcessingType.SPECIAL_PROCESSING){

            @Override
            CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\r\n");
                while (tokenizer.hasMoreElements()) {
                    String line = tokenizer.nextToken();
                    int lBracketPos = line.indexOf(91);
                    int rBracketPos = line.lastIndexOf(93);
                    if (lBracketPos == -1 || rBracketPos == -1) continue;
                    line = line.substring(lBracketPos + 1, rBracketPos);
                    String id = line.substring(line.indexOf(32) + 1, line.indexOf(44));
                    String qName = line.substring(line.indexOf(39) + 1, line.lastIndexOf(39));
                    qName = qName.replace("::", ".");
                    FlexStackFrame.this.qName2IdMap.put(qName, id);
                }
                FlexStackFrame.this.myDebugProcess.setQName2Id(FlexStackFrame.this.qName2IdMap, FlexStackFrame.this.getEqualityObject());
                return CommandOutputProcessingMode.DONE;
            }
        };
        this.myDebugProcess.sendAndProcessOneCommand(command, new Function<Exception, Void>(){

            public Void fun(Exception e) {
                FlexDebugProcess.log(e);
                return null;
            }
        });
    }

    static String validObjectId(String s) {
        long idVal = Long.parseLong(s);
        return s.charAt(0) == '-' ? Long.toString(idVal & 0xFFFFFFFFL) : Long.toString(idVal);
    }

    String eval(String expression, FlexDebugProcess process) {
        EvaluateCommand command = new EvaluateCommand(expression, null);
        process.sendAndProcessOneCommand(command, null);
        return command.result;
    }

    public FlexDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/lang/javascript/flex/debug/FlexStackFrame", "customizePresentation"));
        }
        component.append(this.myScope, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.mySourcePosition != null) {
            component.append(" in ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(this.mySourcePosition.getFile().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(":" + (this.mySourcePosition.getLine() + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (this.myFileNameIfSourcePositionIsNull != null) {
            component.append(" in ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(this.myFileNameIfSourcePositionIsNull, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.myLineIfSourcePositionIsNull >= 0) {
                component.append(":" + this.myLineIfSourcePositionIsNull, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    public void setScope(String scope) {
        this.myScope = scope;
    }

    public Object getEqualityObject() {
        if (this.myQualifiedFunctionName == null) {
            if (this.mySourcePosition != null) {
                String name;
                FlexDebugProcess flexDebugProcess = this.getDebugProcess();
                final Project project = flexDebugProcess.getSession().getProject();
                final VirtualFile file = this.mySourcePosition.getFile();
                JSFunction function = (JSFunction)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<JSFunction>(){

                    public JSFunction compute() {
                        PsiElement element = XDebuggerUtil.getInstance().findContextElement(file, FlexStackFrame.this.mySourcePosition.getOffset(), project, true);
                        return (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
                    }
                });
                this.myQualifiedFunctionName = file.getPath() + (function != null ? "#" + ((name = function.getName()) != null ? name : Integer.valueOf(function.getTextOffset())) : "");
            } else {
                this.myQualifiedFunctionName = "unknown";
            }
        }
        return this.myQualifiedFunctionName;
    }

    private class MyDebuggerCommand
    extends DebuggerCommand {
        private final boolean hasFrame;
        private final XValueChildrenList resultChildren;
        private int current;
        private final XCompositeNode myNode;
        private final FlexValue.ValueType myValueType;

        public MyDebuggerCommand(String text, XCompositeNode node, boolean _hasFrame, FlexValue.ValueType valueType) {
            super(_hasFrame ? FlexStackFrame.this.addFrameOffset(text) : text, CommandOutputProcessingType.SPECIAL_PROCESSING);
            this.myNode = node;
            this.resultChildren = new XValueChildrenList(3);
            this.hasFrame = _hasFrame;
            this.myValueType = valueType;
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
            int offsetIndex;
            int n = offsetIndex = this.hasFrame ? 1 : 0;
            if (this.current >= offsetIndex) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\r\n", true);
                Pair previousNameAndValue = null;
                while (tokenizer.hasMoreElements()) {
                    String token = tokenizer.nextToken();
                    if (token.length() == 0) continue;
                    if (token.charAt(0) == '\r' || token.charAt(0) == '\n') {
                        if (previousNameAndValue != null) {
                            ((StringBuilder)previousNameAndValue.second).append(token);
                            continue;
                        }
                        FlexDebugProcess.log("Unexpected token: [" + token + "], full string: [" + s + "]");
                        continue;
                    }
                    int i = token.indexOf(FlexStackFrame.DELIM);
                    if (i == -1) {
                        if (previousNameAndValue != null) {
                            ((StringBuilder)previousNameAndValue.second).append(token);
                            continue;
                        }
                        FlexDebugProcess.log("Unexpected token: [" + token + "], full string: [" + s + "]");
                        continue;
                    }
                    String name = token.substring(0, i);
                    if (name.startsWith("$")) {
                        boolean completeDigits = name.length() > 1;
                        for (int j = 1; j < name.length() && (completeDigits &= Character.isDigit(name.charAt(j))); ++j) {
                        }
                        if (completeDigits) {
                            name = "this";
                        }
                    }
                    if (previousNameAndValue != null) {
                        String prevName = (String)previousNameAndValue.first;
                        this.resultChildren.add(prevName, (XValue)new FlexValue(FlexStackFrame.this, FlexStackFrame.this.myDebugProcess, FlexStackFrame.this.mySourcePosition, prevName, prevName, this.removeTrailingNewLines((StringBuilder)previousNameAndValue.second), null, this.myValueType));
                    }
                    previousNameAndValue = Pair.create((Object)name, (Object)new StringBuilder(token.substring(i + FlexStackFrame.DELIM.length())));
                }
                if (previousNameAndValue != null) {
                    String prevName = (String)previousNameAndValue.first;
                    this.resultChildren.add(prevName, (XValue)new FlexValue(FlexStackFrame.this, FlexStackFrame.this.myDebugProcess, FlexStackFrame.this.mySourcePosition, prevName, prevName, this.removeTrailingNewLines((StringBuilder)previousNameAndValue.second), null, this.myValueType));
                }
            }
            ++this.current;
            if (this.current == offsetIndex + 1) {
                this.myNode.addChildren(this.resultChildren, false);
                return CommandOutputProcessingMode.DONE;
            }
            return CommandOutputProcessingMode.PROCEEDING;
        }

        private String removeTrailingNewLines(StringBuilder builder) {
            while (builder.length() > 0 && (builder.charAt(builder.length() - 1) == '\r' || builder.charAt(builder.length() - 1) == '\n')) {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
    }

    private class FlexDebuggerEvaluator
    extends XDebuggerEvaluator {
        private FlexDebuggerEvaluator() {
        }

        public boolean isCodeFragmentEvaluationSupported() {
            return false;
        }

        public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/flex/debug/FlexStackFrame$FlexDebuggerEvaluator", "evaluate"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/FlexStackFrame$FlexDebuggerEvaluator", "evaluate"));
            }
            EvaluateCommand command = new EvaluateCommand(expression, callback);
            FlexStackFrame.this.myDebugProcess.sendCommand(command);
        }

        @Nullable
        public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/debug/FlexStackFrame$FlexDebuggerEvaluator", "getExpressionInfoAtOffset"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flex/debug/FlexStackFrame$FlexDebuggerEvaluator", "getExpressionInfoAtOffset"));
            }
            return JSDebuggerSupportUtils.getExpressionAtOffset((Project)project, (Document)document, (int)offset);
        }
    }

    class EvaluateCommand
    extends DebuggerCommand {
        private String result;
        private final XDebuggerEvaluator.XEvaluationCallback callback;
        private final String expression;
        private int responseCount;
        private boolean myFinished;

        EvaluateCommand(String _expression, XDebuggerEvaluator.XEvaluationCallback _callback) {
            super(FlexStackFrame.this.buildCommandForExpression(_expression), CommandOutputProcessingType.SPECIAL_PROCESSING);
            this.expression = _expression;
            this.callback = _callback;
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(@NonNls String line) {
            if (FlexStackFrame.this.myDebugProcess.filterStdResponse(line)) {
                return CommandOutputProcessingMode.PROCEEDING;
            }
            return this.proceedWithEvaluationResponse(line);
        }

        private CommandOutputProcessingMode proceedWithEvaluationResponse(String line) {
            ++this.responseCount;
            if (this.responseCount == 1) {
                return CommandOutputProcessingMode.PROCEEDING;
            }
            return this.doOnTextAvailable(line);
        }

        CommandOutputProcessingMode doOnTextAvailable(@NonNls String s) {
            if (this.cannotEvaluateResponse(s) && FlexStackFrame.this.mySourcePosition != null) {
                FlexStackFrame.this.ensureQName2IdMapLoaded();
                this.evaluateFromTypeMap();
                return CommandOutputProcessingMode.DONE;
            }
            if (this.getText().contains("\n") && s.length() == 0) {
                return CommandOutputProcessingMode.PROCEEDING;
            }
            this.dispatchResult(s);
            return CommandOutputProcessingMode.DONE;
        }

        private boolean cannotEvaluateResponse(String s) {
            return s.contains("could not be evaluated");
        }

        private void evaluateFromTypeMap() {
            boolean handled;
            block5: {
                block4: {
                    assert (FlexStackFrame.this.mySourcePosition != null);
                    int dotPos = this.expression.indexOf(46);
                    final String typeName = dotPos != -1 ? this.expression.substring(0, dotPos) : this.expression;
                    String resolvedName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            PsiLanguageInjectionHost psiLanguageInjectionHost;
                            PsiElement element;
                            VirtualFile virtualFile = FlexStackFrame.this.mySourcePosition.getFile();
                            PsiFile file = PsiManager.getInstance((Project)FlexStackFrame.this.myDebugProcess.getSession().getProject()).findFile(virtualFile);
                            final int offset = FlexStackFrame.this.mySourcePosition.getOffset();
                            PsiElement psiElement = element = file == null ? null : file.findElementAt(offset);
                            if (file instanceof XmlFile && (psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class)) != null) {
                                final Ref result = new Ref();
                                InjectedLanguageUtil.enumerate((PsiElement)psiLanguageInjectionHost, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                                        if (injectedPsi == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/lang/javascript/flex/debug/FlexStackFrame$EvaluateCommand$1$1", "visit"));
                                        }
                                        if (places == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/flex/debug/FlexStackFrame$EvaluateCommand$1$1", "visit"));
                                        }
                                        int injectedStart = InjectedLanguageUtil.getInjectedStart(places);
                                        result.set((Object)injectedPsi.findElementAt(offset - injectedStart + places.get(0).getPrefix().length()));
                                    }
                                });
                                element = (PsiElement)result.get();
                            }
                            return element == null ? typeName : JSImportHandlingUtil.resolveTypeName((String)typeName, (PsiElement)element);
                        }
                    });
                    boolean isGlobal = false;
                    handled = false;
                    if (resolvedName.equals(typeName) && !(isGlobal = typeName.equals("global"))) break block4;
                    String id = (String)FlexStackFrame.this.qName2IdMap.get(resolvedName + (isGlobal ? "" : "$"));
                    if (id == null) break block5;
                    handled = true;
                    EvaluateCommand evaluateCommand = new EvaluateCommand("#" + id + (dotPos != -1 ? this.expression.substring(dotPos) : ""), this.callback){

                        @Override
                        CommandOutputProcessingMode doOnTextAvailable(@NonNls String s) {
                            this.dispatchResult(s);
                            return CommandOutputProcessingMode.DONE;
                        }
                    };
                    FlexStackFrame.this.myDebugProcess.sendAndProcessOneCommand(evaluateCommand, new Function<Exception, Void>(){

                        public Void fun(Exception e) {
                            FlexDebugProcess.log(e);
                            return null;
                        }
                    });
                    break block5;
                }
                if (FlexStackFrame.this.scopeChain != null) {
                    for (String id2 : FlexStackFrame.this.scopeChain) {
                        final Ref resolved = new Ref();
                        EvaluateCommand evaluateCommand = new EvaluateCommand(id2 + "." + this.expression, this.callback){

                            @Override
                            CommandOutputProcessingMode doOnTextAvailable(@NonNls String s) {
                                if (!EvaluateCommand.this.cannotEvaluateResponse(s)) {
                                    resolved.set((Object)Boolean.TRUE);
                                    this.dispatchResult(s);
                                }
                                return CommandOutputProcessingMode.DONE;
                            }
                        };
                        FlexStackFrame.this.myDebugProcess.sendAndProcessOneCommand(evaluateCommand, new Function<Exception, Void>(){

                            public Void fun(Exception e) {
                                FlexDebugProcess.log(e);
                                return null;
                            }
                        });
                        if (resolved.get() != Boolean.TRUE) continue;
                        handled = true;
                        break;
                    }
                }
            }
            if (!handled) {
                this.dispatchResult(FlexStackFrame.CANNOT_EVALUATE_EXPRESSION + this.expression);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchResult(String s) {
            int i = s.indexOf(FlexStackFrame.DELIM);
            if (i != -1) {
                s = s.substring(i + FlexStackFrame.DELIM.length());
            }
            this.result = s.trim();
            if (this.callback != null) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        EvaluateCommand.this.callback.evaluated((XValue)new FlexValue(FlexStackFrame.this, FlexStackFrame.this.myDebugProcess, FlexStackFrame.this.mySourcePosition, EvaluateCommand.this.expression, EvaluateCommand.this.expression, EvaluateCommand.this.result, null, FlexValue.ValueType.Other));
                    }
                });
            } else {
                EvaluateCommand evaluateCommand = this;
                synchronized (evaluateCommand) {
                    this.myFinished = true;
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitTillExecutionEnd() {
            EvaluateCommand evaluateCommand = this;
            synchronized (evaluateCommand) {
                if (this.myFinished) {
                    return;
                }
                try {
                    do {
                        this.wait();
                    } while (this.result == null);
                }
                catch (InterruptedException ex) {
                    FlexDebugProcess.log(ex);
                    return;
                }
            }
        }
    }
}

