/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexModuleBuilder;
import com.intellij.lang.javascript.flex.flashbuilder.FilesToPackageUtil;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProject;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectLoadUtil;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderSdkFinder;
import com.intellij.lang.javascript.flex.library.FlexLibraryProperties;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashBuilderModuleImporter {
    private static final String CORE_RESOURCES_PREFS_REL_PATH = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.core.resources.prefs";
    private static final String PATHVARIABLE_DOT = "pathvariable.";
    private static final String SDK_THEMES_DIR_MACRO = "${SDK_THEMES_DIR}";
    private static final String EXTERNAL_THEME_DIR_MACRO = "${EXTERNAL_THEME_DIR}";
    private static final String EXTERNAL_THEME_DIR_REL_PATH = SystemInfo.isWindows ? "/AppData/Roaming/Adobe/Flash Builder/Themes" : "/Library/Application Support/Adobe/Flash Builder/Themes";
    private final Project myIdeaProject;
    private FlexProjectConfigurationEditor myFlexConfigEditor;
    private final Collection<FlashBuilderProject> myAllFBProjects;
    private final FlashBuilderSdkFinder mySdkFinder;
    private final Set<String> myPathVariables;
    private boolean myPathVariablesInitialized = false;

    public FlashBuilderModuleImporter(Project ideaProject, FlexProjectConfigurationEditor flexConfigEditor, Collection<FlashBuilderProject> allFBProjects, FlashBuilderSdkFinder sdkFinder) {
        this.myIdeaProject = ideaProject;
        this.myFlexConfigEditor = flexConfigEditor;
        this.myAllFBProjects = allFBProjects;
        this.mySdkFinder = sdkFinder;
        this.myPathVariables = new THashSet();
        for (FlashBuilderProject flashBuilderProject : allFBProjects) {
            this.myPathVariables.addAll(flashBuilderProject.getUsedPathVariables());
        }
    }

    public void setupModule(ModifiableRootModel rootModel, FlashBuilderProject flashBuilderProject) {
        this.setupRoots(rootModel, flashBuilderProject);
        this.setupBuildConfigs((ModuleRootModel)rootModel, flashBuilderProject);
    }

    private void setupBuildConfigs(ModuleRootModel rootModel, FlashBuilderProject fbProject) {
        Sdk sdk = fbProject.isSdkUsed() ? this.mySdkFinder.findSdk(fbProject) : null;
        ModifiableFlexBuildConfiguration[] configurations = this.myFlexConfigEditor.getConfigurations(rootModel.getModule());
        assert (configurations.length == 1);
        ModifiableFlexBuildConfiguration mainBC = configurations[0];
        String bcName = FlashBuilderModuleImporter.suggestMainBCName(fbProject);
        mainBC.setName(bcName);
        TargetPlatform targetPlatform = fbProject.getTargetPlatform();
        mainBC.setTargetPlatform(targetPlatform);
        mainBC.setPureAs(fbProject.isPureActionScript());
        mainBC.setOutputType(fbProject.getOutputType());
        THashMap compilerOptions = new THashMap();
        if (fbProject.getOutputType() == OutputType.Application) {
            mainBC.setMainClass(fbProject.getMainAppClassName());
            String shortClassName = StringUtil.getShortName((String)fbProject.getMainAppClassName());
            mainBC.setOutputFileName(shortClassName + ".swf");
            if (!mainBC.isPureAs() && fbProject.getThemeDirPathRaw() != null && sdk != null) {
                FlashBuilderModuleImporter.setupTheme(fbProject.getThemeDirPathRaw(), mainBC.getNature(), sdk, mainBC.getDependencies().getComponentSet(), (Map<String, String>)compilerOptions);
            }
            switch (targetPlatform) {
                case Web: {
                    if (!fbProject.isUseHtmlWrapper()) break;
                    mainBC.setUseHtmlWrapper(true);
                    mainBC.setWrapperTemplatePath(fbProject.getProjectRootPath() + "/" + "html-template");
                    break;
                }
                case Desktop: {
                    FlashBuilderModuleImporter.setupAirDescriptor(mainBC, rootModel);
                    mainBC.getAirDesktopPackagingOptions().setPackageFileName(shortClassName);
                    if (!StringUtil.isEmpty((String)fbProject.getDesktopCertPath())) {
                        mainBC.getAirDesktopPackagingOptions().getSigningOptions().setUseTempCertificate(false);
                        mainBC.getAirDesktopPackagingOptions().getSigningOptions().setKeystorePath(fbProject.getDesktopCertPath());
                    }
                    FilesToPackageUtil.setupFilesToPackage(mainBC.getAirDesktopPackagingOptions(), fbProject.getPathsExcludedFromDesktopPackaging(), rootModel);
                    break;
                }
                case Mobile: {
                    FlashBuilderModuleImporter.setupAirDescriptor(mainBC, rootModel);
                    mainBC.getAndroidPackagingOptions().setEnabled(fbProject.isAndroidSupported());
                    mainBC.getAndroidPackagingOptions().setPackageFileName(shortClassName);
                    if (!StringUtil.isEmpty((String)fbProject.getAndroidCertPath())) {
                        mainBC.getAndroidPackagingOptions().getSigningOptions().setUseTempCertificate(false);
                        mainBC.getAndroidPackagingOptions().getSigningOptions().setKeystorePath(fbProject.getAndroidCertPath());
                    }
                    FilesToPackageUtil.setupFilesToPackage(mainBC.getAndroidPackagingOptions(), fbProject.getPathsExcludedFromAndroidPackaging(), rootModel);
                    mainBC.getIosPackagingOptions().setEnabled(fbProject.isIosSupported());
                    mainBC.getIosPackagingOptions().setPackageFileName(shortClassName);
                    mainBC.getIosPackagingOptions().getSigningOptions().setProvisioningProfilePath(StringUtil.notNullize((String)fbProject.getIOSProvisioningPath()));
                    mainBC.getIosPackagingOptions().getSigningOptions().setKeystorePath(StringUtil.notNullize((String)fbProject.getIOSCertPath()));
                    FilesToPackageUtil.setupFilesToPackage(mainBC.getIosPackagingOptions(), fbProject.getPathsExcludedFromIOSPackaging(), rootModel);
                }
            }
        } else {
            mainBC.setOutputFileName(fbProject.getName() + ".swc");
        }
        mainBC.setOutputFolder(this.getAbsolutePathWithLinksHandled(fbProject, fbProject.getOutputFolderPath()));
        this.setupRLMsAndCSSFilesToCompile(mainBC, fbProject);
        if (sdk != null) {
            mainBC.getDependencies().setSdkEntry(Factory.createSdkEntry(sdk.getName()));
            String sdkHome = sdk.getHomePath();
            if (targetPlatform == TargetPlatform.Web && sdkHome != null) {
                mainBC.getDependencies().setTargetPlayer(FlexSdkUtils.getTargetPlayer(fbProject.getTargetPlayerVersion(), sdkHome));
            }
        }
        this.setupDependencies(mainBC, fbProject);
        String fbOptions = fbProject.getAdditionalCompilerOptions();
        FlashBuilderModuleImporter.setupLocales(fbOptions, (Map<String, String>)compilerOptions);
        this.setupNamespacesAndManifests(rootModel, fbProject, (Map<String, String>)compilerOptions);
        FlashBuilderModuleImporter.setupFilesToIncludeInSwc(rootModel, mainBC, fbProject.getFilesIncludedInSwc());
        mainBC.getCompilerOptions().setAllOptions((Map<String, String>)compilerOptions);
        String ideaOptions = FlexCommonUtils.removeOptions((String)fbOptions, (String[])new String[]{"locale", "compiler.locale", "source-path", "compiler.source-path"});
        mainBC.getCompilerOptions().setAdditionalOptions(ideaOptions);
        if (mainBC.getOutputType() == OutputType.Application) {
            FlexModuleBuilder.createRunConfiguration(rootModel.getModule(), mainBC);
        }
        this.setupOtherAppsAndModules(rootModel, mainBC, fbProject);
    }

    private void setupRLMsAndCSSFilesToCompile(ModifiableFlexBuildConfiguration mainBC, FlashBuilderProject fbProject) {
        if (BCUtils.canHaveRLMsAndRuntimeStylesheets(mainBC) && !fbProject.getCssFilesToCompile().isEmpty()) {
            ArrayList<String> cssPaths = new ArrayList<String>();
            for (String path : fbProject.getCssFilesToCompile()) {
                String cssPath = this.getAbsolutePathWithLinksHandled(fbProject, path);
                VirtualFile cssFile = LocalFileSystem.getInstance().findFileByPath(cssPath);
                if (cssFile != null) {
                    cssPaths.add(cssFile.getPath());
                    continue;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) continue;
                cssPaths.add(cssPath);
            }
            mainBC.setCssFilesToCompile(cssPaths);
        }
    }

    private static void setupLocales(String fbOptions, Map<String, String> compilerOptions) {
        List locales = FlexCommonUtils.getOptionValues((String)fbOptions, (String[])new String[]{"locale", "compiler.locale"});
        StringBuilder localesBuf = new StringBuilder();
        for (String locale : locales) {
            if (localesBuf.length() > 0) {
                localesBuf.append("\n");
            }
            localesBuf.append(locale);
        }
        compilerOptions.put("compiler.locale", localesBuf.toString());
    }

    private void setupNamespacesAndManifests(ModuleRootModel rootModel, FlashBuilderProject fbProject, Map<String, String> compilerOptions) {
        if (!fbProject.getNamespacesAndManifestPaths().isEmpty()) {
            StringBuilder nsBuf = new StringBuilder();
            for (Pair<String, String> nsAndManifestPath : fbProject.getNamespacesAndManifestPaths()) {
                String resolvedManifestPath;
                VirtualFile sourceRoot;
                String manifestPath = (String)nsAndManifestPath.second;
                VirtualFile manifestFile = null;
                VirtualFile[] virtualFileArray = rootModel.getSourceRoots();
                int n = virtualFileArray.length;
                for (int i = 0; i < n && (manifestFile = (sourceRoot = virtualFileArray[i]).findFileByRelativePath(manifestPath)) == null; ++i) {
                }
                String string = resolvedManifestPath = manifestFile != null ? manifestFile.getPath() : this.getAbsolutePathWithLinksHandled(fbProject, manifestPath);
                if (nsBuf.length() > 0) {
                    nsBuf.append("\n");
                }
                nsBuf.append((String)nsAndManifestPath.first).append("\t");
                nsBuf.append(resolvedManifestPath);
            }
            compilerOptions.put("compiler.namespaces.namespace", nsBuf.toString());
        }
    }

    private static void setupFilesToIncludeInSwc(final ModuleRootModel rootModel, ModifiableFlexBuildConfiguration bc, Collection<String> paths) {
        if (bc.getOutputType() == OutputType.Library) {
            bc.getCompilerOptions().setFilesToIncludeInSWC(ContainerUtil.mapNotNull(paths, (Function)new Function<String, String>(){

                public String fun(String path) {
                    for (VirtualFile srcRoot : rootModel.getSourceRoots()) {
                        VirtualFile assetFile = LocalFileSystem.getInstance().findFileByPath(srcRoot.getPath() + "/" + path);
                        if (assetFile == null) continue;
                        return assetFile.getPath();
                    }
                    return null;
                }
            }));
        }
    }

    private static void setupTheme(String themeDirPathRaw, BuildConfigurationNature nature, Sdk sdk, ComponentSet componentSet, Map<String, String> compilerOptions) {
        String themeFilePath;
        File themeDir;
        String themeDirPath = null;
        if (themeDirPathRaw.startsWith(EXTERNAL_THEME_DIR_MACRO)) {
            themeDirPath = SystemProperties.getUserHome() + EXTERNAL_THEME_DIR_REL_PATH + themeDirPathRaw.substring(EXTERNAL_THEME_DIR_MACRO.length());
        } else if (themeDirPathRaw.startsWith(SDK_THEMES_DIR_MACRO)) {
            themeDirPath = sdk.getHomePath() + themeDirPathRaw.substring(SDK_THEMES_DIR_MACRO.length());
        }
        if (themeDirPath != null && (themeDir = new File(themeDirPath)).isDirectory() && (themeFilePath = FlashBuilderModuleImporter.findThemeFilePath(themeDir)) != null) {
            String themePathWithMacro = themeFilePath.replace(sdk.getHomePath(), "${FLEX_SDK}");
            if ("${SDK_THEMES_DIR}/frameworks/themes/Halo".equals(themeDirPathRaw)) {
                compilerOptions.put("compiler.theme", themePathWithMacro);
            } else if ("${SDK_THEMES_DIR}/frameworks/themes/AeonGraphical".equals(themeDirPathRaw)) {
                String haloTheme = "${FLEX_SDK}/frameworks/themes/Halo/halo.swc";
                compilerOptions.put("compiler.theme", "${FLEX_SDK}/frameworks/themes/Halo/halo.swc\n" + themePathWithMacro);
            } else {
                CompilerOptionInfo themeInfo = CompilerOptionInfo.getOptionInfo((String)"compiler.theme");
                String defaultTheme = themeInfo.getDefaultValue(sdk.getVersionString(), nature, componentSet);
                if (defaultTheme.isEmpty()) {
                    compilerOptions.put("compiler.theme", themePathWithMacro);
                } else {
                    compilerOptions.put("compiler.theme", defaultTheme + "\n" + themePathWithMacro);
                }
            }
        }
    }

    @Nullable
    private static String findThemeFilePath(File themeDir) {
        String fileName = (String)ContainerUtil.find((Object[])themeDir.list(), (Condition)new Condition<String>(){

            public boolean value(String path) {
                return FileUtilRt.extensionEquals((String)path, (String)"css") || FileUtilRt.extensionEquals((String)path, (String)"swc");
            }
        });
        return fileName == null ? null : FileUtil.toSystemIndependentName((String)(themeDir + "/" + fileName));
    }

    private static void setupAirDescriptor(ModifiableFlexBuildConfiguration bc, ModuleRootModel rootModel) {
        if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
            bc.getAirDesktopPackagingOptions().setUseGeneratedDescriptor(true);
        } else {
            bc.getAndroidPackagingOptions().setUseGeneratedDescriptor(true);
            bc.getIosPackagingOptions().setUseGeneratedDescriptor(true);
        }
        String descriptorRelPath = bc.getMainClass().replace('.', '/') + "-app.xml";
        for (VirtualFile srcRoot : rootModel.getSourceRoots()) {
            if (srcRoot.findFileByRelativePath(descriptorRelPath) == null) continue;
            if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
                bc.getAirDesktopPackagingOptions().setUseGeneratedDescriptor(false);
                bc.getAirDesktopPackagingOptions().setCustomDescriptorPath(srcRoot.getPath() + "/" + descriptorRelPath);
                break;
            }
            bc.getAndroidPackagingOptions().setUseGeneratedDescriptor(false);
            bc.getAndroidPackagingOptions().setCustomDescriptorPath(srcRoot.getPath() + "/" + descriptorRelPath);
            bc.getIosPackagingOptions().setUseGeneratedDescriptor(false);
            bc.getIosPackagingOptions().setCustomDescriptorPath(srcRoot.getPath() + "/" + descriptorRelPath);
            break;
        }
    }

    private void setupOtherAppsAndModules(ModuleRootModel rootModel, ModifiableFlexBuildConfiguration mainBC, FlashBuilderProject fbProject) {
        ArrayList<ModifiableFlexBuildConfiguration> allApps = new ArrayList<ModifiableFlexBuildConfiguration>();
        allApps.add(mainBC);
        for (String mainClass : fbProject.getApplicationClassNames()) {
            ModifiableFlexBuildConfiguration bc = this.myFlexConfigEditor.copyConfiguration(mainBC, mainBC.getNature());
            String shortClassName = StringUtil.getShortName((String)mainClass);
            bc.setName(shortClassName);
            bc.setMainClass(mainClass);
            bc.setOutputFileName(shortClassName + ".swf");
            if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
                FlashBuilderModuleImporter.setupAirDescriptor(bc, rootModel);
                bc.getAirDesktopPackagingOptions().setPackageFileName(shortClassName);
            }
            if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
                FlashBuilderModuleImporter.setupAirDescriptor(bc, rootModel);
                bc.getAndroidPackagingOptions().setPackageFileName(shortClassName);
                bc.getIosPackagingOptions().setPackageFileName(shortClassName);
            }
            FlexModuleBuilder.createRunConfiguration(rootModel.getModule(), bc);
            allApps.add(bc);
        }
        if (BCUtils.canHaveRLMsAndRuntimeStylesheets(mainBC)) {
            this.setupModules(rootModel, allApps, fbProject);
        }
    }

    private void setupModules(ModuleRootModel rootModel, Collection<ModifiableFlexBuildConfiguration> apps, FlashBuilderProject fbProject) {
        for (FlashBuilderProject.FBRLMInfo rlm : fbProject.getModules()) {
            ModifiableFlexBuildConfiguration hostApp = apps.iterator().next();
            if (rlm.OPTIMIZE) {
                String hostAppMainClass = this.getMainClassFqn(fbProject, rlm.OPTIMIZE_FOR, rootModel.getSourceRootUrls());
                for (ModifiableFlexBuildConfiguration appBC : apps) {
                    if (!hostAppMainClass.equals(appBC.getMainClass())) continue;
                    hostApp = appBC;
                    break;
                }
            }
            ArrayList<FlexBuildConfiguration.RLMInfo> rlms = new ArrayList<FlexBuildConfiguration.RLMInfo>(hostApp.getRLMs());
            String rlmMainClass = this.getMainClassFqn(fbProject, rlm.MAIN_CLASS_PATH, rootModel.getSourceRootUrls());
            rlms.add(new FlexBuildConfiguration.RLMInfo(rlmMainClass, rlm.OUTPUT_PATH, rlm.OPTIMIZE));
            hostApp.setRLMs(rlms);
        }
    }

    private static String suggestMainBCName(FlashBuilderProject fbProject) {
        return fbProject.getOutputType() == OutputType.Application && !fbProject.getMainAppClassName().isEmpty() ? StringUtil.getShortName((String)fbProject.getMainAppClassName()) : fbProject.getName();
    }

    private String getMainClassFqn(FlashBuilderProject flashBuilderProject, String mainClassPath, String[] sourceRootUrls) {
        String mainClassPathUrl = VfsUtilCore.pathToUrl((String)this.getAbsolutePathWithLinksHandled(flashBuilderProject, mainClassPath));
        for (String sourceRootUrl : sourceRootUrls) {
            if (!mainClassPathUrl.startsWith(sourceRootUrl + "/")) continue;
            return FlashBuilderProjectLoadUtil.getClassName(mainClassPathUrl.substring(sourceRootUrl.length() + 1));
        }
        return FlashBuilderProjectLoadUtil.getClassName(mainClassPathUrl.substring(mainClassPathUrl.lastIndexOf(47) + 1));
    }

    private void setupRoots(ModifiableRootModel rootModel, FlashBuilderProject fbProject) {
        String mainContentEntryUrl = VfsUtilCore.pathToUrl((String)fbProject.getProjectRootPath());
        ContentEntry mainContentEntry = rootModel.addContentEntry(mainContentEntryUrl);
        ArrayList<ContentEntry> otherContentEntries = new ArrayList<ContentEntry>();
        Collection<String> sourcePaths = fbProject.getSourcePaths();
        if (sourcePaths.isEmpty()) {
            VirtualFile contentRoot = mainContentEntry.getFile();
            String mainClass = fbProject.getMainAppClassName();
            if (!(contentRoot == null || StringUtil.isEmpty((String)mainClass) || contentRoot.findChild(mainClass + ".mxml") == null && contentRoot.findChild(mainClass + ".as") == null)) {
                mainContentEntry.addSourceFolder(mainContentEntry.getUrl(), false);
            }
        } else {
            List locales = FlexCommonUtils.getOptionValues((String)fbProject.getAdditionalCompilerOptions(), (String[])new String[]{"locale", "compiler.locale"});
            List moreSourcePaths = FlexCommonUtils.getOptionValues((String)fbProject.getAdditionalCompilerOptions(), (String[])new String[]{"source-path", "compiler.source-path"});
            for (String rawSourcePath : sourcePaths) {
                if (rawSourcePath.contains("{locale}")) {
                    for (String locale : locales) {
                        this.handleRawSourcePath(rootModel, fbProject, mainContentEntryUrl, mainContentEntry, otherContentEntries, rawSourcePath.replace("{locale}", locale));
                    }
                    continue;
                }
                this.handleRawSourcePath(rootModel, fbProject, mainContentEntryUrl, mainContentEntry, otherContentEntries, rawSourcePath);
            }
            for (String sourcePath : moreSourcePaths) {
                if (sourcePath.contains("{locale}")) {
                    for (String locale : locales) {
                        String path = FlashBuilderModuleImporter.getPathToSourceRootSetInAdditionalOptions(sourcePath.replace("{locale}", locale), mainContentEntryUrl, mainContentEntry);
                        if (path == null) continue;
                        this.handleRawSourcePath(rootModel, fbProject, mainContentEntryUrl, mainContentEntry, otherContentEntries, path);
                    }
                    continue;
                }
                String path = FlashBuilderModuleImporter.getPathToSourceRootSetInAdditionalOptions(sourcePath, mainContentEntryUrl, mainContentEntry);
                if (path == null) continue;
                this.handleRawSourcePath(rootModel, fbProject, mainContentEntryUrl, mainContentEntry, otherContentEntries, path);
            }
        }
    }

    @Nullable
    private static String getPathToSourceRootSetInAdditionalOptions(String rawPath, String mainContentEntryUrl, ContentEntry mainContentEntry) {
        String path = rawPath;
        if (new File(path).isDirectory()) {
            return path;
        }
        path = VfsUtilCore.urlToPath((String)mainContentEntryUrl) + "/" + rawPath;
        if (new File(path).isDirectory()) {
            return path;
        }
        if (mainContentEntry.getSourceFolders().length > 0 && new File(path = VfsUtilCore.urlToPath((String)mainContentEntry.getSourceFolders()[0].getUrl()) + "/" + rawPath).isDirectory()) {
            return path;
        }
        return null;
    }

    private void handleRawSourcePath(ModifiableRootModel rootModel, FlashBuilderProject fbProject, String mainContentEntryUrl, ContentEntry mainContentEntry, Collection<ContentEntry> otherContentEntries, String rawSourcePath) {
        String sourcePath = this.getAbsolutePathWithLinksHandled(fbProject, rawSourcePath);
        String sourceUrl = VfsUtilCore.pathToUrl((String)sourcePath);
        if (FileUtil.isAncestor((File)new File(VfsUtilCore.urlToPath((String)mainContentEntryUrl)), (File)new File(VfsUtilCore.urlToPath((String)sourceUrl)), (boolean)false)) {
            FlashBuilderModuleImporter.addSourceRoot(mainContentEntry, sourceUrl);
        } else {
            for (ContentEntry otherContentEntry : otherContentEntries) {
                if (!FileUtil.isAncestor((File)new File(VfsUtilCore.urlToPath((String)mainContentEntryUrl)), (File)new File(VfsUtilCore.urlToPath((String)sourceUrl)), (boolean)false)) continue;
                FlashBuilderModuleImporter.addSourceRoot(otherContentEntry, sourceUrl);
                return;
            }
            ContentEntry newContentEntry = rootModel.addContentEntry(sourceUrl);
            FlashBuilderModuleImporter.addSourceRoot(newContentEntry, sourceUrl);
            otherContentEntries.add(newContentEntry);
        }
    }

    private static void addSourceRoot(ContentEntry contentEntry, String sourceUrl) {
        VirtualFile srcDir = LocalFileSystem.getInstance().findFileByPath(VfsUtilCore.urlToPath((String)sourceUrl));
        final Ref testClassesFound = Ref.create((Object)false);
        final Ref nonTestClassesFound = Ref.create((Object)false);
        if (srcDir != null && !"src".equals(srcDir.getName())) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)srcDir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderModuleImporter$3", "visitFileEx"));
                    }
                    if (((Boolean)nonTestClassesFound.get()).booleanValue()) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderModuleImporter$3", "visitFileEx"));
                        }
                        return result;
                    }
                    if (file.isDirectory()) {
                        if ("flexUnitTests".equals(file.getName())) {
                            testClassesFound.set((Object)true);
                            VirtualFileVisitor.Result result = SKIP_CHILDREN;
                            if (result == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderModuleImporter$3", "visitFileEx"));
                            }
                            return result;
                        }
                        VirtualFileVisitor.Result result = CONTINUE;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderModuleImporter$3", "visitFileEx"));
                        }
                        return result;
                    }
                    String ext = StringUtil.notNullize((String)file.getExtension()).toLowerCase();
                    if ("mxml".equals(ext) || "fxg".equals(ext)) {
                        nonTestClassesFound.set((Object)true);
                    } else if ("as".equals(ext)) {
                        if (file.getNameWithoutExtension().endsWith("Test") || file.getName().contains("Test") && file.getName().contains("Suite")) {
                            testClassesFound.set((Object)true);
                        } else {
                            nonTestClassesFound.set((Object)true);
                        }
                    }
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderModuleImporter$3", "visitFileEx"));
                    }
                    return result;
                }
            });
        }
        boolean isTest = (Boolean)testClassesFound.get() != false && (Boolean)nonTestClassesFound.get() == false;
        contentEntry.addSourceFolder(sourceUrl, isTest);
    }

    private void setupDependencies(ModifiableFlexBuildConfiguration bc, FlashBuilderProject fbProject) {
        block0: for (String libraryPathOrig : fbProject.getLibraryPaths()) {
            for (FlashBuilderProject otherProject : this.myAllFBProjects) {
                if (otherProject == fbProject || !libraryPathOrig.startsWith("/" + otherProject.getName() + "/")) continue;
                ModifiableBuildConfigurationEntry bcEntry = this.myFlexConfigEditor.createBcEntry(bc.getDependencies(), otherProject.getName(), FlashBuilderModuleImporter.suggestMainBCName(otherProject));
                bc.getDependencies().getModifiableEntries().add(0, bcEntry);
                continue block0;
            }
            LibraryTable.ModifiableModel libraryModel = this.myFlexConfigEditor.getLibraryModel(bc.getDependencies());
            Library library = libraryModel.createLibrary(null, FlexLibraryType.FLEX_LIBRARY);
            final LibraryEx.ModifiableModelEx libraryModifiableModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            String libraryId = UUID.randomUUID().toString();
            libraryModifiableModel.setProperties((LibraryProperties)new FlexLibraryProperties(libraryId));
            String libraryPath = this.getAbsolutePathWithLinksHandled(fbProject, libraryPathOrig);
            if (libraryPath.toLowerCase().endsWith(".swc") || libraryPath.toLowerCase().endsWith(".ane")) {
                libraryModifiableModel.addRoot(VirtualFileManager.constructUrl((String)"jar", (String)libraryPath) + "!/", OrderRootType.CLASSES);
            } else {
                libraryModifiableModel.addJarDirectory(VfsUtilCore.pathToUrl((String)libraryPath), false);
            }
            for (String librarySourcePath : fbProject.getLibrarySourcePaths(libraryPathOrig)) {
                libraryModifiableModel.addRoot(VfsUtilCore.pathToUrl((String)this.getAbsolutePathWithLinksHandled(fbProject, librarySourcePath)), OrderRootType.SOURCES);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    libraryModifiableModel.commit();
                }
            });
            ModifiableModuleLibraryEntry libraryEntry = this.myFlexConfigEditor.createModuleLibraryEntry(bc.getDependencies(), libraryId);
            libraryEntry.getDependencyType().setLinkageType(LinkageType.Merged);
            bc.getDependencies().getModifiableEntries().add(libraryEntry);
        }
    }

    private String getAbsolutePathWithLinksHandled(FlashBuilderProject project, String path) {
        boolean absolute;
        String linkValue;
        int slashIndex;
        String potentialLink;
        if (!this.myPathVariablesInitialized) {
            this.initPathVariables();
            this.myPathVariablesInitialized = true;
        }
        String string = potentialLink = (slashIndex = path.indexOf(47)) >= 0 ? path.substring(0, slashIndex) : path;
        if (potentialLink.startsWith("${") && potentialLink.endsWith("}")) {
            String pathVarName = potentialLink.substring(2, potentialLink.length() - 1);
            PathMacros pathMacros = PathMacros.getInstance();
            String pathValue = pathMacros.getValue(pathVarName);
            if (pathValue != null) {
                return pathValue + (slashIndex >= 0 ? path.substring(slashIndex) : "");
            }
            return "$" + pathVarName + "$" + (slashIndex >= 0 ? path.substring(slashIndex) : "");
        }
        Map<String, String> linkedResources = project.getLinkedResources();
        if (!linkedResources.isEmpty() && (linkValue = linkedResources.get(potentialLink)) != null) {
            PathMacros pathMacros = PathMacros.getInstance();
            if (pathMacros.getValue(potentialLink) == null) {
                pathMacros.setMacro(potentialLink, linkValue);
            }
            return linkValue + (slashIndex >= 0 ? path.substring(slashIndex) : "");
        }
        boolean bl = absolute = FileUtil.isAbsolute((String)path) && (SystemInfo.isWindows || new File(path).exists());
        return absolute ? path : project.getProjectRootPath() + (slashIndex == 0 ? "" : "/") + path;
    }

    private void initPathVariables() {
        PathMacros pathMacros = PathMacros.getInstance();
        Map<String, String> myEclipsePathVariables = FlashBuilderModuleImporter.loadEclipsePathVariables(this.mySdkFinder.getWorkspacePath());
        for (String pathVariable : this.myPathVariables) {
            String pathValue = myEclipsePathVariables.get(pathVariable);
            if (pathValue == null) continue;
            pathMacros.setMacro(pathVariable, pathValue);
        }
        ProjectMacrosUtil.checkNonIgnoredMacros((Project)this.myIdeaProject, this.myPathVariables);
    }

    private static Map<String, String> loadEclipsePathVariables(String workspacePath) {
        THashMap eclipsePathVariables = new THashMap();
        VirtualFile prefsFile = LocalFileSystem.getInstance().findFileByPath(workspacePath + CORE_RESOURCES_PREFS_REL_PATH);
        if (prefsFile == null) {
            return eclipsePathVariables;
        }
        Properties properties = new Properties();
        try {
            properties.load(prefsFile.getInputStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(PATHVARIABLE_DOT)) continue;
                eclipsePathVariables.put(key.substring(PATHVARIABLE_DOT.length()), (String)entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return eclipsePathVariables;
    }
}

