/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProject;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectFinder;
import com.intellij.lang.javascript.flex.projectStructure.ui.SelectFlexSdkDialog;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashBuilderSdkFinder {
    static final String DEFAULT_SDK_NAME = "";
    private boolean myInitialized = false;
    private final Project myProject;
    private final String myInitiallySelectedPath;
    private final List<FlashBuilderProject> myAllProjects;
    private String myWorkspacePath;
    private Map<String, String> mySdkNameToRootPath = new HashMap<String, String>();
    private String myAirSdkHome;
    private Sdk mySdk;
    private boolean myDialogWasShown = false;
    private static final String FLEX_SDK_PROPERTY = "com.adobe.flexbuilder.project.flex_sdks";
    private static final String SDKS_ELEMENT = "sdks";
    public static final String SDKS_FOLDER = "sdks";
    private static final String SDK_ELEMENT = "sdk";
    private static final String DEFAULT_SDK_ATTR = "defaultSDK";
    private static final String SDK_NAME_ATTR = "name";
    private static final String SDK_LOCATION_ATTR = "location";

    public FlashBuilderSdkFinder(Project project, String initiallySelectedPath, List<FlashBuilderProject> allProjects) {
        this.myProject = project;
        this.myInitiallySelectedPath = initiallySelectedPath;
        this.myAllProjects = allProjects;
    }

    @Nullable
    public String getWorkspacePath() {
        return this.myInitialized ? this.myWorkspacePath : this.findWorkspacePath();
    }

    @Nullable
    private String findWorkspacePath() {
        THashSet checked = new THashSet();
        String wsPath = FlashBuilderSdkFinder.guessWorkspacePath(this.myInitiallySelectedPath, (Collection<VirtualFile>)checked);
        if (wsPath == null) {
            for (FlashBuilderProject fbProject : this.myAllProjects) {
                wsPath = FlashBuilderSdkFinder.guessWorkspacePath(fbProject.getProjectRootPath(), (Collection<VirtualFile>)checked);
                if (wsPath == null) continue;
                return wsPath;
            }
        }
        return wsPath;
    }

    @Nullable
    private static String guessWorkspacePath(String path, Collection<VirtualFile> checked) {
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
        if (dir != null && !dir.isDirectory()) {
            dir = dir.getParent();
        }
        while (dir != null) {
            if (checked.contains(dir)) {
                return null;
            }
            if (FlashBuilderProjectFinder.isFlashBuilderWorkspace(dir)) {
                return dir.getPath();
            }
            dir = dir.getParent();
        }
        return null;
    }

    @Nullable
    public Sdk findSdk(FlashBuilderProject fbProject) {
        if (!this.myInitialized) {
            this.initialize();
            this.myInitialized = true;
        }
        if (fbProject.isAirSdk() && this.myAirSdkHome != null) {
            return FlexSdkUtils.createOrGetSdk(FlexSdkType2.getInstance(), this.myAirSdkHome);
        }
        String sdkHome = this.mySdkNameToRootPath.get(fbProject.getSdkName());
        if (sdkHome != null) {
            return FlexSdkUtils.createOrGetSdk(FlexSdkType2.getInstance(), sdkHome);
        }
        if (this.myDialogWasShown) {
            return this.mySdk;
        }
        SelectFlexSdkDialog dialog = new SelectFlexSdkDialog(this.myProject, FlexBundle.message("flash.builder.project.import.title", new Object[0]), FlexBundle.message("sdk.for.imported.projects", this.myAllProjects.size()));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            dialog.show();
        } else {
            dialog.close(1);
        }
        this.myDialogWasShown = true;
        this.mySdk = dialog.isOK() ? dialog.getSdk() : null;
        return this.mySdk;
    }

    private void initialize() {
        String fbInstallationPath = FlashBuilderSdkFinder.findFBInstallationPath();
        if (fbInstallationPath != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.initializeAirSdk(fbInstallationPath);
            this.initializeSdksFromFBInstallation(fbInstallationPath);
        }
        this.myWorkspacePath = this.findWorkspacePath();
        if (this.myWorkspacePath != null) {
            this.initSdksConfiguredInWorkspace(this.myWorkspacePath);
        }
    }

    private void initializeAirSdk(@NotNull String fbInstallationPath) {
        File[] airSdkParents;
        if (fbInstallationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fbInstallationPath", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderSdkFinder", "initializeAirSdk"));
        }
        File pluginsDir = new File(fbInstallationPath + "/eclipse/plugins");
        if (!pluginsDir.isDirectory()) {
            return;
        }
        for (File airSdkParent : airSdkParents = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("com.adobe.flash.compiler_");
            }
        })) {
            String airSdkHome = airSdkParent.getPath() + "/AIRSDK";
            if (!FlexSdkType2.getInstance().isValidSdkHome(airSdkHome)) continue;
            this.myAirSdkHome = airSdkHome;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSdksFromFBInstallation(@NotNull String fbInstallationPath) {
        if (fbInstallationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fbInstallationPath", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderSdkFinder", "initializeSdksFromFBInstallation"));
        }
        File sdksDir = new File(fbInstallationPath, "sdks");
        if (!sdksDir.isDirectory()) {
            return;
        }
        String maxVersion = "0";
        for (File sdkDir : sdksDir.listFiles()) {
            if (!sdkDir.isDirectory()) continue;
            File descriptionFile = new File(sdkDir, "flex-sdk-description.xml");
            if (!descriptionFile.isFile()) {
                return;
            }
            String nameElement = "<flex-sdk-description><name>";
            String versionElement = "<flex-sdk-description><version>";
            FileInputStream is = null;
            try {
                String version;
                is = new FileInputStream(descriptionFile);
                Map<String, List<String>> info = FlexUtils.findXMLElements(is, Arrays.asList("<flex-sdk-description><name>", "<flex-sdk-description><version>"));
                List<String> nameInfo = info.get("<flex-sdk-description><name>");
                if (nameInfo.isEmpty()) continue;
                this.mySdkNameToRootPath.put(nameInfo.get(0), FileUtil.toSystemIndependentName((String)sdkDir.getPath()));
                List<String> versionInfo = info.get("<flex-sdk-description><version>");
                if (versionInfo.isEmpty() || StringUtil.compareVersionNumbers((String)(version = versionInfo.get(0)), (String)maxVersion) <= 0) continue;
                maxVersion = version;
                this.mySdkNameToRootPath.put(DEFAULT_SDK_NAME, FileUtil.toSystemIndependentName((String)sdkDir.getPath()));
            }
            catch (IOException iOException) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Nullable
    public static String findFBInstallationPath() {
        File programsDir;
        ArrayList fbDirs = new ArrayList();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File dir) {
                String name = dir.getName();
                return dir.isDirectory() && (name.contains("Flash") || name.contains("Flex")) && name.contains("Builder") && new File(dir, "sdks").isDirectory();
            }
        };
        String programsPath = SystemInfo.isMac ? "/Applications" : (SystemInfo.isWindows ? System.getenv("ProgramFiles") : null);
        File file = programsDir = programsPath == null ? null : new File(programsPath);
        if (programsDir != null && programsDir.isDirectory()) {
            Collections.addAll(fbDirs, programsDir.listFiles(filter));
            File adobeDir = new File(programsDir, "Adobe");
            if (adobeDir.isDirectory()) {
                Collections.addAll(fbDirs, adobeDir.listFiles(filter));
            }
        }
        if (SystemInfo.isWindows) {
            File programs64Dir;
            String programs64Path = System.getenv("ProgramW6432");
            File file2 = programs64Dir = programs64Path == null ? null : new File(programs64Path);
            if (programs64Dir != null && programs64Dir.isDirectory()) {
                Collections.addAll(fbDirs, programs64Dir.listFiles(filter));
                File adobeDir = new File(programs64Dir, "Adobe");
                if (adobeDir.isDirectory()) {
                    Collections.addAll(fbDirs, adobeDir.listFiles(filter));
                }
            }
        }
        if (fbDirs.size() == 0) {
            return null;
        }
        if (fbDirs.size() == 1) {
            return ((File)fbDirs.get(0)).getPath();
        }
        Pair pathAndVersion = null;
        for (File fbDir : fbDirs) {
            String version = FlashBuilderSdkFinder.guessFBVersion(fbDir.getName());
            if (pathAndVersion != null && StringUtil.compareVersionNumbers((String)version, (String)((String)pathAndVersion.second)) <= 0) continue;
            pathAndVersion = Pair.create((Object)fbDir.getPath(), (Object)version);
        }
        assert (pathAndVersion != null);
        return (String)pathAndVersion.first;
    }

    private static String guessFBVersion(String fbInstallFolderName) {
        char ch;
        String suffix = " (64 Bit)";
        String folderName = fbInstallFolderName.endsWith(" (64 Bit)") ? fbInstallFolderName.substring(0, fbInstallFolderName.length() - " (64 Bit)".length()) : fbInstallFolderName;
        StringBuilder b = new StringBuilder();
        for (int i = folderName.length() - 1; i >= 0 && ('.' == (ch = folderName.charAt(i)) || Character.isDigit(ch)); --i) {
            b.insert(0, ch);
        }
        return b.toString();
    }

    private boolean initSdksConfiguredInWorkspace(String fbWorkspacePath) {
        Document sdkInfoDocument = FlashBuilderSdkFinder.loadSdkInfoDocument(fbWorkspacePath);
        if (sdkInfoDocument == null) {
            return false;
        }
        Element sdksElement = sdkInfoDocument.getRootElement();
        if (!sdksElement.getName().equals("sdks")) {
            return false;
        }
        for (Element sdkElement : sdksElement.getChildren(SDK_ELEMENT)) {
            Attribute defaultSdkAttr = sdkElement.getAttribute(DEFAULT_SDK_ATTR);
            Attribute sdkNameAttr = sdkElement.getAttribute(SDK_NAME_ATTR);
            Attribute sdkLocationAttr = sdkElement.getAttribute(SDK_LOCATION_ATTR);
            if (sdkLocationAttr == null) continue;
            if (defaultSdkAttr != null && defaultSdkAttr.getValue().equalsIgnoreCase("true")) {
                this.mySdkNameToRootPath.put(DEFAULT_SDK_NAME, FileUtil.toSystemIndependentName((String)sdkLocationAttr.getValue()));
            }
            if (sdkNameAttr == null) continue;
            this.mySdkNameToRootPath.put(sdkNameAttr.getValue(), FileUtil.toSystemIndependentName((String)sdkLocationAttr.getValue()));
        }
        return true;
    }

    @Nullable
    private static Document loadSdkInfoDocument(String flashBuilderWorkspacePath) {
        try {
            VirtualFile projectPrefsFile = LocalFileSystem.getInstance().findFileByPath(flashBuilderWorkspacePath + "/.metadata/.plugins/org.eclipse.core.runtime/.settings/com.adobe.flexbuilder.project.prefs");
            if (projectPrefsFile == null) {
                return null;
            }
            Properties projectPrefsProperties = new Properties();
            projectPrefsProperties.load(projectPrefsFile.getInputStream());
            String xmlString = projectPrefsProperties.getProperty(FLEX_SDK_PROPERTY);
            if (xmlString == null) {
                return null;
            }
            return JDOMUtil.loadDocument((CharSequence)xmlString);
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
        return null;
    }
}

