/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexQualifiedNameLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID = "flex_qn";
    public static final FlexQualifiedNameLocationProvider INSTANCE = new FlexQualifiedNameLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        JSElement element;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/lang/javascript/flex/flexunit/FlexQualifiedNameLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/flex/flexunit/FlexQualifiedNameLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/flexunit/FlexQualifiedNameLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/flex/flexunit/FlexQualifiedNameLocationProvider", "getLocation"));
        }
        if (PROTOCOL_ID.equals(protocol) && (element = FlexQualifiedNameLocationProvider.findElement(path, project)) != null) {
            List<PsiLocation> list = Collections.singletonList(new PsiLocation(project, (PsiElement)element));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexQualifiedNameLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexQualifiedNameLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private static JSElement findElement(String link, Project project) {
        String qname;
        JavaScriptIndex index;
        String moduleName = link.substring(0, link.indexOf(":"));
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        PsiElement element = ActionScriptClassResolver.findClassByQName(link = link.substring(link.indexOf(":") + 1), index = JavaScriptIndex.getInstance((Project)project), module);
        if (element instanceof JSClass) {
            return (JSElement)element;
        }
        if (element == null && link.contains(".") && link.endsWith("()") && (element = ActionScriptClassResolver.findClassByQName(qname = link.substring(0, link.lastIndexOf(46)), index, module)) instanceof JSClass) {
            String methodName = link.substring(link.lastIndexOf(46) + 1, link.length() - 2);
            return ((JSClass)element).findFunctionByNameAndKind(methodName, JSFunction.FunctionKind.SIMPLE);
        }
        return null;
    }
}

