/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.BuildConfigurationEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.ModuleLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.SdkEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.SharedLibraryEntryImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependenciesImpl
implements ModifiableDependencies {
    private static final LinkageType DEFAULT_FRAMEWORK_LINKAGE = LinkageType.Default;
    @NotNull
    private String myTargetPlayer = "";
    @NotNull
    private ComponentSet myComponentSet = ComponentSet.SparkAndMx;
    @NotNull
    private LinkageType myFrameworkLinkage = DEFAULT_FRAMEWORK_LINKAGE;
    private final List<ModifiableDependencyEntry> myEntries = new ArrayList<ModifiableDependencyEntry>();
    @Nullable
    private SdkEntryImpl mySdk;

    DependenciesImpl() {
    }

    @Override
    @Nullable
    public SdkEntry getSdkEntry() {
        return this.mySdk;
    }

    @Override
    public void setSdkEntry(@Nullable SdkEntry sdk) {
        this.mySdk = (SdkEntryImpl)sdk;
    }

    @Override
    public DependencyEntry[] getEntries() {
        return this.myEntries.toArray(new DependencyEntry[this.myEntries.size()]);
    }

    @Override
    public List<ModifiableDependencyEntry> getModifiableEntries() {
        return this.myEntries;
    }

    @Override
    @NotNull
    public LinkageType getFrameworkLinkage() {
        LinkageType linkageType = this.myFrameworkLinkage;
        if (linkageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "getFrameworkLinkage"));
        }
        return linkageType;
    }

    @Override
    public void setFrameworkLinkage(@NotNull LinkageType frameworkLinkage) {
        if (frameworkLinkage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkLinkage", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "setFrameworkLinkage"));
        }
        this.myFrameworkLinkage = frameworkLinkage;
    }

    @Override
    @NotNull
    public String getTargetPlayer() {
        String string = this.myTargetPlayer;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "getTargetPlayer"));
        }
        return string;
    }

    @Override
    public void setTargetPlayer(@NotNull String targetPlayer) {
        if (targetPlayer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPlayer", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "setTargetPlayer"));
        }
        this.myTargetPlayer = targetPlayer;
    }

    @Override
    public void setComponentSet(@NotNull ComponentSet componentSet) {
        if (componentSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentSet", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "setComponentSet"));
        }
        this.myComponentSet = componentSet;
    }

    @Override
    @NotNull
    public ComponentSet getComponentSet() {
        ComponentSet componentSet = this.myComponentSet;
        if (componentSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "getComponentSet"));
        }
        return componentSet;
    }

    public DependenciesImpl getCopy() {
        DependenciesImpl copy = new DependenciesImpl();
        this.applyTo(copy);
        return copy;
    }

    void applyTo(DependenciesImpl copy) {
        copy.myTargetPlayer = this.myTargetPlayer;
        copy.myComponentSet = this.myComponentSet;
        copy.myFrameworkLinkage = this.myFrameworkLinkage;
        copy.myEntries.clear();
        copy.myEntries.addAll(ContainerUtil.map(this.myEntries, (Function)new Function<ModifiableDependencyEntry, ModifiableDependencyEntry>(){

            public ModifiableDependencyEntry fun(ModifiableDependencyEntry e) {
                if (e instanceof ModuleLibraryEntryImpl) {
                    return ((ModuleLibraryEntryImpl)e).getCopy();
                }
                if (e instanceof SharedLibraryEntryImpl) {
                    return ((SharedLibraryEntryImpl)e).getCopy();
                }
                if (e instanceof BuildConfigurationEntryImpl) {
                    return ((BuildConfigurationEntryImpl)e).getCopy();
                }
                throw new RuntimeException("Unexpected entry type: " + e);
            }
        }));
        copy.mySdk = this.mySdk != null ? this.mySdk.getCopy() : null;
    }

    public boolean isEqual(DependenciesImpl other) {
        if (!other.myTargetPlayer.equals(this.myTargetPlayer)) {
            return false;
        }
        if (other.myComponentSet != this.myComponentSet) {
            return false;
        }
        if (other.myFrameworkLinkage != this.myFrameworkLinkage) {
            return false;
        }
        if (this.myEntries.size() != other.myEntries.size()) {
            return false;
        }
        if (this.mySdk != null ? other.mySdk == null || !this.mySdk.isEqual(other.mySdk) : other.mySdk != null) {
            return false;
        }
        for (int i = 0; i < this.myEntries.size(); ++i) {
            if (this.myEntries.get(i).isEqual(other.myEntries.get(i))) continue;
            return false;
        }
        return true;
    }

    public State getState() {
        State state = new State();
        state.TARGET_PLAYER = this.myTargetPlayer;
        state.COMPONENT_SET = this.myComponentSet;
        state.FRAMEWORK_LINKAGE = this.myFrameworkLinkage.getSerializedText();
        state.ENTRIES = (EntryState[])ContainerUtil.mapNotNull((Object[])this.myEntries.toArray(new ModifiableDependencyEntry[this.myEntries.size()]), (Function)new Function<ModifiableDependencyEntry, EntryState>(){

            public EntryState fun(ModifiableDependencyEntry entry) {
                if (entry instanceof StatefulDependencyEntry) {
                    return ((StatefulDependencyEntry)((Object)entry)).getState();
                }
                throw new RuntimeException("Unexpected entry type: " + entry);
            }
        }, (Object[])new EntryState[0]);
        if (this.mySdk != null) {
            state.SDK = this.mySdk.getState();
        }
        return state;
    }

    public void loadState(@NotNull State state, Project project) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/flex/projectStructure/model/impl/DependenciesImpl", "loadState"));
        }
        this.myTargetPlayer = state.TARGET_PLAYER;
        this.myComponentSet = state.COMPONENT_SET;
        this.myFrameworkLinkage = LinkageType.valueOf((String)state.FRAMEWORK_LINKAGE, (LinkageType)DEFAULT_FRAMEWORK_LINKAGE);
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)project);
        this.myEntries.clear();
        for (EntryState info : state.ENTRIES) {
            StatefulDependencyEntry libraryEntry;
            if (info.LIBRARY_ID != null) {
                libraryEntry = new ModuleLibraryEntryImpl(info.LIBRARY_ID);
                ((ModuleLibraryEntryImpl)libraryEntry).getDependencyType().loadState(info.DEPENDENCY_TYPE);
                this.myEntries.add((ModifiableDependencyEntry)((Object)libraryEntry));
                continue;
            }
            if (info.LIBRARY_NAME != null) {
                libraryEntry = new SharedLibraryEntryImpl(info.LIBRARY_NAME, info.LIBRARY_LEVEL);
                ((SharedLibraryEntryImpl)libraryEntry).getDependencyType().loadState(info.DEPENDENCY_TYPE);
                this.myEntries.add((ModifiableDependencyEntry)((Object)libraryEntry));
                continue;
            }
            if (info.BC_NAME != null) {
                BuildConfigurationEntryImpl bcEntry = new BuildConfigurationEntryImpl(pointerManager.create(info.MODULE_NAME), info.BC_NAME);
                bcEntry.getDependencyType().loadState(info.DEPENDENCY_TYPE);
                this.myEntries.add(bcEntry);
                continue;
            }
            throw new RuntimeException("unknown entry");
        }
        SdkEntryImpl sdkEntryImpl = this.mySdk = state.SDK != null ? new SdkEntryImpl(state.SDK) : null;
        if (this.mySdk != null && this.mySdk.getName().isEmpty()) {
            this.mySdk = null;
        }
    }

    static /* synthetic */ LinkageType access$000() {
        return DEFAULT_FRAMEWORK_LINKAGE;
    }

    @Tag(value="dependencies")
    public static class State {
        @Attribute(value="target-player")
        public String TARGET_PLAYER = "";
        @Attribute(value="component-set")
        public ComponentSet COMPONENT_SET = ComponentSet.SparkAndMx;
        @Attribute(value="framework-linkage")
        public String FRAMEWORK_LINKAGE = DependenciesImpl.access$000().getSerializedText();
        @Tag(value="entries")
        @AbstractCollection(surroundWithTag=false)
        public EntryState[] ENTRIES = new EntryState[0];
        @Property(surroundWithTag=false)
        public SdkEntryImpl.State SDK;
    }
}

