/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBCConfigurator;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompositeConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class ChooseBuildConfigurationDialog
extends DialogWrapper {
    private final Map<Module, List<FlexBCConfigurable>> myTreeItems;
    private Tree myTree;
    private DefaultMutableTreeNode[] mySelection;
    private JLabel myLabel;
    private JPanel myContentPane;
    private final boolean myAllowEmptySelection;

    @Nullable
    public static ChooseBuildConfigurationDialog createForApplicableBCs(String title, @Nullable String labelText, Project project, boolean allowEmptySelection, Condition<FlexBCConfigurable> filter) {
        HashMap treeItems = new HashMap();
        FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
        for (Module module : ModuleStructureConfigurable.getInstance((Project)project).getModules()) {
            if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
            for (CompositeConfigurable configurable : configurator.getBCConfigurables(module)) {
                FlexBCConfigurable flexBCConfigurable = FlexBCConfigurable.unwrap(configurable);
                if (!filter.value((Object)flexBCConfigurable)) continue;
                ArrayList<FlexBCConfigurable> list = (ArrayList<FlexBCConfigurable>)treeItems.get(module);
                if (list == null) {
                    list = new ArrayList<FlexBCConfigurable>();
                    treeItems.put(module, list);
                }
                list.add(flexBCConfigurable);
            }
        }
        if (treeItems.isEmpty()) {
            return null;
        }
        return new ChooseBuildConfigurationDialog(title, labelText, project, allowEmptySelection, (Map<Module, List<FlexBCConfigurable>>)treeItems);
    }

    private ChooseBuildConfigurationDialog(String title, @Nullable String labelText, Project project, boolean allowEmptySelection, Map<Module, List<FlexBCConfigurable>> treeItems) {
        super(project, true);
        this.myAllowEmptySelection = allowEmptySelection;
        this.$$$setupUI$$$();
        if (labelText != null) {
            this.myLabel.setText(labelText);
        } else {
            this.myLabel.setVisible(false);
        }
        this.myTreeItems = treeItems;
        this.setTitle(title);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        ArrayList<Module> modules = new ArrayList<Module>(this.myTreeItems.keySet());
        Collections.sort(modules, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Module module : modules) {
            DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(module, true);
            root.add(moduleNode);
            List<FlexBCConfigurable> bcs = this.myTreeItems.get(module);
            Collections.sort(bcs, new Comparator<FlexBCConfigurable>(){

                @Override
                public int compare(FlexBCConfigurable o1, FlexBCConfigurable o2) {
                    return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
                }
            });
            for (FlexBCConfigurable bc : bcs) {
                DefaultMutableTreeNode bcNode = new DefaultMutableTreeNode(bc, false);
                moduleNode.add(bcNode);
            }
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(root));
        this.myTree.setRootVisible(false);
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                Object lastPathComponent = o.getLastPathComponent();
                return ChooseBuildConfigurationDialog.getText((DefaultMutableTreeNode)lastPathComponent);
            }
        }, true).setComparator(new SpeedSearchComparator(false));
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ChooseBuildConfigurationDialog.this.updateOnSelectionChange();
            }
        });
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                Object object = treeNode.getUserObject();
                if (object instanceof Module) {
                    Module module = (Module)object;
                    this.setIcon(ModuleType.get((Module)module).getIcon());
                    this.append(module.getName());
                } else if (object instanceof FlexBCConfigurable) {
                    FlexBCConfigurable configurable = (FlexBCConfigurable)object;
                    this.setIcon(configurable.getIcon());
                    BCUtils.renderBuildConfiguration(configurable.getEditableObject(), null).appendToComponent((ColoredTextContainer)this);
                }
            }
        });
        TreeUtil.expandAll((JTree)this.myTree);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (ChooseBuildConfigurationDialog.this.mySelection != null) {
                    ChooseBuildConfigurationDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ChooseBuildConfigurationDialog.this.doOKAction();
                }
            }
        });
        this.updateOnSelectionChange();
        return this.myContentPane;
    }

    private void updateOnSelectionChange() {
        this.mySelection = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, (Tree.NodeFilter)new Tree.NodeFilter<DefaultMutableTreeNode>(){

            public boolean accept(DefaultMutableTreeNode node) {
                return node.getUserObject() instanceof FlexBCConfigurable;
            }
        });
        this.setOKActionEnabled(this.myAllowEmptySelection || this.mySelection.length > 0);
    }

    private static String getText(DefaultMutableTreeNode node) {
        Object object = node.getUserObject();
        if (object instanceof Module) {
            Module module = (Module)object;
            return module.getName();
        }
        FlexBCConfigurable configurable = (FlexBCConfigurable)object;
        return configurable.getTreeNodeText();
    }

    public FlexBCConfigurable[] getSelectedConfigurables() {
        if (this.mySelection == null) {
            return new FlexBCConfigurable[0];
        }
        return (FlexBCConfigurable[])ContainerUtil.map2Array((Object[])this.mySelection, FlexBCConfigurable.class, (Function)new Function<DefaultMutableTreeNode, FlexBCConfigurable>(){

            public FlexBCConfigurable fun(DefaultMutableTreeNode node) {
                return (FlexBCConfigurable)node.getUserObject();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JLabel jLabel;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTree = tree = new Tree();
        jBScrollPane.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

