/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkAdditionalData;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class FlexmojosSdkDataConfigurable
implements AdditionalDataConfigurable {
    private Sdk mySdk;
    private final FlexmojosSdkForm myFlexmojosSdkForm = new FlexmojosSdkForm();

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    public JComponent createComponent() {
        return this.myFlexmojosSdkForm.getMainPanel();
    }

    public boolean isModified() {
        FlexmojosSdkAdditionalData data = (FlexmojosSdkAdditionalData)this.mySdk.getSdkAdditionalData();
        if (data != null) {
            if (!this.myFlexmojosSdkForm.getAdlPath().equals(data.getAdlPath())) {
                return true;
            }
            if (!this.myFlexmojosSdkForm.getAirRuntimePath().equals(data.getAirRuntimePath())) {
                return true;
            }
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        FlexmojosSdkAdditionalData data = (FlexmojosSdkAdditionalData)this.mySdk.getSdkAdditionalData();
        if (data != null) {
            data.setAdlPath(this.myFlexmojosSdkForm.getAdlPath());
            data.setAirRuntimePath(this.myFlexmojosSdkForm.getAirRuntimePath());
        }
    }

    public void reset() {
        FlexmojosSdkAdditionalData data = (FlexmojosSdkAdditionalData)this.mySdk.getSdkAdditionalData();
        this.myFlexmojosSdkForm.setFlexCompilerClasspath(data == null ? Collections.emptyList() : data.getFlexCompilerClasspath());
        this.myFlexmojosSdkForm.setAdlPath(data == null ? "" : data.getAdlPath());
        this.myFlexmojosSdkForm.setAirRuntimePath(data == null ? "" : data.getAirRuntimePath());
    }

    public void disposeUIResources() {
    }

    private static class FlexmojosSdkForm {
        private JComponent myMainPanel;
        private JTextArea myClasspathTextArea;
        private LabeledComponent<TextFieldWithBrowseButton> myAdlComponent;
        private LabeledComponent<TextFieldWithBrowseButton> myAirRuntimeComponent;

        private FlexmojosSdkForm() {
            this.$$$setupUI$$$();
            this.initAdlChooser();
            this.initAirRuntimeChooser();
        }

        private void initAdlChooser() {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                    return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || file.getName().startsWith("adl") && this.isExecutableExtension(file.getExtension()));
                }

                private boolean isExecutableExtension(String extension) {
                    return SystemInfo.isWindows ? "exe".equalsIgnoreCase(extension) : extension == null || "uexe".equalsIgnoreCase(extension);
                }
            };
            ((TextFieldWithBrowseButton)this.myAdlComponent.getComponent()).addBrowseFolderListener("Select ADL executable file", null, null, descriptor, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

                public void setText(JTextField component, @NotNull String text) {
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkDataConfigurable$FlexmojosSdkForm$2", "setText"));
                    }
                    component.setText(text);
                    String adlPath = FileUtil.toSystemDependentName((String)text);
                    if (adlPath.endsWith(FlexSdkUtils.ADL_RELATIVE_PATH)) {
                        String runtimePath = adlPath.substring(0, adlPath.length() - FlexSdkUtils.ADL_RELATIVE_PATH.length()) + FlexSdkUtils.AIR_RUNTIME_RELATIVE_PATH;
                        ((TextFieldWithBrowseButton)myAirRuntimeComponent.getComponent()).setText(runtimePath);
                    }
                }

                public String getText(JTextField component) {
                    return component.getText();
                }
            });
        }

        private void initAirRuntimeChooser() {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, false, false, false){

                public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                    return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || "zip".equalsIgnoreCase(file.getExtension()));
                }
            };
            ((TextFieldWithBrowseButton)this.myAirRuntimeComponent.getComponent()).addBrowseFolderListener("Select AIR Runtime", "Select AIR Runtime as a directory like <Flex SDK>/runtimes/AIR/win/ or as a .zip file", null, descriptor);
        }

        JComponent getMainPanel() {
            return this.myMainPanel;
        }

        void setFlexCompilerClasspath(Collection<String> classpathEntries) {
            this.myClasspathTextArea.setText(StringUtil.join(classpathEntries, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return FileUtil.toSystemDependentName((String)s);
                }
            }, (String)"\n"));
        }

        void setAdlPath(String adlPath) {
            ((TextFieldWithBrowseButton)this.myAdlComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)adlPath));
        }

        String getAdlPath() {
            return FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myAdlComponent.getComponent()).getText().trim());
        }

        void setAirRuntimePath(String airRuntimePath) {
            ((TextFieldWithBrowseButton)this.myAirRuntimeComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)airRuntimePath));
        }

        String getAirRuntimePath() {
            return FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myAirRuntimeComponent.getComponent()).getText().trim());
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextArea jTextArea;
            LabeledComponent labeledComponent;
            LabeledComponent labeledComponent2;
            JPanel jPanel = new JPanel();
            this.myMainPanel = jPanel;
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(1, 3, 1, 3), -1, 10, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JSeparator jSeparator = new JSeparator();
            jPanel.add((Component)jSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 7, new Dimension(-1, 10), null, null));
            this.myAdlComponent = labeledComponent2 = new LabeledComponent();
            labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
            labeledComponent2.setText("AIR De&bug Launcher");
            jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            this.myAirRuntimeComponent = labeledComponent = new LabeledComponent();
            labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
            labeledComponent.setText("AIR &Runtime (directory or zip file)");
            jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Flex Compiler/Debugger Classpath:");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            JBScrollPane jBScrollPane = new JBScrollPane();
            jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 6, null, null, null));
            this.myClasspathTextArea = jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setRows(5);
            jTextArea.setEditable(false);
            jTextArea.setWrapStyleWord(false);
            jBScrollPane.setViewportView(jTextArea);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }
    }
}

