/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompilerOptionsConfigurable;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;

public class DeclareConditionalCompilerDefinitionFix
extends FixAndIntentionAction {
    private final Module myModule;
    private final String myConditionalCompilerDefinitionName;

    public DeclareConditionalCompilerDefinitionFix(@NotNull Module module, String conditionalCompilerDefinitionName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/inspections/actionscript/DeclareConditionalCompilerDefinitionFix", "<init>"));
        }
        this.myModule = module;
        this.myConditionalCompilerDefinitionName = conditionalCompilerDefinitionName;
    }

    @NotNull
    public String getName() {
        String string = FlexBundle.message("define.0", this.myConditionalCompilerDefinitionName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/DeclareConditionalCompilerDefinitionFix", "getName"));
        }
        return string;
    }

    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                FlexBuildConfiguration bc = FlexBuildConfigurationManager.getInstance(DeclareConditionalCompilerDefinitionFix.this.myModule).getActiveConfiguration();
                Place place = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getPlaceFor(DeclareConditionalCompilerDefinitionFix.this.myModule, bc.getName()).putPath("tabName", (Object)CompilerOptionsConfigurable.TAB_NAME).putPath("FlashBuildConfiguration.locationOnTab", (Object)CompilerOptionsConfigurable.Location.ConditionalCompilerDefinition).putPath("FlexCompilerOptions.ConditionalCompilerDefinitionName", (Object)DeclareConditionalCompilerDefinitionFix.this.myConditionalCompilerDefinitionName);
                configurable.navigateTo(place, true);
            }
        });
    }
}

