/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.changeSignature.JSCallerChooser;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodNode;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MethodNodeBase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateConstructorFix
extends CreateJSFunctionIntentionAction {
    @NotNull
    private final JSClass myClass;
    private final JSReferenceExpression myRefExpr;
    private final JSCallExpression myNode;

    private CreateConstructorFix(@NotNull JSClass clazz, JSReferenceExpression refExpr, JSCallExpression node) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/validation/fixes/CreateConstructorFix", "<init>"));
        }
        super(clazz.getName(), true);
        this.myClass = clazz;
        this.myRefExpr = refExpr;
        this.myNode = node;
    }

    @Nullable
    public static CreateConstructorFix createIfApplicable(JSCallExpression node) {
        JSReferenceExpression reference;
        JSClass clazz;
        if (node instanceof JSNewExpression) {
            JSExpression methodExpression = node.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                return null;
            }
            PsiElement resolved = ((JSReferenceExpression)methodExpression).resolve();
            if (!(resolved instanceof JSClass) || resolved instanceof XmlBackedJSClass || ((JSClass)resolved).isInterface()) {
                return null;
            }
            clazz = (JSClass)resolved;
            reference = (JSReferenceExpression)methodExpression;
        } else {
            JSExpression methodExpression = node.getMethodExpression();
            if (!(methodExpression instanceof JSSuperExpression)) {
                return null;
            }
            JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)node);
            if (containingClass == null) {
                return null;
            }
            clazz = containingClass.getSuperClasses()[0];
            if (clazz.isInterface()) {
                return null;
            }
            reference = (JSReferenceExpression)clazz.findNameIdentifier().getPsi();
        }
        return new CreateConstructorFix(clazz, reference, node);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        ASTNode lbrace = this.myClass.getNode().findChildByType(JSTokenTypes.LBRACE);
        Pair pair = Pair.create((Object)this.myRefExpr, (Object)lbrace.getPsi());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateConstructorFix", "calculateAnchors"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        final AtomicInteger count = new AtomicInteger();
        ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)this.myClass.getUseScope()).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                return !CreateConstructorFix.isClassInstantiation(psiReference) || count.incrementAndGet() < 2;
            }
        });
        int usages = count.get();
        if (usages < 2) {
            usages += JSInheritanceUtil.findSuperConstructorCalls((JSClass)this.myClass).size();
        }
        if (usages < 2) {
            ArrayList<String> toImport = new ArrayList<String>();
            for (JSExpression argument : this.myNode.getArguments()) {
                String type = JSResolveUtil.getQualifiedExpressionType((JSExpression)argument, (PsiFile)argument.getContainingFile());
                if (!StringUtil.isNotEmpty((String)type) || !ImportUtils.needsImport((JSQualifiedNamedElement)this.myClass, (String)StringUtil.getPackageName((String)type))) continue;
                toImport.add(type);
            }
            AccessToken l = WriteAction.start();
            try {
                FormatFixer formatFixer;
                if (!toImport.isEmpty() && (formatFixer = ImportUtils.insertImportStatements((PsiElement)this.myClass, toImport)) != null) {
                    formatFixer.fixFormat();
                }
                CreateConstructorFix.super.applyFix(project, psiElement, this.myClass.getContainingFile(), CreateConstructorFix.getEditor((Project)this.myClass.getProject(), (PsiFile)this.myClass.getContainingFile()));
            }
            finally {
                l.finish();
            }
        } else {
            String text = "function " + this.myClass.getName() + "(){}";
            JSFunction fakeFunction = (JSFunction)JSChangeUtil.createStatementFromText((Project)project, (String)text, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            new ChangeSignatureFix((PsiElement)fakeFunction, this.myNode.getArguments()){

                protected Pair<Boolean, List<JSParameterInfo>> handleCall(@NotNull JSFunction function, JSExpression[] arguments, boolean dummy) {
                    if (function == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/fixes/CreateConstructorFix$2", "handleCall"));
                    }
                    List parameterInfos = (List)super.handleCall((JSFunction)function, (JSExpression[])arguments, (boolean)dummy).second;
                    return Pair.create((Object)true, (Object)parameterInfos);
                }

                protected JSChangeSignatureDialog createDialog(PsiElement context, final List<JSParameterInfo> paramInfos) {
                    JSMethodDescriptor descriptor = new JSMethodDescriptor(this.myFunction, true){

                        public List<JSParameterInfo> getParameters() {
                            return paramInfos;
                        }
                    };
                    return new MyDialog(descriptor, context);
                }

                protected JSChangeSignatureProcessor createProcessor(List<JSParameterInfo> paramInfos, JSAttributeList attributeList) {
                    return new MyProcessor(this.myFunction, attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL, CreateConstructorFix.this.myClass.getName(), "", paramInfos.toArray(new JSParameterInfo[paramInfos.size()]), Collections.emptySet());
                }
            }.invoke(project, editor, file);
        }
    }

    private static boolean isClassInstantiation(PsiReference psiReference) {
        return psiReference instanceof JSReferenceExpression && ((JSReferenceExpression)psiReference).getParent() instanceof JSNewExpression;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        if (this.constructorShouldBePublic()) {
            template.addTextSegment("public ");
        }
        this.writeFunctionAndName(template, this.myClass.getName(), file, null, referenceExpression);
        template.addTextSegment("(");
        CreateConstructorFix.addParameters((Template)template, (JSArgumentList)this.myNode.getArgumentList(), (PsiElement)this.myNode, (PsiFile)file);
        template.addTextSegment("){");
        this.addBody(template, referenceExpression, file);
        template.addTextSegment("}");
    }

    private boolean constructorShouldBePublic() {
        JSClass contextClass;
        return this.myClass.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC || (contextClass = JSResolveUtil.getClassOfContext((PsiElement)this.myNode)) != null && JSPsiImplUtils.differentPackageName((String)JSResolveUtil.getPackageName((PsiElement)this.myClass), (String)JSResolveUtil.getPackageName((PsiElement)contextClass));
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"javascript.create.constructor.intention.name", (Object[])new Object[]{this.myClass.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateConstructorFix", "getName"));
        }
        return string;
    }

    private class MyProcessor
    extends JSChangeSignatureProcessor {
        public MyProcessor(JSFunction method, JSAttributeList.AccessType visibility, String methodName, String returnType, JSParameterInfo[] parameters, Set<JSFunction> methodsToPropagateParameters) {
            super(method, visibility, methodName, returnType, parameters, methodsToPropagateParameters);
        }

        @NotNull
        protected UsageInfo[] findUsages() {
            Collection declarations = Collections.synchronizedCollection(new com.intellij.util.containers.HashSet());
            final Collection usages = Collections.synchronizedCollection(new com.intellij.util.containers.HashSet());
            ReferencesSearch.search((PsiElement)CreateConstructorFix.this.myClass, (SearchScope)CreateConstructorFix.this.myClass.getUseScope()).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    if (CreateConstructorFix.isClassInstantiation(psiReference)) {
                        PsiElement element = psiReference.getElement();
                        usages.add(new JSChangeSignatureProcessor.OtherUsageInfo(element, null, MyProcessor.this.myParameters, MyProcessor.this.shouldPropagate(element), 0, 0));
                    }
                    return true;
                }
            });
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSClass)CreateConstructorFix.this.myClass)) {
                usages.add(new JSChangeSignatureProcessor.OtherUsageInfo((PsiElement)superCall.getMethodExpression(), null, this.myParameters, this.shouldPropagate((PsiElement)superCall), 0, 0));
            }
            this.findPropagationUsages(declarations, usages);
            ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(declarations);
            result.addAll(usages);
            UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateConstructorFix$MyProcessor", "findUsages"));
            }
            return usageInfoArray;
        }

        protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
            if (usageInfos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/lang/javascript/validation/fixes/CreateConstructorFix$MyProcessor", "performRefactoring"));
            }
            ArrayList<String> toImport = new ArrayList<String>();
            for (JSExpression argument : CreateConstructorFix.this.myNode.getArguments()) {
                String type = JSResolveUtil.getQualifiedExpressionType((JSExpression)argument, (PsiFile)argument.getContainingFile());
                if (!StringUtil.isNotEmpty((String)type) || !ImportUtils.needsImport((JSQualifiedNamedElement)CreateConstructorFix.this.myClass, (String)StringUtil.getPackageName((String)type))) continue;
                toImport.add(type);
            }
            StringBuilder newConstuctorText = new StringBuilder();
            if (CreateConstructorFix.this.constructorShouldBePublic()) {
                newConstuctorText.append("public ");
            }
            newConstuctorText.append("function ").append(CreateConstructorFix.this.myClass.getName());
            JSChangeSignatureDialog.buildParameterListText(Arrays.asList(this.myParameters), (StringBuilder)newConstuctorText, (boolean)true, (DialectOptionHolder)DialectDetector.dialectOfElement((PsiElement)CreateConstructorFix.this.myClass));
            newConstuctorText.append("{}");
            JSFunction constructorPrototype = (JSFunction)JSChangeUtil.createStatementFromText((Project)this.myProject, (String)newConstuctorText.toString(), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            PsiElement newConstuctor = CreateConstructorFix.this.myClass.add((PsiElement)constructorPrototype);
            FormatFixer.create((PsiElement)newConstuctor, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
            if (!toImport.isEmpty()) {
                FormatFixer formatFixer = ImportUtils.insertImportStatements((PsiElement)CreateConstructorFix.this.myClass, toImport);
                if (formatFixer != null) {
                    formatFixer.fixFormat();
                }
                List fixers = ECMAScriptImportOptimizer.executeNoFormat((PsiFile)CreateConstructorFix.this.myClass.getContainingFile());
                FormatFixer.fixAll((List)fixers);
            }
            super.performRefactoring(usageInfos);
        }

        protected String getCommandName() {
            return CreateConstructorFix.this.getName();
        }
    }

    private class MyMethodNode
    extends JSMethodNode {
        public MyMethodNode(JSFunction method, com.intellij.util.containers.HashSet<JSFunction> called, Runnable cancelCallback) {
            super(method, called, CreateConstructorFix.this.myClass.getProject(), cancelCallback);
        }

        protected List<JSFunction> computeCallers() {
            final Collection<PsiReference> refs = Collections.synchronizedCollection(new ArrayList());
            ReferencesSearch.search((PsiElement)CreateConstructorFix.this.myClass, (SearchScope)CreateConstructorFix.this.myClass.getUseScope(), (boolean)true).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    if (CreateConstructorFix.isClassInstantiation(psiReference)) {
                        refs.add(psiReference);
                    }
                    return true;
                }
            });
            HashSet result = new HashSet();
            for (PsiReference reference : refs) {
                this.addCallExpression((JSCallExpression)((JSNewExpression)reference.getElement().getParent()), result);
            }
            for (JSCallExpression superCall : JSInheritanceUtil.findSuperConstructorCalls((JSClass)CreateConstructorFix.this.myClass)) {
                this.addCallExpression(superCall, result);
            }
            return new ArrayList<JSFunction>(result);
        }
    }

    private class MyCallerChooser
    extends JSCallerChooser {
        public MyCallerChooser(JSFunction method, String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
            super(method, method.getProject(), title, treeToReuse, callback);
        }

        protected MethodNodeBase<JSFunction> createTreeNode(JSFunction method, com.intellij.util.containers.HashSet<JSFunction> called, Runnable cancelCallback) {
            return new MyMethodNode(method, called, cancelCallback);
        }
    }

    private class MyDialog
    extends JSChangeSignatureDialog {
        public MyDialog(JSMethodDescriptor descriptor, PsiElement context) {
            super(descriptor, context);
            this.setTitle(JSBundle.message((String)"create.constructor.dialog.title", (Object[])new Object[0]));
        }

        protected CallerChooserBase<JSFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<Set<JSFunction>> callback) {
            return new MyCallerChooser(((JSMethodDescriptor)this.myMethod).getMethod(), title, treeToReuse, callback);
        }

        protected JSChangeSignatureProcessor createRefactoringProcessor() {
            List parameters = this.getParameters();
            return new MyProcessor(((JSMethodDescriptor)this.myMethod).getMethod(), JSAttributeList.AccessType.valueOf((String)((String)this.getVisibility())), CreateConstructorFix.this.myClass.getName(), "", parameters.toArray(new JSParameterInfo[parameters.size()]), this.myMethodsToPropagateParameters != null ? this.myMethodsToPropagateParameters : Collections.emptySet());
        }
    }
}

