/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CdiBeanPsiClassDescriptor
extends AbstractCdiBeanDescriptor<PsiClass> {
    private final PsiClass myPsiClass;

    protected CdiBeanPsiClassDescriptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor", "<init>"));
        }
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public PsiClass getAnnotatedItem() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor", "getAnnotatedItem"));
        }
        return psiClass;
    }

    @Override
    protected PsiClass getDefaultDeploymentType() {
        return this.getAnnotationClass("javax.enterprise.inject.deployment.Production");
    }

    @NotNull
    public List<PsiMethod> getInjectedConstructors() {
        PsiMethod[] methods;
        ArrayList<PsiMethod> constructors = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = this.getAnnotatedItem().getConstructors()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.inject.Inject", (boolean)true)) continue;
            constructors.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = constructors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor", "getInjectedConstructors"));
        }
        return arrayList;
    }

    @NotNull
    public List<PsiMethod> getInjectedMethods() {
        PsiMethod[] methods;
        ArrayList<PsiMethod> injectedMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = this.getAnnotatedItem().getAllMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.inject.Inject", (boolean)true)) continue;
            injectedMethods.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = injectedMethods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor", "getInjectedMethods"));
        }
        return arrayList;
    }

    @NotNull
    public List<ProducerBeanDescriptor> getProducerDescriptors() {
        List list = ContainerUtil.mapNotNull(this.collectProducesPsiMembers(), (Function)new Function<PsiMember, ProducerBeanDescriptor>(){

            public ProducerBeanDescriptor fun(PsiMember psiMember) {
                return CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor", "getProducerDescriptors"));
        }
        return list;
    }

    private List<PsiMember> collectProducesPsiMembers() {
        ArrayList<PsiMember> candidates = new ArrayList<PsiMember>();
        candidates.addAll(this.getProducerMethods());
        candidates.addAll(this.getProducerFields());
        return candidates;
    }

    public List<PsiMethod> getProducerMethods() {
        return CdiCommonUtils.getProducerMethods(this.getAnnotatedItem());
    }

    public List<PsiField> getProducerFields() {
        return CdiCommonUtils.getProducerFields(this.getAnnotatedItem());
    }

    @NotNull
    public List<PsiField> getInjectedFields() {
        ArrayList<PsiField> injectedFields = new ArrayList<PsiField>();
        for (PsiField psiField : this.getAnnotatedItem().getFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, (String)"javax.inject.Inject", (boolean)true)) continue;
            injectedFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = injectedFields;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor", "getInjectedFields"));
        }
        return arrayList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CdiBeanPsiClassDescriptor)) {
            return false;
        }
        CdiBeanPsiClassDescriptor that = (CdiBeanPsiClassDescriptor)o;
        return !(this.myPsiClass != null ? !this.myPsiClass.equals(that.myPsiClass) : that.myPsiClass != null);
    }

    public int hashCode() {
        return this.myPsiClass != null ? this.myPsiClass.hashCode() : 0;
    }
}

