/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiStereotypeRestrictionsInspection
extends CdiBaseInspection {
    @Override
    protected void checkBeanDescriptor(CdiBeanDescriptor descriptor, ProblemsHolder holder) {
        Set<PsiClass> stereotypes = descriptor.getStereotypes();
        CdiStereotypeRestrictionsInspection.checkMultipleStereotypeScopesCollision(descriptor, stereotypes, holder);
    }

    private static void checkMultipleStereotypeScopesCollision(CdiBeanDescriptor descriptor, Set<PsiClass> stereotypes, ProblemsHolder holder) {
        Object psiMember = ((AbstractCdiBeanDescriptor)descriptor).getAnnotatedItem();
        Module module = ModuleUtil.findModuleForPsiElement(psiMember);
        if (module == null || CdiStereotypeRestrictionsInspection.hasOwnScopeAnnotation(psiMember, module) || stereotypes.size() < 2) {
            return;
        }
        if (CdiStereotypeRestrictionsInspection.hasDifferentScopesInStereotypes(stereotypes, module)) {
            Object psiElement = psiMember instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)psiMember).getNameIdentifier() : psiMember;
            holder.registerProblem(psiElement, CdiInspectionBundle.message("CdiStereotypeRestrictionsInspection.differnt.scopes.in.stereotypes", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean hasDifferentScopesInStereotypes(Set<PsiClass> stereotypes, Module module) {
        String commonScopeAnno = null;
        Collection<String> scopeTypesClasses = CdiCommonUtils.getNormalScopeQualifiedNames(module);
        for (PsiClass stereotype : stereotypes) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)stereotype, scopeTypesClasses);
            if (annotation == null) continue;
            if (commonScopeAnno == null) {
                commonScopeAnno = annotation.getQualifiedName();
                continue;
            }
            if (commonScopeAnno.equals(annotation.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOwnScopeAnnotation(PsiMember psiMember, Module module) {
        return AnnotationUtil.findAnnotations((PsiModifierListOwner)psiMember, CdiCommonUtils.getNormalScopeQualifiedNames(module)).length > 0;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.stereotype.restriction.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiStereotypeRestrictionsInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiStereotypeRestrictionsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiStereotypeRestrictionsInspection", "getShortName"));
        }
        return "CdiStereotypeRestrictionsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiStereotypeRestrictionsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

