/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.providers;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CdiImplicitUsageProvider
implements ImplicitUsageProvider {
    private static Collection<String> PARAM_ANNOS = ContainerUtil.newArrayList((Object[])new String[]{"javax.enterprise.event.Observes", "javax.enterprise.inject.Disposes"});

    public boolean isImplicitUsage(PsiElement element) {
        Module module;
        if (element instanceof PsiModifierListOwner && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && CdiCommonUtils.isCdiInstalled(module)) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"javax.inject.Inject", (boolean)false)) {
                return true;
            }
            if (element instanceof PsiMethod) {
                for (PsiParameter parameter : ((PsiMethod)element).getParameterList().getParameters()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, PARAM_ANNOS)) continue;
                    return true;
                }
            }
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), CdiCommonUtils.getBindingTypesQualifiedNames(module)) || AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), CdiCommonUtils.getStereotypeAnnotationNames(module)) || CdiImplicitUsageProvider.isInjectedBeanCandidate(module, element);
        }
        return false;
    }

    private static boolean isInjectedBeanCandidate(@NotNull Module module, @NotNull PsiElement element) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/providers/CdiImplicitUsageProvider", "isInjectedBeanCandidate"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/cdi/providers/CdiImplicitUsageProvider", "isInjectedBeanCandidate"));
        }
        if (element instanceof PsiClass) {
            Set ipTypes = ContainerUtil.map2Set(CdiInjectionUtils.getInjectionPoints(module), (Function)new Function<InjectionPointDescriptor, PsiType>(){

                public PsiType fun(InjectionPointDescriptor descriptor) {
                    return descriptor.getType();
                }
            });
            for (PsiType ipType : ipTypes) {
                if (ipType == null || !ipType.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)((PsiClass)element)))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return this.isImplicitUsage(element);
    }

    public boolean isImplicitWrite(PsiElement element) {
        return this.isImplicitUsage(element);
    }
}

