/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.List;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionStrategy
implements ModelSchemaExtractionStrategy {
    protected <T> void validateType(ModelType<?> modelType, ModelSchemaExtractionContext<T> extractionContext, ModelType<T> type) {
        if (!type.getRawClass().equals(modelType.getConcreteClass())) {
            throw new InvalidManagedModelElementTypeException(extractionContext, String.format("subtyping %s is not supported", modelType.getConcreteClass().getName()));
        }
        if (type.isHasWildcardTypeVariables()) {
            throw new InvalidManagedModelElementTypeException(extractionContext, String.format("type parameter of %s cannot be a wildcard", modelType.getConcreteClass().getName()));
        }
        List<ModelType<?>> typeVariables = type.getTypeVariables();
        if (typeVariables.isEmpty()) {
            throw new InvalidManagedModelElementTypeException(extractionContext, String.format("type parameter of %s has to be specified", modelType.getConcreteClass().getName()));
        }
    }
}

